/* This is a test program used to verify the correct operation	*/
/* of the linked list functions and one or two of the routines	*/
/* in the NUTS program which is now using linked lists.			*/

#include <stdio.h>
#define __USE_BSD
#include <string.h>
#include "lists.h"

#define record_data(str) \
        record(list, str, &list_lines, max_list_lines)

List *list;
int list_lines;			/* Number of items in list */
int max_list_lines;		/* Max. number of items allowed in list */


/* This is the record function from nuts */
/*** Record various messages in a list ***/
void record(list, str, lines, max_lines)
List *list;
char *str;
int *lines;
int max_lines;
{
Node *node;
char *s; 

    if (list == NULL)
        return;

    if (max_lines <= 0)
        return;

    /* The following loop is here on the off-chance that the*/
    /* number of lines that are allowed to be recorded is   */
    /* reduced below number of lines already in the buffer. */
    /* Most of the time it won't do anything at all.        */
    while (*lines > max_lines)
    {
        --(*lines);
        node = NodeRemHead(list);
        NodeDestroy(node);
    }
    
    s = strdup(str);
    if (s != NULL)
    {
        if (*lines < max_lines)
            ++(*lines);
        else
        {
            node = NodeRemHead(list);
            NodeDestroy(node);
        }
        NodeAddTailNew(list, s);
    }
}   
        

char *make_data(int item_number)
{
static char buff[20];
char *data;

	sprintf(buff, "item %-2d", item_number);
	data = strdup(&buff[0]);
	return(data);
}


void print_forward(List *list)
{
Node *node;

	printf("Following next pointers:\n");
	for (node = NodeHead(list); !isEndOfList(list, node); node = NodeNext(node))
		printf("%s ", (char *)NodeData(node));
	printf("\n");
}


void print_reverse(List *list)
{
Node *node;

	printf("Following previous pointers:\n");
	for (node = NodeTail(list); !isEndOfList(list, node); node = NodePrev(node))
		printf("%s ", (char *)NodeData(node));
	printf("\n");
}


/* This will test the forward and reverse */
/* pointers in a linked list.             */
void pointer_test(int items)
{
int i;
char *s;
Node *node;

	/* Add the data to the list */
	printf("Creating a list with %d items...\n", items);
	for (i = 1; i <= items; ++i)
	{
		s = make_data(i);
		NodeAddTailNew(list, s);
	}

	print_forward(list);
	print_reverse(list);

	printf("\nRemoving item from head of list...\n");
	node = NodeRemHead(list);
	NodeDestroy(node);
	print_forward(list);
	print_reverse(list);

	printf("\nRemoving item from tail of list...\n");
	node = NodeRemTail(list);
	NodeDestroy(node);
	print_forward(list);
	print_reverse(list);

	printf("\nRemoving item from middle of list...\n");
	node = NodeHead(list);
	node = NodeNext(node);
	node = NodeNext(node);
	node = NodeNext(node);
	node = NodeRemove(node);
	NodeDestroy(node);
	print_forward(list);
	print_reverse(list);

	printf("\nInserting a new item in to the list...\n");
	s = make_data(11);
	node = NodeHead(list);
	node = NodeNext(node);
	node = NodeNext(node);
	NodeAddNew(node, s);
	print_forward(list);
	print_reverse(list);

	ListRemAll(list);
}


int main(void)
{
int i, item_no;
char *data;

	list = ListCreate();
	if (list == NULL)
		return 0;

	/* First test:                          */
	/* Verify the 'next' pointers of a list */
	pointer_test(10);

	/* Second test:                         */
	/* Verify routine used in the NUTS code */
	list_lines = 0;
	max_list_lines = 5;

	item_no = 0;

	/* Fill the list to capacity */
	for (i = 0; i < max_list_lines; ++i)
	{
		data = make_data(++item_no);
		record_data(data);
	}

	/* Add more items to a full list and */
	/* verify old items are removed.	 */
	data = make_data(++item_no);
	record_data(data);
	data = make_data(++item_no);
	record_data(data);

	NodeDestroy( NodeFind(list, data) );

	/* Reduce size of list and verify */
	/* new item is added but overall  */
	/* size of list is of new size    */
	max_list_lines -= 2;
	data = make_data(++item_no);
	record_data(data);

	/* We are done testing. */
	ListDestroy(list);
	return 0;
}
