/*****************************************************************************
        Neils Unix Talk Server (NUTS) - (C) Neil Robertson 1992-1995
            Last update: 12th January 1995   Version 2.3.0
  
  This version now works with character mode clients.
  
  Feel free to modify to code in any way but remember the original copyright
  is mine - this means you can't sell it or pass it off as your own work!
  This INCLUDES modified source. If wish to sell something don't include ANY
  of my code in whatever it is unless you ask my permission first. 
     If and when you make any changes to the code please leave the original 
  copyright in the code header if you wish to distribute it. For all the
  doubting Thomases out there yes I DO have the copyright to this - automatic
  copyright to any written work or computer software applies in the UK where
  this was written (unlike the states where you have to send something off 
  I think).
  
  Thanks to:
     Darren Seryck - who thought up the name NUTS.
     Simon Culverhouse - for being the bug hunter from hell.
     Steve Guest - my networks lecturer at Loughborough University.
     Dave Temple - the hassled network admin at above uni who told me about
                   the select() function and how to use it.
     Satish Bedi - (another hassled admin) for listening so understandingly 
                   while I explained to him why the comp sci development 
                   machine had to be rebooted for the 3rd time that week.
     The 1992/1993 LUTCHI team - for coming up with the search command idea 
                                 (knew they were good for something :-) )
     Tim Bernhardt - for the internet name resolution code.
     Sven Barzanallana - for some bug fixes and 2.1.1.
     An HP-UX network programming manual - for providing some "help" >:-)
     Trent 96.2 FM - for providing some good music to work to at uni.
     RTC - for giving me a job.
     Anyone who has ever used NUTS.
  
  This program (or its ancestor at any rate) was originally a university 
  project and first went live on the net in November 1992 as Hectic House. 
  Since then it has spread and spread (bit like flu really). :-)
  
  Bug reports, gripes, whines, ideas:
  	Neil Robertson 
  	neil@realtime.demon.co.uk  
     (until I get sacked for spending too much time on this and not on my work
      then it'll be neil@cardboard_box.under.bridge)
  
*****************************************************************************/

#define VERSION "2.3.0"

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/select.h>
#include <sys/socket.h>

/* file and directory definitions */
#define MOTD1		"motd.redirect"

/* Other definitions */
#define MIN_PORT        1024U   /* Absolute minimum value for port number */
#define MAX_PORT        32767U  /* Absolute maximum value for port number */
#ifndef FD_SETSIZE
#define FD_SETSIZE		256
#endif
#define MAX_USERS		50
#define ALARM_TIME		30
#define TIME_OUT		120


/* Function protypes */
void init_structures(void);
int find_free_slot(void);
void user_quit(int user);
void more(int, char *);
void sigcall(int signal);
void reset_alarm(void);
void check_timeout(void);


int port;
int process_id;

/* user structure */
struct
{
	int sock;
	int last_input;
} ustr[MAX_USERS];


/**** START OF FUNCTIONS ****/

/****************************************************************************
	Main function - 
	Sets up TCP sockets, ignores signals, accepts user input and acts as 
	the switching centre for speech output.
*****************************************************************************/
int main(int argc, char **argv)
{
	struct sockaddr_in bind_addr, acc_addr;
	fd_set readmask;		/* readmask for select() */
	int listen_sock, accept_sock;
	int on, user;
	socklen_t size;
	char inpstr[100];

	if (argc != 2)
	{
		printf("Usage: redirect <port>\n\n");
		return(1);
	}

	port = atoi(argv[1]);
	if (port < MIN_PORT || port > MAX_PORT)
	{
		printf("Port number must be in the range of %u to %u.\n", MIN_PORT, MAX_PORT);
		return(1);
	}

	printf("\n -=- NUTS version %s -=-\n(C) Neil Robertson 1992-1995\n\n*** Redirect server booting ***\n\n", VERSION);

/* initialize sockets */
	printf("Initializing sockets on port %d\n", port);
	size = sizeof(struct sockaddr_in);
	if ((listen_sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		perror("\nNUTS: Couldn't open listen socket");
		return(1);
	}
/* Allow reboots even with TIME_WAITS etc on port */
	on = 1;
	setsockopt(listen_sock, SOL_SOCKET, SO_REUSEADDR, (char *) &on, sizeof(on));

	bind_addr.sin_family = AF_INET;
	bind_addr.sin_addr.s_addr = INADDR_ANY;
	bind_addr.sin_port = htons(port);
	if (bind(listen_sock, (struct sockaddr *) &bind_addr, size) == -1)
	{
		perror("\nNUTS: Couldn't bind to port");
		return(1);
	}
	if (listen(listen_sock, 20) == -1)
	{
		perror("\nNUTS: Listen error");
		return(1);
	}

/* initialize functions */
	puts("Initializing structures");
	init_structures();

/* Set socket to non-blocking. Not really needed but it does no harm. */
	fcntl(listen_sock, F_SETFL, O_NONBLOCK);

/* Set to run in background automatically  - no '&' needed */
	switch (fork())
	{
	case -1:
		perror("\nNUTS: Fork failed");
		return(1);
	case 0:
		break;		/* child becomes server */
	default:
		sleep(1);
		return(0);	/* kill parent */
	}

	process_id = getpid();
	printf("\n*** Server running ***\nProcess ID: %d\n\n", process_id);

/* close stdin, out & err to free up some descriptors */
	close(0);
	close(1);
	close(2);

/* Set up alarm & ignore all possible signals. Ok so we shouldnt really ignore 
   signals but I can't think of any usefull trap function to write. */
	reset_alarm();
	signal(SIGILL,  SIG_IGN);
	signal(SIGTRAP, SIG_IGN);
	signal(SIGIOT,  SIG_IGN);
	signal(SIGBUS,  SIG_IGN);
	signal(SIGSEGV, SIG_IGN);
	signal(SIGTSTP, SIG_IGN);
	signal(SIGCONT, SIG_IGN);
	signal(SIGHUP,  SIG_IGN);
	signal(SIGINT,  SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGABRT, SIG_IGN);
	signal(SIGFPE,  SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	signal(SIGURG,  SIG_IGN);
	signal(SIGPIPE, SIG_IGN);
	signal(SIGTTIN, SIG_IGN);
	signal(SIGTTOU, SIG_IGN);
	signal(SIGXCPU, SIG_IGN);


/**** Main program loop. Its a bit too long but what the hell... *****/
	while (1)
	{
		FD_ZERO(&readmask);

		/* set up readmask */
		for (user = 0; user < MAX_USERS; ++user)
		{
			if (ustr[user].sock == -1)
				continue;
			FD_SET(ustr[user].sock, &readmask);
		}
		FD_SET(listen_sock, &readmask);

		/* wait */
		if (select(FD_SETSIZE, &readmask, 0, 0, 0) == -1)
			continue;

		/* check for connection to listen socket */
		if (FD_ISSET(listen_sock, &readmask))
		{
			accept_sock = accept(listen_sock, (struct sockaddr *) &acc_addr, &size);
			more(accept_sock, MOTD1);	/* send first message of the day */

			if ((user = find_free_slot()) == -1)
			{
				close(accept_sock);
				continue;
			}

			ustr[user].sock = accept_sock;
			ustr[user].last_input = time((time_t *) 0);
			write(accept_sock, "Press enter to exit: ", 23);
		}

		/** cycle through users **/
		for (user = 0; user < MAX_USERS; ++user)
		{
			if (ustr[user].sock == -1)
				continue;

			/* see if any data on socket else continue */
			if (!FD_ISSET(ustr[user].sock, &readmask))
				continue;

			/* Read any data from socket and close connection */
			(void)read(ustr[user].sock, inpstr, sizeof(inpstr));
			user_quit(user);
		}
	}

	return(0);	/* Keep the compiler happy */
}


/************************* MISCELLANEOUS FUNCTIONS ***************************/

/*** Init user & area structures ***/
void init_structures(void)
{
	int user;

	for (user = 0; user < MAX_USERS; ++user)
		ustr[user].sock = -1;
}


/*** finds next free user number ***/
int find_free_slot(void)
{
	int user;

	for (user = 0; user < MAX_USERS; ++user)
	{
		if (ustr[user].sock == -1)
			return user;
	}
	return -1;
}


/*** close socket and mark user slot as free ***/
void user_quit(int user)
{
	close(ustr[user].sock);
	ustr[user].sock = -1;
}


/*** Page a file out to user like unix "more" command ***/
void more(int socket, char *filename)
{
	char mess[100];
	FILE *fp;
	int i;

	fp = fopen(filename, "r");
	if (fp == NULL)
		return;

	while (!feof(fp))
	{
		mess[0] = '\0';
		fgets(mess, sizeof(mess) - 1, fp);

		i = strlen(mess)-1;
		mess[i] = '\r';
		mess[++i] = '\n';
		++i;	/* Correct for initial -1 in length */
		write(socket, mess, i);
	}

	fclose(fp);
}


/***************************** EVENT FUNCTIONS *****************************/

/*** switching function ***/
void sigcall(int which_signal)
{
	signal(which_signal, SIG_IGN);
	check_timeout();
	reset_alarm();
}


/*** reset alarm ***/
void reset_alarm(void)
{
	signal(SIGALRM, sigcall);
	alarm(ALARM_TIME);
}


/*** Boot off users who idle too long ***/
void check_timeout(void)
{
	int user, secs;

	for (user = 0; user < MAX_USERS; ++user)
	{
		if (ustr[user].sock == -1)
			continue;

		secs = (int) time((time_t *) 0) - ustr[user].last_input;
		if (secs >= TIME_OUT)
			user_quit(user);
	}
}
