/*****************************************************************************

        Neils Unix Talk Server (NUTS) - (C) Neil Robertson 1992-1995
            Last update: 12th January 1995   Version 2.3.0
  
  This version now works with character mode clients.
  
  Feel free to modify to code in any way but remember the original copyright
  is mine - this means you can't sell it or pass it off as your own work!
  This INCLUDES modified source. If wish to sell something don't include ANY
  of my code in whatever it is unless you ask my permission first.
     If and when you make any changes to the code please leave the original 
  copyright in the code header if you wish to distribute it. For all the
  doubting Thomases out there yes I DO have the copyright to this - automatic
  copyright to any written work or computer software applies in the UK where
  this was written (unlike the States where you have to send something off 
  I think).
  
  Thanks to:
     Darren Seryck - who thought up the name NUTS.
     Simon Culverhouse - for being the bug hunter from hell.
     Steve Guest - my networks lecturer at Loughborough University.
     Dave Temple - the hassled network admin at above uni who told me about
                   the select() function and how to use it.
     Satish Bedi - (another hassled admin) for listening so understandingly 
                   while I explained to him why the comp sci development 
                   machine had to be rebooted for the 3rd time that week.
     The 1992/1993 LUTCHI team - for coming up with the search command idea 
                                 (knew they were good for something :-) )
     Tim Bernhardt - for the internet name resolution code.
     Sven Barzanallana - for some bug fixes and 2.1.1.
     An HP-UX network programming manual - for providing some "help" >:-)
     Trent 96.2 FM - for providing some good music to work to at uni.
     RTC - for giving me a job.
     Anyone who has ever used NUTS.
  
  This program (or its ancestor at any rate) was originally a university 
  project and first went live on the net in November 1992 as Hectic House. 
  Since then it has spread and spread (bit like flu really). :-)
  
  Bug reports, gripes, whines, ideas:
  	Neil Robertson 
  	neil@realtime.demon.co.uk  
     (until I get sacked for spending too much time on this and not on my work
      then it'll be neil@cardboard_box.under.bridge)
  
*****************************************************************************/

/* To enable the specified feature set the value to 1 */
#define	DEBUG_TALKER	0			/* Enable debug mode - won't be run in background */
#define	LOG_CMD			0			/* Log all commands for debugging purposes */
#define	DEBUG_SOCKET	0			/* Enable debug mode for socket stuff */
#define	HONOUR_TELNET	1			/* Enable full telnet support */
#define	DEBUG_TELNET	0			/* Enable some extra debugging information */
#define	NEW_SOCKET_IO	0
#define	NET_DEAD_TO_VORTEX		1	/* Selects message when port closed unexpectedly */

#define	START_NEW_LOG	0			/* Start a new talker log file when the talker starts */
#define	LOG_MULTI_FILES	1			/* Use separate log files for different events */
#define	LOG_DAILY_FILES	1			/* Keep log files dirs based on day of week */

#define	LOG_BOOTER		1			/* Log system user ID of person starting talker */

#define	PORT_WHO		1			/* Set to Enable .find, and .who port */
#define	BIRDDOG_FIND	1			/* Make .find compatible with Birddog's code */
#define	READ_BD_FILES	1			/* Allow read of Birddog style userdata files */
#define	SAVE_BD_FILES	0			/* Save userdata files in Birddog format */
#define	NO_SMAIL_SELF	1			/* Set to prevent users smailing themselves */

#define	SU_PROTECT		0			/* Ensure that named SU users will always be SU's */
#define	LIMIT_PROMOTE	1			/* Allow promotes only up to the level of user doing promote */
#define	SEVERELY_LIMIT_PROMOTE	1	/* Allow promotes up to 1 level below user doing promote */
#define	DEL_AREA_FILES	0			/* Set to delete area files when area is deleted */
#define	GO_CMD_DEFAULT	1			/* Allow .go with no area name to go to entrance? */

#include <stdio.h>
#define	__USE_BSD	1
#ifdef _AIX
#include <sys/select.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>	/* Not needed on Linux */
#include <signal.h>
#include <string.h>
#include <time.h>
#include <crypt.h>
#include <unistd.h>
#include <ctype.h>
#include <limits.h>		/* Needed by Sun OS */
#include <dirent.h>
#include "lists.h"
#if	HONOUR_TELNET
#include "lib/telnet.h"
#endif

#ifdef	USE_WRAPPER
#include <tcpd.h>
#include <syslog.h>
#endif

#if	LOG_BOOTER
#include <pwd.h>
#endif

static char *rcsid = "$Id: nuts230.c,v 4.5 2000/12/20 01:17:44 kcozens Stable $";

char* PROGNAME = "talkerd";

#define VERSION "2.3.0 as greatly altered by Casey"

/* A bit naughty this. It hard codes a username into the talker. This 
   means that anyone without the real userid or effective userid of this 
   person cannot boot your talker. Useful for stopping permission problems 
   on your userdata files. */
/* #define BOOT_OWNER "talker" */

/* Directory definitions */
#if	LOG_MULTI_FILES
#define	LOGDIR		"logs"			/* Needed when using multiple log files */
#endif
#define	ROOMINFODIR	"roominfo"
#define	ATMOSDIR	ROOMINFODIR "/atmos"
#define	HELPDIR		"helpfiles"
#define	MESSDIR		"messboards"
#define	USERDATADIR	"userdata"
#define	USERMAILDIR	"usermail"
#define	PROFILESDIR	"profiles"
#define	TMPDIR		"/tmp"

/* File definitions */
#define	INITFILE	"init_data"
#define	SNAPSHOT_FILE INITFILE ".snapshot"
#define	SYSTEM_LOG	"syslog"
#define	NEWSFILE	"newsfile"
#define	RULESFILE	"rules"
#define	MOTD1		"motd1"
#define	MOTD2		"motd2"
#define	BANFILE_ALL	"banfile.all"
#define	BANFILE_NEW	"banfile.new"
#define	MAPFILE		"mapfile"

/* Names of various log files */
/* Use LOG_NONE for any of the options you do not want logged */
#define LOG_NONE NULL			/* Do not change this value! */

/******************************************************************************/
/* Shows the talker what to log and what not to log, if LOG_MULTI_FILES is    */
/* defined then separate files are created otherwise, everything goes in to   */
/* the file defined by SYSTEM_LOG.                                            */
/******************************************************************************/
/* Any errors - this should always be empty */
#define LOG_ERROR_FILE	"errors"	/* Miscellaneous errors */
#define LOG_BOOT_FILE	"boot"		/* Boot information */
#define LOG_ADMIN_FILE	"admin"		/* Miscellaneous administrative stuff */
#define LOG_AUTH_FILE	"auth"		/* Password and security related items */
#define LOG_MISC_FILE	"misc"		/* Miscellaneus events */
#define LOG_USER_FILE	"newusers"	/* Creation of newusers */

#define LOG_PSWD	LOG_AUTH_FILE	/* Who changed their passwords */
#define LOG_LOGINS	LOG_AUTH_FILE	/* Login and logouts */
#define LOG_OPTIONS	LOG_ADMIN_FILE	/* Who changed what system option */
#define LOG_KILL	LOG_ADMIN_FILE	/* Who killed who */
#define LOG_NUKED	LOG_ADMIN_FILE	/* Who nuked who */
#define LOG_ARREST	LOG_ADMIN_FILE	/* Who (un)arrested who */
#define LOG_BANNED	LOG_ADMIN_FILE	/* Who (un)banned who */
#define LOG_FREEZE	LOG_ADMIN_FILE	/* Who (un)froze which user accounts */
#define LOG_LEVEL	LOG_ADMIN_FILE	/* Who promoted/demoted who */
#define LOG_AREAS	LOG_ADMIN_FILE	/* Who was modifying the areas */
#define LOG_MOVE	LOG_ADMIN_FILE	/* Who moved a user */
#define LOG_ERROR	LOG_ERROR_FILE	/* Logging of miscellaneous errors */
#define LOG_WIPE	LOG_MISC_FILE	/* Who wiped messages off a board */
#define LOG_SMAIL	LOG_MISC_FILE	/* Who smailed who */
#define LOG_GAG		LOG_NONE		/* Who (un)gagged who */
#define LOG_MUZZLE	LOG_NONE		/* Who (un)muzzled who */
#define LOG_STUN	LOG_NONE		/* Who (un)stunned who */


/* Other definitions */
#define MIN_PORT		1024U	/* Absolute minimum value for port number */
#define MAX_PORT		32767U	/* Absolute maximum value for port number */
								/* Must be convertable to a postive int   */
#ifndef FD_SETSIZE
  #define FD_SETSIZE	256
#endif
#define ABS_MAX_USERS	FD_SETSIZE-1 /* Absolute max number of users allowed */
#define MAX_AREAS		200		/* Set a reasonable limit on number of areas */
#define TOPIC_LEN		60
#define DESC_LEN		35
#define NAME_LEN		15
#define	EMAIL_LEN		60		/* Length of e-mail address string */
#define	ONOFF_LEN		60		/* Length of log-on and log-off messages */
#define	ENTER_EXIT_LEN	60		/* Length of area enter/exit messages */
#define	MACRO_LEN		60		/* Length of user defined macro strings */
#define AREA_LABEL_LEN	5
#define AREA_NAME_LEN	16
#define AREA_STATUS_LEN	11		/* Length of longest string for area status */
#define SITE_LEN		80
#define PRINUM			2		/* no. of users in area before it can be made private */
#define PASSWORD_ECHO	0		/* set this to 1 if you want passwords echoed */
#define SALT			"AB"	/* for password encryption */

#define ARR_SIZE		2000

#define	MIN_COLS		40		/* minimum number of screen columns */
#define	MAX_COLS		255		/* maximum number of screen columns */
#define	DEFAULT_COLS	80		/* default number of screen columns */
#define	MIN_ROWS		10		/* minimum number of screen rows */
#define	MAX_ROWS		100		/* maximum number of screen rows */
#define	DEFAULT_ROWS	24		/* default number of screen rows */

#define	CMD_BAD	-1

/* Values used to indicate log in state of users */
#define LOGIN_DONE		0		/* User log in is complete */
#define LOGIN_GET_NAME	1		/* User logging in - Get user name */
#define LOGIN_GET_PSWD	2		/* User logging in - Get password */
#define LOGIN_CONFIRM	3		/* User logging in - Confirm password */

/* Values used to indicate status of areas and their accessability */
/* Do not change the order or values of the following #defines!	   */
#define AREA_STATUS_FIXED		0	/* Area is always public */
#define AREA_STATUS_PUBLIC		1	/* Area is currently public */
#define AREA_STATUS_PRIVATE		2	/* Area is currently private */
#define AREA_STATUS_WIZ_FIXED	3	/* Area is fixed and for wiz only */
#define AREA_STATUS_WIZ_PUBLIC	4	/* Area is public and for wiz only */
#define AREA_STATUS_WIZ_PRIVATE	5	/* Area is private and for wiz only */
#define AREA_STATUS_JAIL		6	/* Area is the jail */

/* Message type definitions */
#define	MSG_TALK	0x0001		/* general chit-chat */
#define	MSG_SHOUT	0x0002		/* shouts and shout emotes */
#define	MSG_TELL	0x0004		/* tells and private emotes */
#define	MSG_ECHO	0x0008		/* output from echo commands */
#define	MSG_LOGON	0x0010		/* SIGN ON and SIGN OFF messages */
#define	MSG_BEEP	0x0020		/* message with a beep to wake a user */
#define	MSG_ATMOS	0x0040		/* system atmosphere messages */
#define	MSG_SYSTEM	0x0080		/* Various types of system messages */
#if	ALLOW_MTELLS
#define	MSG_MTELL	0x0100		/* messages sent to several people at once */
#endif
#define	MSG_WTELL	0x2000		/* tells and emotes to Wiz and SU */
#define	MSG_BCAST	0x4000		/* broadcast messages (always on for users) */
#define	MSG_FORCED	0x8000		/* message that must be shown to users */

#if	ALLOW_MTELLS
#define	MSG_ALL		(MSG_TALK | MSG_SHOUT | MSG_TELL | MSG_ECHO | MSG_LOGON |\
					MSG_BEEP | MSG_ATMOS | MSG_SYSTEM | MSG_BCAST | MSG_MTELL |\
					MSG_FORCED)
#else
#define	MSG_ALL		(MSG_TALK | MSG_SHOUT | MSG_TELL | MSG_ECHO | MSG_LOGON |\
					MSG_BEEP | MSG_ATMOS | MSG_SYSTEM | MSG_BCAST | MSG_FORCED)
#endif
#define	MSG_WALL	(MSG_ALL | MSG_WTELL)		/* For Wiz and SU only */

/* These are the return vaules from the more() routine */
#define MORE_NO_FILE	0		/* Just output text from file */
#define MORE_NOTDONE	1		/* Need to display a line number */
#define MORE_DONE		2		/* Reached end-of-file */

/* These vaules are used by the page_user_output() routine */
#define PGOUT_NEW		0		/* Create temporary file */
#define PGOUT_ADD		1		/* Add text to file */
#define PGOUT_DONE		2		/* Output file to user */


char *days[] = { "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", NULL };

char *months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
				   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", NULL };


/* Area structure */
typedef struct
{
	char label[AREA_LABEL_LEN];
	char name[AREA_NAME_LEN];
	char topic[TOPIC_LEN];

	int status;					/* Indicates the status of the area */
	int mess_num;				/* Number of messages on area message board */

	List *move;					/* List of areas reachable from this one */
	List *conv;					/* List of recorded strings for area */
	int conv_lines;				/* Number of strings recorded in list */
	List *echos;				/* List of recorded echos for area */
	int echo_lines;				/* Number of recorded echos in list */

	unsigned int wiz_only: 1;	/* Set if only wiz and up allowed in area */
	unsigned int searchable: 1;	/* Set if non-wiz can search areas msesages */
	unsigned int linked: 1;		/* Set if the areas message board is linked */
} AREA_DATA;

List *astr;
int num_areas;

/* Structure used to store a users site by name and number*/
/* If no name is available then name[0] == '\0'           */
struct site {
	char addr[16];				/* ddd.ddd.ddd.ddd */
	char name[SITE_LEN];
};

/* User structure */
typedef struct
{
	char name[NAME_LEN];		/* user name */
	char passwd[NAME_LEN];		/* encrypted password */
	char desc[DESC_LEN];		/* user description */
	struct site old_site;		/* previous internet site name and number */
	struct site site;			/* current internet site name and number */
	char gender;				/* Male, female, neuter, or unspecified */
	char email[EMAIL_LEN];		/* User's e-mail address */
	char onmsg[ONOFF_LEN];		/* Message displayed when first logging in */
	char offmsg[ONOFF_LEN];		/* Message displayed just before logging off */
	char entermsg[ENTER_EXIT_LEN];	/* Message displayed when entering an area */
	char exitmsg[ENTER_EXIT_LEN];	/* Message displayed when leaving an area */
	char macro[5][MACRO_LEN];	/* User defined macros */
	long credits_earned;
	long credits_used;
	int user_id;				/* Number of the bit used for ignore user */
	int sock;					/* Socket number */
	AREA_DATA *area;			/* Pointer to area which user is in */
	int level;					/* Users level */
	time_t login;				/* Time of current log in */
	time_t last_on;				/* Last log in time */
	time_t last_off;			/* Last log off time */
	long totaltime;				/* Total login time */
	int freeze_time;			/* -1 = frozen forever, else no. of days */
	int last_input;				/* Time of last input from user */
	int idle_mention;			/* When to show next idling msg. (in minutes) */
	int logging_in;				/* Tracks log in state of the user */
	int attempts;				/* Number of log in attempts remaining */
	AREA_DATA *invite;			/* Pointer to area to which user is invited */
#if	HONOUR_TELNET
	struct tnstat *tn;			/* Used for telnet control */
#else
	unsigned char buff[ARR_SIZE];	/* Input received from user */
	int buffpos;					/* Offset into buff[] */
	int old_buffpos;				/* Previous offset into buff[] */
#endif
	void (*callback)(void);		/* Used if command needs additional feedback */
	char users_file[80];		/* Name of file used by more()/edit() */
	long file_posn;				/* Used by more() function */
	unsigned int msg_num;		/* Used by more() function */

	List *edit_lines;			/* List of lines in edit buffer */
	int edit_cnt;				/* Number of lines in edit list */
	int edit_max;				/* Maximum lines allowed in edit list */
	Node *edit_ptr;				/* Points to current node in edit list */
	int edit_which;				/* Number of line pointed to by edit_ptr */

	int mailmsgs;				/* Number of mail messages in mailbox */
	int lastmail;				/* Number of last mail message read */
	int cols;					/* Number of screen columns */
	int rows;					/* Number of screen rows */
	unsigned int which_msgs;	/* Bitfields stating msg types user allows */
	unsigned int tmp_msgs;		/* Holds 'which_msgs' during profile editing */
	unsigned char ignore[FD_SETSIZE/CHAR_BIT];	/* Used for ignoring users */

	List *tells;				/* stores users private tells and emotes*/
	int tell_lines;				/* Number of strings recorded in list */

	/* These flags are saved in the users data file */
	unsigned int arrested: 1;	/* Set if user is under arrest */
	unsigned int use_bold: 1;	/* Does user want to see highlights? */
	unsigned int wrap: 1;		/* Set if word wrap is enabled */
	unsigned int echo: 1;		/* Does user require character mode echo? */
	unsigned int paging: 1;		/* Set if paging of output is enabled */
	unsigned int prompt: 1;		/* Does user want a prompt? */
	unsigned int muzzled: 1;	/* Set if user not allowed to shout/semote */

	/* These flags are NOT saved in the users data file */
	unsigned int vis: 1;		/* Is user visible? */
	unsigned int afk: 1;		/* Is user away from the keyboard? */
	unsigned int bafk: 1;		/* Boss is nearby - stop output */
	unsigned int noprompt: 1;	/* Temporarily turns off time-of-day prompt */
	unsigned int show_nums: 1;	/* Show message numbers? */
	unsigned int stun: 1;		/* Set if not allowed to issue commands */
	unsigned int gagged: 1;		/* Set if not allowed to shout/semote or talk */
	unsigned int disconnect: 1;	/* Set if user node should be removed */
	unsigned int sock_err: 1;	/* Set if error occured during write to socket */
	unsigned int tmpfile: 1;	/* Set if more() should delete file when done */
	unsigned int pro_enter: 1;	/* Set if user is entering a profile */
} USER_DATA;

List *ulist;					/* Linked list of logged in users */
int num_of_users;				/* A count of the number of users logged in */
Node *nextnode;					/* Next node after this_user in the user list */

/* This is a collection of bits used to assign a user ID number */
/* to users in the process of logging in. The ID number will be */
/* used mainly by ignore related commands and events.			*/
unsigned char user_ids[FD_SETSIZE/CHAR_BIT];

void accept_connection(void);
void get_input(void);
void process_input(unsigned char *);

/* Prototypes for miscellaneous functions */
char *vis_user_name(USER_DATA *);
int init_globals(void);
int read_init_file(void);
int parse_init_section(USER_DATA *, char *);
int parse_areas_section(USER_DATA *, char *);
int parse_topics_section(char *);
int parse_users_section(char *);
int verify_init_data(USER_DATA *);
int messcount(char *);
void prompt(USER_DATA *);
USER_DATA *add_user_data(void);
int banned(struct site *, char *);
time_t user_frozen(USER_DATA *);
void attempts(USER_DATA *);
void login(USER_DATA *);
void user_quit(USER_DATA *);
int more(USER_DATA *, char *);
#if	!HONOUR_TELNET
void echo_off(USER_DATA *);
void echo_on(USER_DATA *);
#endif
void write_syslog(char *, char *, int);
void write_user(USER_DATA *, char *, unsigned int);
void write_alluser(USER_DATA *, char *, AREA_DATA *, int, unsigned int);
void add_user(USER_DATA *);
#if	PORT_WHO
void list_users(USER_DATA *, long, AREA_DATA *);
#else
void list_users(USER_DATA *, int, AREA_DATA *);
#endif
char *skip_blanks(char *);
char *skip_word(char *);
int choose(char *, char *[]);
int get_com_index(char *);
int instr(char *, char *);
int find_num_in_area(AREA_DATA *);
void say_speech(USER_DATA *);
int file_copy(char *, char *);

/* Prototypes for commands and command related functions */
void exec_com(void);
void do_verb(void);
void c_quit(void);
#if	PORT_WHO
void who_cmd(USER_DATA *, int, long);
#else
void who_cmd(USER_DATA *, int);
#endif
void c_who(void);
void c_shout(void);
void c_tell(void);
int  get_ignore(USER_DATA *, USER_DATA *);
void c_listen(void);
void c_ignore(void);
void look_cmd(USER_DATA *);
void c_look(void);
void go(USER_DATA *, int);
void c_go(void);
void c_knock(void);
void c_private(void);
void c_public(void);
void c_invite_user(void);
void c_emote(void);
void c_areas(void);
void c_write_board(void);
void c_etch_board(void);
void c_read_board(void);
void c_wipe_board(void);
void c_user_site(void);
void c_topic(void);
void c_visible(void);
void c_invisible(void);
void c_kill_user(void);
void c_shutdown_talker(void);
void c_search(void);
void c_review(void);
void c_help(void);
void c_broadcast(void);
void c_news(void);
void c_system(void);
void c_move(void);
void c_echo(void);
void c_set_desc(void);
void c_version(void);
void c_edit_profile(void);
void edit_file(void);
void c_examine(void);
void c_people(void);
void c_dmail(void);
void c_rmail(void);
void c_smail(void);
void c_beep(void);
void c_promote(void);
void c_demote(void);
void c_map(void);
void c_change_pass(void);
void c_premote(void);
void c_semote(void);
void c_bansite(void);
void c_unbansite(void);
void c_listbans(void);
void c_prompt(void);
void c_cbuff(void);
void c_afk(void);
void c_rules(void);
void c_muzzle(void);
void c_unmuzzle(void);
void c_set_cmds(void);
void c_wtell(void);
void c_wemote(void);
void c_arrest(void);
void c_unarrest(void);
void c_nuke(void);
void c_sayto(void);
void c_think(void);
void c_pthink(void);
void c_join(void);
void c_gag(void);
void c_ungag(void);
void c_stun(void);
void c_unstun(void);
void c_viewlog(void);
void c_freeze(void);
void c_find(void);
void c_snapshot(void);
void c_sing(void);
void c_suicide(void);

/* Prototypes for other event related functions */
void expire_messages(void);
void signal_handler(int);
void alarm_handler(int);
void shutdown_handler(int);

#define reset_heartbeat()	alarm(heartbeat)

/* User level definitions */
#define DUNCE	0
#define USER	1
#define WIZARD	2
#define SU		3
#define SU_SU	4
#define NOONE	-1			/* Used when no users are allowed to do something */
#define MAGICAL WIZARD		/* Users of this level and up have extra features */

#define	MAX_LEVEL	SU_SU	/* Absolute maximum user level */
#define	CLL			SU		/* Level of user who can log in to a closed port */
#define AREA_MODIFY_LEVEL	SU_SU	/* Level of user who can modify areas */

#define LEVSTR_LEN	8		/* Maximum allowed length of level strings */

char *default_levstr[] = { "DUNCE", "USER", "WIZARD", "SU", "*SU*" };
char *levstr[MAX_LEVEL + 2];


typedef struct
{
	char *string;
	int level;
	void (*func)(void);
} CMD_INFO;

/* The following table contains the list of commands and also */
/* indicates the level a user must have in order to be able to*/
/* be able to execute the command. Alter this data to suit.   */
CMD_INFO cmd_info[] = {
	{ "go",        DUNCE,  c_go },
	{ "help",      DUNCE,  c_help },
	{ "map",       DUNCE,  c_map },
	{ "quit",      DUNCE,  c_quit },
	{ "rules",     DUNCE,  c_rules },
	{ "version",   DUNCE,  c_version },
	{ "afk",       USER,   c_afk },
	{ "areas",     USER,   c_areas },
	{ "bafk",      USER,   c_afk },
	{ "beep",      USER,   c_beep },
	{ "cbuff",     USER,   c_cbuff },
	{ "desc",      USER,   c_set_desc },
	{ "dmail",     USER,   c_dmail },
	{ "emote ; :", USER,   c_emote }, /* Want .e to default to emote */
	{ "echo",      USER,   c_echo },
	{ "entpro",    USER,   c_edit_profile },
	{ "examine",   USER,   c_examine },
#if	PORT_WHO
	{ "find",      USER,   c_find },
#endif
	{ "hug",       USER,   do_verb },
	{ "ignore",    USER,   c_ignore },
	{ "invite",    USER,   c_invite_user },
	{ "join",      USER,   c_join },
	{ "knock",     USER,   c_knock },
	{ "look",      USER,   c_look },
	{ "listen",    USER,   c_listen },
	{ "news",      USER,   c_news },
	{ "premote /", USER,   c_premote },	/* Want .p to default to .premote */
	{ "passwd",    USER,   c_change_pass },
	{ "private",   USER,   c_private },
	{ "profile",   USER,   c_edit_profile },
	{ "pthink",    USER,   c_pthink },
	{ "public",    USER,   c_public },
	{ "rooms",     USER,   c_areas },
	{ "read",      USER,   c_read_board },
	{ "review",    USER,   c_review },
	{ "rmail",     USER,   c_rmail },
	{ "sayto [",   USER,   c_sayto },
	{ "search",    USER,   c_search },
	{ "semote !",  USER,   c_semote },
	{ "set",       USER,   c_set_cmds },
	{ "shout",     USER,   c_shout },
	{ "sing",      USER,   c_sing },
	{ "smail",     USER,   c_smail },
	{ "suicide",   USER,   c_suicide },
	{ "tell >",    USER,   c_tell },
	{ "think",     USER,   c_think },
	{ "topic",     USER,   c_topic },
	{ "twiddle",   USER,   do_verb },
	{ "who",       USER,   c_who },
	{ "wave",      USER,   do_verb },
	{ "write",     USER,   c_write_board },
	{ "arrest",    WIZARD, c_arrest },
	{ "bansite",   WIZARD, c_bansite },
	{ "bcast",     WIZARD, c_broadcast },
	{ "demote",    WIZARD, c_demote },
	{ "etch",      WIZARD, c_etch_board },
	{ "invis",     WIZARD, c_invisible },
	{ "gag",       WIZARD, c_gag },
	{ "kill",      WIZARD, c_kill_user },
	{ "listbans",  WIZARD, c_listbans },
	{ "move",      WIZARD, c_move },
	{ "muzzle",    WIZARD, c_muzzle },
	{ "people",    WIZARD, c_people },
	{ "promote",   WIZARD, c_promote },	/* Want .prom to default to promote */
	{ "prompt",    DUNCE,  c_prompt },
	{ "site",      WIZARD, c_user_site },
	{ "stun",      WIZARD, c_stun },
	{ "system",    WIZARD, c_system },
	{ "unarrest",  WIZARD, c_unarrest },
	{ "ungag",     WIZARD, c_ungag },
	{ "unmuzzle",  WIZARD, c_unmuzzle },
	{ "unstun",    WIZARD, c_unstun },
	{ "vis",       WIZARD, c_visible },
	{ "wemote",    WIZARD, c_wemote },
	{ "wipe",      WIZARD, c_wipe_board },
	{ "wtell",     WIZARD, c_wtell },
	{ "freeze",    SU,     c_freeze },
	{ "nuke",      SU,     c_nuke },
	{ "unbansite", SU,     c_unbansite },
	{ "viewlog",   SU,     c_viewlog },
	{ "shutdown",  SU_SU,  c_shutdown_talker },
	{ "snapshot",  SU_SU,  c_snapshot },
	{ NULL,		MAX_LEVEL, NULL }
};


typedef struct
{
	char *verb;
	char *response;
} VERB_INFO;

/* The following table contains the list of verbs that were  */
/* referenced in the list of commands. A verb is a word used */
/* to indicate an action involving another user. The table   */
/* lists the response to be given. An @ sign is used to show */
/* where the name of the recipient of the action is to be    */
/* inserted (if the action is being done to another user).   */
/* A verb can appear in two consecutive lines. The first line*/
/* is used when no user is named as recipient of the action. */
VERB_INFO verb_info[] = {
	{ "hug",     "walks over and gives @ a big hug" },
	{ "hug",     "passes out hugs to everyone" },
	{ "wave",    "waves hello to everyone" },
	{ "wave",    "waves frantically to @" },
	{ "twiddle", "twiddles their thumbs" },
	{ NULL,	NULL }
};


/* The following two blocks are used by */
/* the .listen and .ignore commands.	*/
typedef struct {
	char *word;		/* Word recognized by .ignore and .listen */
	int mask;		/* Bit to be flipped */
	int level;		/* Minimum required user level */
} LISTEN_CMD_INFO;

/* Don't want the following words to end in 's' as it will ruin */
/* the readibility of the output from the .ignore command.		*/
LISTEN_CMD_INFO listen_cmd_info[] = {	/* In order of most likely use */
	{ "all",	MSG_ALL,	USER },
	{ "logon",	MSG_LOGON,	USER },
	{ "shout",	MSG_SHOUT,	USER },
	{ "tell",	MSG_TELL,	USER },
	{ "echo",	MSG_ECHO,	USER },
	{ "beep",	MSG_BEEP,	USER },
	{ "talk",	MSG_TALK,	USER },
	{ "atmos",	MSG_ATMOS,	USER },
	{ "system",	MSG_SYSTEM,	USER },
#if	ALLOW_MTELLS
	{ "mtell",	MSG_MTELL,	USER },
#endif
	{ "bcast",	MSG_BCAST,	WIZARD },
	{ "wtell",	MSG_WTELL,	WIZARD },
	{ NULL,		MSG_FORCED,	SU }
};


/* Variables used by record() and c_review() */
List *rec_logs;
int log_lines;
int max_log_lines;
List *wiz_tells;
int wiz_lines;
int max_wiz_lines;

#define record_say(area, str) \
		record(area->conv, str, &area->conv_lines, max_area_lines)

#define record_echo(area, str) \
		record(area->echos, str, &area->echo_lines, max_echo_lines)

#define record_tell(user, str) \
		record(user->tells, str, &user->tell_lines, max_tell_lines)

#define record_login(str) \
		record(rec_logs, str, &log_lines, max_log_lines)

#define record_wtell(str) \
		record(wiz_tells, str, &wiz_lines, max_wiz_lines)


/* Global variables used by commands */
USER_DATA *this_user;	/* Points to user data structure for current user */
USER_DATA *which_user;	/* Used by signal_handler() */
char *inpstr;			/* Points to line of text input by current user */

char *areas_status[] = { "fixed", "public", "private", "wiz_fixed",
					 		"wiz_public", "wiz_private", "jail", NULL };
char *yesno[] = { "NO", "YES", NULL };
char *onoff[] = { "OFF", "ON", NULL };
char *ban_type[] = { "new", "all", NULL };

/* Used as part of tell type messages */
char *tell_type1[] = { "ask", "exclaim to", "say to" };
char *tell_type2[] = { "asks", "exclaims to", "says to" };

char *bold_codes[] = { "\033[0m", "\033[1m" };
char *normal_codes[] = { "*", "*" };

char *syserror = "Sorry - a system error has occurred";

/* Declaration of mess[] is big enough to hold max. line length plus */
/* the extra text that is written at the start of mail messages.	 */
char mess[ARR_SIZE+AREA_NAME_LEN+25];	/* functions use mess to send output */

time_t	start_time;		/* The time talker was started */

int listen_sock;		/* The port on which the talker is listening */

int com_index;			/* Offset into cmd_info[] table */
AREA_DATA *jail = NULL;	/* Holds the pointer to area used for the jail */
int login_count;		/* Number of users in middle of logging in */
USER_DATA *shutd = NULL;/* Points to user who issued .shutdown command */

int	process_id;
unsigned int port;
int max_areas;			/* Maximum number of areas allowed */
int	max_users;			/* This must NOT be greater than FD_SETSIZE - 1 */

int max_attempts;		/* maximum allowed number of login attempts */

int system_open;		/* Are users of any level allowed to login? */
int allow_new;			/* Are new users allowed? */
int min_login_lvl;		/* Minimum level of users allowed to login to this port */
int init_user_lvl;		/* Default level for users logging in for the first time */
int no_logout_lvl;		/* Minimum level for users who can not be auto-logged out */
int login_show_lvl;		/* Enable showing of user level before 'SIGN ON' */
int login_show_min;		/* Minimum level that will be shown at login */

int profile_lines;		/* Number of profile lines user can store */
int max_area_lines;		/* Max. lines to hold in area conversation buffer */
int max_echo_lines;		/* Max. lines to hold in echo buffer */
int max_tell_lines;		/* Max. number of tells to record keep per user */
int max_log_lines;		/* Max. number of login/logouts to record */
int max_wiz_lines;		/* Max. number of wizard tell/emotes to record */

int atmos_on;			/* Enable display of area atmosphere messages */
int allow_bold;			/* Allow the use of ^ to mark text to show in bold */
int prevent_fakes;		/* Prevent fake system messages and messages from other users */
int show_examines;		/* Tell a user which other user .examined them */
int show_whispers;		/* Show as whispering who is sending tells to whom */
int show_ignores;		/* Show everyone message types user will ignore/see */
int show_user_ign;		/* Tell a user they are being ignored */

/* The next items are used in check_timeout(). Times are in seconds */
int heartbeat;			/* alarm time in seconds (must not exceed 60) */
int login_timeout;		/* login time out - can't be less than heartbeat */
int idle_mention;		/* Time (in minutes) before eyes glaze over */
int idle_warning;		/* Time (in minutes) to start auto-logout warnings */
int idle_logout;		/* Time (in minutes) to log out an idle user */
int message_life;		/* Message lifetime in days */

int syslog_on;			/* Enable logging of various events */

#ifdef	USE_WRAPPER
int allow_severity = LOG_WARNING;	/* Run-time settable */
int deny_severity  = LOG_WARNING;
#endif

/* Information regarding global variables and parsing */
/* of the file containing the initialization data.	  */

#define	INIT_HEADER		"init:"
#define	AREAS_HEADER	"areas:"
#define	TOPICS_HEADER	"topics:"
#define	USERS_HEADER	"users:"
char *section_heads[] = { INIT_HEADER, AREAS_HEADER, TOPICS_HEADER, USERS_HEADER, NULL };

enum VAR_TYPE { Bool, Int, Uint, Level, Levstr };

typedef struct
{
	unsigned int	level;
	char *word;
	void *var;
	enum VAR_TYPE	var_type;
	int  min;
	int  max;
	int  init_value;
} GLOBAL_DATA;

/* 0 is allowed here for port number as an indication that	*/
/* port number has not yet been set to a valid value.		*/
GLOBAL_DATA	global_data[] = {
	{NOONE, "port",				&port,			Uint, 0, MAX_PORT, 0 },
	{NOONE, "areas",			&max_areas,		Int,  0, MAX_AREAS, MAX_AREAS },
	{SU_SU, "users",			&max_users,		Int,  1,ABS_MAX_USERS, 35 },
	{SU_SU, "attempts",			&max_attempts,	Int,  1,  10,	3 },
/* Do NOT change the CLL level reference here. Instead change its #define */
	{  CLL, "open_system",		&system_open,	Bool, 0,   1,	1 },
	{	SU, "new_users",		&allow_new,		Bool, 0,   1,	1 },
	{SU_SU, "min_login_level",	&min_login_lvl, Level,	DUNCE,	SU,   USER },
	{SU_SU, "init_user_level",	&init_user_lvl, Level,	DUNCE,	USER, USER },
	{SU_SU, "no_logout_level",	&no_logout_lvl, Level,	DUNCE,	SU,   SU },
	{SU_SU, "login_show_level",	&login_show_lvl,Bool, 0,   1,   1 },
	{SU_SU, "login_show_min",	&login_show_min,Level,	DUNCE,	SU,	  WIZARD },
	{SU_SU, "profile_lines",	&profile_lines,	Int,  0, 100,  15 },
	{SU_SU, "area_lines",		&max_area_lines,Int,  0, 100,  20 },
	{SU_SU, "echo_lines",		&max_echo_lines,Int,  0, 100,  20 },
	{SU_SU, "tell_lines",		&max_tell_lines,Int,  0, 100,  20 },
	{SU_SU, "log_lines",		&max_log_lines,	Int,  0, 100,  20 },
	{SU_SU, "wiz_lines",		&max_wiz_lines,	Int,  0, 100,  20 },
	{	SU, "atmosphere",		&atmos_on,		Bool, 0,   1,   1 },	
	{SU_SU, "prevent_fakes",	&prevent_fakes,	Bool, 0,   1,   1 },
	{SU_SU, "bold_allowed",		&allow_bold,	Bool, 0,   1,   1 },
	{	SU, "whispers",			&show_whispers,	Bool, 0,   1,   0 },
	{	SU, "ignores",			&show_ignores,	Bool, 0,   1,   0 },
	{	SU, "user_ignores",		&show_user_ign,	Bool, 0,   1,   0 },
	{	SU, "examines",			&show_examines,	Bool, 0,   1,   0 },
	{NOONE, "heartbeat",		&heartbeat,		Int, 15,  60,  30 },	/* Main timer (in seconds) */
	{NOONE, "timeout_login",	&login_timeout,	Int, 30, 600, 180 },	/* A multiple of heartbeat */
	{SU_SU, "idle_mention",		&idle_mention,	Int,  0,  30,   5 },	/* Time for eyes to glaze */
	{SU_SU, "idle_warn",		&idle_warning,	Int,  0,  60,  15 },	/* Warn of auto logout in x minutes */
	{SU_SU, "idle_logout",		&idle_logout,	Int,  0,  60,  30 },    /* Log-out after x minutes inactivity */
	{SU_SU, "lifetime",			&message_life,	Int,  1,  30,   5 },	
	{SU_SU, "logging",			&syslog_on,		Bool, 0,   1,   1 },	
	{SU_SU, "level0",			NULL,		 Levstr,  0,   0,   0 },	
	{SU_SU, "level1",			NULL,		 Levstr,  1,   1,   1 },	
	{SU_SU, "level2",			NULL,		 Levstr,  2,   2,   2 },	
	{SU_SU, "level3",			NULL,		 Levstr,  3,   3,   3 },	
	{SU_SU, "level4",			NULL,		 Levstr,  4,   4,   4 },	
	{SU_SU, NULL,				NULL,			Int, -1,  -1,   0 }
};


/* Information used in the processing of the userdata files */
enum USERFILE_ENUM {
	Pswd,	Times,	Site,	Desc,	UF_Lvl,	Mail,	Cols,	Rows,
	Flags,	Ignores,Credits,Gender,	Email,	Onmsg,	Offmsg, Enter,
	Exit,	Macro1,	Macro2,	Macro3,	Macro4,	Macro5
};

typedef struct
{
	char *word;
	enum USERFILE_ENUM uf_type;
} USERFILE_DATA;

/* Strings must start with lower case letter */
USERFILE_DATA uf_data[] = {
{ "pswd",	Pswd },
{ "times",	Times },
{ "site",	Site },
{ "desc",	Desc },
{ "level",	UF_Lvl },
{ "mail",	Mail },
{ "cols",	Cols },
{ "rows",	Rows },
{ "flags",	Flags },
{ "ignores",Ignores },
{ "credits",Credits },
{ "gender",	Gender },
{ "email",	Email },
{ "onmsg",	Onmsg },
{ "offmsg",	Offmsg },
{ "enter",	Enter },
{ "exit",	Exit },
{ "m1",		Macro1 },
{ "m2",		Macro2 },
{ "m3",		Macro3 },
{ "m4",		Macro4 },
{ "m5",		Macro5 },
{ NULL,		Macro5 }
};


/**** START OF FUNCTIONS ****/

/****************************************************************************
	Main function - 
	Sets up TCP sockets, ignores signals, accepts user input and acts as 
	the switching centre for speech output.
*****************************************************************************/
int main(void)
{
	struct sockaddr_in bind_addr;
	fd_set readmask;		/* read mask for select() */
#if	HONOUR_TELNET
	fd_set exceptmask;		/* exception mask for select() */
#endif
	int on, result;
	Node *node;
#if LOG_BOOTER
	uid_t euid, uid;
	struct passwd *booter;
	char name[20], ename[20];
#if BOOT_OWNER
	struct passwd *named;
#endif
#endif

	printf("\n-=- NUTS version %5s (rev %.*s) -=-\n(C) Neil Robertson 1992-1995\n\n",
			VERSION, rcsid[20] == ' ' ? 3 : 4, &rcsid[17]);

	printf("*** Talk server booting ***\n\n");
	write_syslog("*** Talker BOOTING ***\n", LOG_BOOT_FILE, 0);

	puts("Initializing global variables...");
	if (init_globals())
	{
		printf("Error initializing global variables\n");
		exit(1);
	}

/* For now, we can only start new log files if we are using only one ~~~~~ */
#if	!LOG_MULTI_FILES
#if	START_NEW_LOG
	/* Make old system log backup */
	sprintf(filename, "%s.bak", SYSTEM_LOG);
	if (file_copy(SYSTEM_LOG, filename) == -1)
		printf("NUTS: Warning: Couldn't make backup of old system log\n\n");
	unlink(SYSTEM_LOG);
#endif
#endif

/* read system data */
	puts("Reading initialization data file...");
	if ( read_init_file() )
	{
		strcpy(mess, "BOOT FAILED: Errors were detected reading initialization data\n");
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		exit(1);
	}

	puts("Verifying initialization data...");
	if ( verify_init_data(NULL) )
	{
		strcpy(mess, "BOOT FAILED: Errors were detected in initialization data\n");
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		exit(1);
	}

/* initialize sockets */
	printf("Initializing sockets on port %u\n", port);
	if ((listen_sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		perror("\nNUTS: Couldn't open listen socket");
		write_syslog("BOOT FAILED: Couldn't open listen socket\n", LOG_BOOT_FILE, 0);
		exit(1);
	}

/* Allow reboots even with TIME_WAITS etc on port */
	on = 1;
	result = setsockopt(listen_sock, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
#if	DEBUG_SOCKET
	if (result == -1)
	{
		sprintf(mess, "Couldn't set listen socket to SO_REUSEADDR\n");
		write_syslog(mess, LOG_ERROR, 1);
	}
#endif

/* Set socket to non-blocking. Not really needed but it does no harm. */
	result = fcntl(listen_sock, F_SETFL, O_NONBLOCK);
#if	DEBUG_SOCKET
	if (result == -1)
	{
		sprintf(mess, "Couldn't set listen socket to O_NONBLOCK\n");
		write_syslog(mess, LOG_ERROR, 1);
	}
#endif

	bind_addr.sin_port = htons(port);
	bind_addr.sin_family = AF_INET;
	bind_addr.sin_addr.s_addr = INADDR_ANY;
	if (bind(listen_sock, (struct sockaddr *) &bind_addr, sizeof(bind_addr)) == -1)
	{
		perror("\nNUTS: Couldn't bind to port");
		write_syslog("BOOT FAILED: Couldn't bind to port\n", LOG_BOOT_FILE, 0);
		exit(1);
	}
	if (listen(listen_sock, 20) == -1)	/* Allow up to 20 pending connections */
	{
		perror("\nNUTS: Listen error");
		write_syslog("BOOT FAILED: Listen error", LOG_BOOT_FILE, 0);
		exit(1);
	}

#if LOG_BOOTER
	uid = getuid();
	booter = getpwuid( uid );
	strncpy(name, booter->pw_name, sizeof(name));
	name[sizeof(name) - 1] = '\0';

	euid = geteuid();
	booter = getpwuid (euid);
	strncpy(ename, booter->pw_name, sizeof(ename));
	ename[sizeof(ename) - 1] = '\0';

#if BOOT_OWNER
	/* At this point we should be ready to rock and roll */
	/* so it should be safe at this point to record boot */
	named = getpwnam(BOOT_OWNER);
	if (named == NULL)	/* named user is bad */
	{
		sprintf(mess, "Unknown owner `%s', boot permission denied\n", BOOT_OWNER);
		fprintf(stderr, "%s: %s", PROGNAME, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return -1;
	}

	if (named->pw_uid != uid && named->pw_uid != euid)
	{
		fprintf(stderr, "%s: Permission to boot denied!\n", PROGNAME);
		sprintf(mess, "WARNING: %s (effective user: %s) tried to boot the talker\n",
				name, ename);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return -1;
	}
#endif

	sprintf(mess, "*** Booted by %s (effective: %s)\n", name, ename);
	write_syslog(mess, LOG_BOOT_FILE, 0);
#endif

/* initialize functions */
	puts("Expiring out of date messages...");
	expire_messages();

#if	!DEBUG_TALKER
/* Set to run in background automatically - no '&' needed */
	switch (fork())
	{
	case -1:
		perror("\nNUTS: Fork failed");
		write_syslog("BOOT FAILED: Fork failed\n", LOG_BOOT_FILE, 0);
		exit(1);
	case 0:
		break;		/* child becomes server */
	default:
		sleep(1);
		exit(0);	/* kill parent */
	}
#endif
	process_id = getpid();

/* log startup */
	start_time = time(NULL);
	sprintf(mess, "*** Talker started %.24s (port %u, PID %d) ***\n",
			ctime(&start_time), port, process_id);
	write_syslog(mess, LOG_BOOT_FILE, 0);
	printf("\n*** Server running ***\nProcess ID: %d\n\n", process_id);

/* close stdin, out & err to free up some descriptors */
	close(0);
	close(1);
	close(2);

/* Set up alarm & ignore all possible signals. Ok, so we shouldn't really */
/* ignore signals but I can't think of any useful trap function to write. */
	signal(SIGHUP,  signal_handler);	/* These are POSIX.1 signals */
	signal(SIGINT,  SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGILL,  SIG_IGN);
#if	0	/* Allow these during testing just in case ~~~~~ */
	signal(SIGABRT, SIG_IGN);
	signal(SIGFPE,  SIG_IGN);
	signal(SIGSEGV, SIG_IGN);
#endif
#if	NEW_SOCKET_IO
	signal(SIGPIPE, signal_handler);
#else
	signal(SIGPIPE, SIG_IGN);
#endif
	signal(SIGALRM, alarm_handler);
	signal(SIGTERM, signal_handler);
	signal(SIGCONT, SIG_IGN);
	signal(SIGTSTP, SIG_IGN);
	signal(SIGTTIN, SIG_IGN);
	signal(SIGTTOU, SIG_IGN);

	signal(SIGTRAP, SIG_IGN);		/* Other non-POSIX.1 assorted signals */
	signal(SIGIOT,  SIG_IGN);
	signal(SIGBUS,  SIG_IGN);
	signal(SIGURG,  SIG_IGN);
	signal(SIGXCPU, SIG_IGN);
	reset_heartbeat();

#if	PORT_WHO
	list_users(NULL, -1, NULL);	/* Create initial who file */
#endif

/**** Main program loop. Its a bit too long but what the hell... *****/

	while (1)
	{
		FD_ZERO(&readmask);
#if	HONOUR_TELNET
		FD_ZERO(&exceptmask);
#endif

		/* Set up readmask. 'this_user' is set to non NULL */
		/* before entering a loop to avoid possibility that*/
		/* the timer goes off inside the following loop    */
		/* just before this_user is set and a user node is */
		/* removed which this loop is about to try and use.*/
		this_user = (USER_DATA *)NodeHead(ulist);	/* Don't remove! */

		node = NodeHead(ulist);
		while (!isEndOfList(ulist, node))
		{
			this_user = (USER_DATA *)NodeData(node);
			node = NodeNext(node);

			/* Remove any user where an error was detected	*/
			/* or where the user timed out.					*/
			if (this_user->sock_err || this_user->disconnect)
			{
				user_quit(this_user);
				continue;
			}

			FD_SET(this_user->sock, &readmask);
#if	HONOUR_TELNET
			FD_SET(this_user->sock, &exceptmask);
#endif
		}
		FD_SET(listen_sock, &readmask);

		/* Let check_timeout() know we aren't dealing with any user */
		this_user = NULL;

		/* wait */
#if	HONOUR_TELNET
		if (select(FD_SETSIZE, &readmask, NULL, &exceptmask, NULL) == -1)
#else
		if (select(FD_SETSIZE, &readmask, NULL, NULL, NULL) == -1)
#endif
			continue;

		/* check for connection to listen socket */
		if (FD_ISSET(listen_sock, &readmask))
			accept_connection();

		/* Cycle through users but be careful because a node*/
		/* could disappear if a user quits, is killed, or is*/
		/* nuked leaving us with no valid next node pointer.*/
		this_user = (USER_DATA *)NodeData( NodeHead(ulist) );	/* Don't remove! */
		node = NodeHead(ulist);
		while (!isEndOfList(ulist, node))
		{
			this_user = (USER_DATA *)NodeData(node);
			nextnode = NodeNext(node);

			/* Ignore user if error or marked for disconnect */
			if ( !(this_user->sock_err || this_user->disconnect) )
			{
#if	HONOUR_TELNET
				if (FD_ISSET(this_user->sock, &exceptmask))
					tnsynch(this_user->tn);
#endif
				/* see if any data on socket else continue */
				if (FD_ISSET(this_user->sock, &readmask))
#if	HONOUR_TELNET
					tnreadsocket(this_user->tn);
#else
					get_input();
#endif
			}

			node = nextnode;
		}

		/* Let check_timeout() know we aren't dealing with any user */
		this_user = NULL;
	}	/* end of for loop */

	return 0;
}


/* This routine is called when a socket read fails */
void dead_socket(void)
{
	if (this_user->logging_in == LOGIN_DONE)
	{
#if	NET_DEAD_TO_VORTEX
		sprintf(mess, "%s is pulled in to a swirling black vortex\n", vis_user_name(this_user));
#else
		sprintf(mess, "%s is eaten by the net dead monster\n", vis_user_name(this_user));
#endif
		write_alluser(this_user, mess, 0, 0, MSG_SYSTEM);
	}

	this_user->sock_err = 1;
}

#if HONOUR_TELNET
void tnoptchanged(struct tnstat* ptr, enum tnoset state, unsigned char opt)
{
	if (opt==TNLineMode && state==THEYARE)
		tn_lm_mode_set(ptr);
}

/* This callback function handles data received during NAWS negotiation */
void new_screen_size(int cols, int rows)
{
	/* The if statements shouldn't be needed but will protect against */
	/* telnet programs that don't properly support NAWS negotiation.  */
	if (cols > 0)
		this_user->cols = cols;
	if (rows > 0)
		this_user->rows = rows;
}
#endif


/*** Create a string with users site information ***/
char *print_site(struct site *site)
{
	static char buff[SITE_LEN + 16];

	if (site->name[0] && site->addr[0])
		sprintf(buff, "%s (%s)", site->name, site->addr);
	else
		sprintf(buff, "%s",
				site->name[0] ? site->name : site->addr);

	return buff;
}


/*** Check for connection to listen socket ***/
void accept_connection(void)
{
	struct sockaddr_in acc_addr;
	struct hostent *host;
	int accept_sock;
	unsigned int size;
	int on, result;
#ifdef  USE_WRAPPER
	struct request_info request;    /* TCP wrapper security */
#endif

	size = sizeof(acc_addr);
	memset(&acc_addr, 0, (size_t) size);

	accept_sock = accept(listen_sock, (struct sockaddr *)&acc_addr, &size);
	on = 1;
	result = setsockopt(accept_sock, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
#if	DEBUG_SOCKET
	if (result == -1)
	{
		sprintf(mess, "Couldn't set new socket to SO_REUSEADDR\n");
		write_syslog(mess, LOG_ERROR, 1);
	}
#endif
	result = fcntl(accept_sock, F_SETFL, O_NONBLOCK);
#if	DEBUG_SOCKET
	if (result == -1)
	{
		sprintf(mess, "Couldn't set new socket to O_NONBLOCK\n");
		write_syslog(mess, LOG_ERROR, 1);
	}
#endif

#ifdef USE_WRAPPER
	request_init(&request,RQ_DAEMON,"talker",RQ_FILE,accept_sock,0);
	fromhost(&request);

#ifdef PARANOID
	if (STR_EQ(eval_hostname(request.client),paranoid))
	{
		close(accept_sock);
		return;
	}
#endif

	if (!hosts_access(&request))
	{
		close(accept_sock);
		return;
	}
#endif

	this_user = add_user_data();			/* This sets last_input value */
	if (this_user == NULL)
	{
		strcpy(mess, "\nSorry - Unable to handle more users at the present time\n\n");
		write(accept_sock, mess, strlen(mess));
		close(accept_sock);
		return;
	}
	this_user->sock = accept_sock;			/* Set this AFTER last_input */

	/* Get numeric address of new users internet site */
	strcpy(this_user->site.addr, inet_ntoa(acc_addr.sin_addr));

	if ( (host = gethostbyaddr((char *)&acc_addr.sin_addr, sizeof(struct in_addr), AF_INET)) == NULL )
		this_user->site.name[0] = '\0';				/* Users site has no name */
	else
		strcpy(this_user->site.name, host->h_name);	/* Copy sites name */

#if	HONOUR_TELNET
	/* This telnet negotiation stuff should be made a separate routine ~~~~~ */
	on = 1;
	setsockopt(accept_sock, SOL_SOCKET, SO_OOBINLINE, (char *) &on, sizeof(on));
	tnsetkill(this_user->tn, dead_socket);
	tnsetparser(this_user->tn, process_input);
	tnsetstat(this_user->tn, SOCKET, accept_sock);

#if	DEBUG_TELNET
	tnsetstat(this_user->tn, DEBUG, VERBOSE);
#endif
	tnsetstat(this_user->tn, FILTERCHAR, 1);
	tnsetstat(this_user->tn, BUFFEREOL, 1);
	tnsetstat(this_user->tn, ECHOCHARS, this_user->echo);
	tnsetopt(this_user->tn, TNEcho, WEWOULD);

	tnsetnaws_cb(this_user->tn, new_screen_size);
	tnsetopt(this_user->tn, TNNegotiateAboutWindowSize, WEWOULD);
	tnsetopt(this_user->tn, TNNegotiateAboutWindowSize, THEYSHOULD);
	tnsetopt(this_user->tn, TNNegotiateAboutWindowSize, THEYARE);

	/* Some of these things should probably be set during */
	/* initialization of the telnet structure.			  */
#if	1
	tnsetchangeopt(this_user->tn, tnoptchanged);
	tnsetopt(this_user->tn, TNSuppressGoAhead, WEWOULD);
	tnsetopt(this_user->tn, TNLineMode, THEYSHOULD);	/* We hope they will */
	tnsetopt(this_user->tn, TNLineMode, THEYARE);		/* Begin negotiation */
#endif
#endif

	/* Output initial message of the day with paging turned off. */
	/* If telnet support enabled, rows/cols for user aren't set. */
	result = this_user->paging;
	this_user->paging = 0;				/* more() won't need rows/cols */
	(void)more(this_user, MOTD1);		/* send first message of the day */
	this_user->paging = result;

	/* check ban */
	if (banned(&this_user->site, BANFILE_ALL))
	{
		sprintf(mess, "Attempted login from blocked site %s.\n",
				print_site(&this_user->site));
		write_syslog(mess, LOG_BANNED, 1);
		write_user(this_user, "\nSorry - you're site is banned.\n\n", MSG_FORCED);
		user_quit(this_user);
		return;
	}

	attempts(this_user);		/* Output prompt for user to enter name */
}


#if	!HONOUR_TELNET
/*** User has sent some data. Deal with it ***/
void get_input(void)
{
	unsigned char in_buffer[ARR_SIZE+NAME_LEN+25];
#if	DEBUG_SOCKET
	char buff[80];
#endif
	int bytes_read;
	int got_line;
	int i, len;

	bytes_read = read(this_user->sock, in_buffer, sizeof(in_buffer));
	if (bytes_read <= 0)	/* see if client has closed socket */
	{
		dead_socket();
		return;
	}

	/* ignore telnet IAC commands codes */
	if (in_buffer[0] == 255)
	{
#if	DEBUG_SOCKET
		write(this_user->sock, "*IAC", 4);
		for (i = 1; i < bytes_read; ++i)
		{
			sprintf(mess, " %02X", in_buffer[i]);
			write_user(this_user, mess, MSG_FORCED);
		}
		write_user(this_user, "*\r\n", MSG_FORCED);
#endif
		return;
	}

	i = -1;
	len = bytes_read;
	while (bytes_read > 0)
	{
		got_line = 0;

		/* copy input into buffer - allows line or char. mode clients */
		while (++i < len)
		{	/* see if delete key pressed in char. mode */
			if (in_buffer[i] == 8 || in_buffer[i] == 127)
			{
				if (this_user->buffpos > 0)
				{
					--this_user->buffpos;
					if (this_user->echo)
						write_user(this_user, "\b \b", MSG_FORCED);
				}
				continue;
			}

			/* Is there room in the buffer? */
			if (this_user->buffpos < ARR_SIZE - 2)
			{
				/* Only copy printable, tab, or bell characters */
				if (in_buffer[i] >= ' ' || in_buffer[i] == '\t' || in_buffer[i] == '\007')
				{
					this_user->buff[this_user->buffpos] = in_buffer[i];
					++this_user->buffpos;
				}
				else	/* Found a non-printable character */
				{
					/* Handle end-of-line characters */
					if (in_buffer[i] == '\r' || in_buffer[i] == '\n')
					{
						/* Just in case we have both end-of-line characters */
						/* but not in a particular given order.				*/
						if ((in_buffer[i] != in_buffer[i+1]) &&
							(in_buffer[i+1] == '\r' || in_buffer[i+1] == '\n'))
							++i;

						got_line = 1;
						break;
					}
				}
			}
		}

		/* Echo characters just received if appropriate */
		if (this_user->echo && (this_user->logging_in == LOGIN_DONE || this_user->logging_in == LOGIN_GET_NAME || PASSWORD_ECHO))
		{
			this_user->buff[ this_user->buffpos ] = '\0';

			write_user(this_user, (char *)&this_user->buff[ this_user->old_buffpos ], MSG_FORCED);
			if (got_line == 1)
				write_user(this_user, "\r\n", MSG_FORCED);

			this_user->old_buffpos = this_user->buffpos;
		}

		if (got_line == 0)
			return;

		this_user->buff[ this_user->buffpos ] = '\0';

#if	DEBUG_SOCKET
#if	NEW_SOCKET_IO
		sprintf(buff, "*Got '%s', sock_err = %d*\r\n", this_user->buff, this_user->sock_err);
#else
		sprintf(buff, "*Got '%s'*\r\n", this_user->buff);
#endif
		write_user(this_user, buff, MSG_FORCED);
#endif
		process_input(this_user->buff);
		bytes_read -= this_user->buffpos;
		this_user->buff[0] = '\0';
		this_user->buffpos = 0;
		this_user->old_buffpos = 0;
	}
}
#endif


void process_input(unsigned char *input)
{
	this_user->last_input = time(NULL);	 /* ie now */;
	this_user->idle_mention = 0;
	inpstr = (char *)input;

	/* see if user is logging in */
	if (this_user->logging_in != LOGIN_DONE)
	{
		login(this_user);
		return;
	}

	/* If user was AFK, let everyone know the user has returned */
	if (this_user->afk)
	{
		this_user->afk = 0;
		this_user->bafk = 0;
		sprintf(mess, "%s has RETURNED!\n", vis_user_name(this_user));
		write_alluser(this_user, mess, this_user->area, 1, MSG_SYSTEM);
	}

	if (this_user->callback != NULL)
		this_user->callback();
	else
	{
		inpstr = skip_blanks(inpstr);
		if (*inpstr == '\0')
			return;

		/* deal with any commands */
		com_index = get_com_index(inpstr);
		if (com_index != CMD_BAD && cmd_info[com_index].func != NULL)	/* If we found a command, execute it */
		{
			if (!this_user->stun)
				exec_com();
			else
				write_user(this_user, "Sorry. You can't issue commands while you are stunned.\n", MSG_FORCED);
		}
		else
		{
			if (*inpstr == '.')		/* Looked like it was a command? */
				write_user(this_user, "Sorry. I don't know that command.\n", MSG_FORCED);
			else
			{
				/* send speech to speaker & everyone else in same area */
				if (strncasecmp(inpstr, "help", 4) == 0)
					write_user(this_user, "^* Type '.help' for help *^\n", MSG_FORCED);

				say_speech(this_user);
			}
		}
	}

	/* The code above may have wound up setting callback to NULL */
	if (this_user->callback == NULL)
		prompt(this_user);
}


/************************* MISCELLANEOUS FUNCTIONS ***************************/

/*** convert string to lower case ***/
void strtolower(str)
char *str;
{
	while (*str)
	{
		*str = tolower(*str);
		str++;
	}
}


/* Force a string to all upper case */
void strupcase(char *string)
{
int i;

	for (i = 0; string[i] != '\0'; ++i)
		string[i] = toupper(string[i]);
}


/*** parse a string from an buffer ***/
/* The returned string is nul terminated. */
/* Also, any trailing newline is removed. */
void get_string(input, output, max_len)
char *input, *output;
int max_len;
{
int i;

	strncpy(output, input, max_len);
	output[max_len - 1] = '\0';
	i = strlen(output) - 1;
	if (output[i] == '\n')
		output[i] = '\0';
}


/*** parse a string from an buffer ***/
/* This function returns the first word from the */
/* input buffer in the output buffer limited to  */
/* the number of characters specified by max_len.*/
/* The returned string is nul terminated.		 */
void get_word(input, output, max_len)
char *input, *output;
int max_len;
{
int len;

	/* Copy one less character than the size of the buffer */
	for (len = 1; len < max_len; ++len)	
	{
		if (isspace(*input))
			break;
		*output++ = *input++;
	}

	*output = '\0';
}


/*** get a user name from the input buffer ***/
/* This routine gets a user name from the input buffer and */
/* makes certain that the name is all in lower case except */
/* for the first character which must be capitalized.	   */
void get_user_name(input, output, max_len)
char *input, *output;
int max_len;
{
	get_word(input, output, max_len);
	strtolower(output);
	output[0] = toupper(output[0]);
}


/*** gets the "visible" user name ***/
/* If the user is visible, it returns a pointer to their */
/* user name. If the user is not visible, it returns a   */
/* pointer to the string "Someone".                      */
char *vis_user_name(USER_DATA *user)
{
static char *someone = "Someone";

	if (user->vis)
		return user->name;
	else
		return someone;
}


/*** See if user exists (a file exists in userdata directory) ***/
int user_exists(name)
char *name;
{
	/* The '+7' here accounts for the two '/', the first character of	*/
	/* the users name and the final '.D' of the filename being created	*/
	/* plus the trailing NUL.											*/
	char filename[NAME_LEN + sizeof(USERDATADIR) + 7];

	sprintf(filename, "%s/%c/%s.D", USERDATADIR, name[0], name);
	if (access(filename, F_OK) != 0)
		return 0;

	return 1;
}


/*** get pointer to user data using name ***/
/* It expects the first character of name to be in caps.*/
/* This code handles inexact name matches. The user will*/
/* be shown all matches if there is more than one.		*/
/* NOTE:Only users logged in are considered for a match.*/
USER_DATA *find_userdata(user, name, exact_match, show_messages)
USER_DATA *user;
char *name;
int exact_match;
int show_messages;
{
	Node *node;
	USER_DATA *u, *intended_user;
	int name_len;
	int mess_len;
	int flag;

	mess[0] = '\0';
	name_len = strlen(name);		/* This should save a little time */
	intended_user = NULL;			/* Don't have a match yet */
	flag = 1;

	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		u = (USER_DATA *)NodeData(node);
		node = NodeNext(node);

		if (u->area == NULL)		/* Ignore this user - not logged in */
			continue;

		if (name_len > strlen(u->name))
			continue;

		if (strcmp(name, u->name) == 0)	/* Handles an exact match */
			return u;

		if (exact_match)
			continue;

		if (strncmp(name, u->name, name_len) == 0)
		{
			if (intended_user == NULL)	/* First time we found a match? */
				intended_user = u;
			else						/* More than one match */
			{
				if (!show_messages)		/* Get out if we won't show message */
					return NULL;

				/* First time here, we have already found a match */
				if (flag)
				{
					flag = 0;
					sprintf(mess, "^Matched names:^ %s", intended_user->name);
					mess_len = strlen(mess);
				}
				if (mess_len > sizeof(mess)-(NAME_LEN-2))
				{
					write_user(user, mess, MSG_FORCED);
					mess[0] = '\0';
				}
				strcat(mess, " ");
				strcat(mess, u->name);
				mess_len += strlen(u->name) + 1;
			}
		}
	}

	if (show_messages)
	{
		if (intended_user == NULL)	/* No matches found? */
		{
			sprintf(mess, "%s is not signed on\n", name);
			write_user(user, mess, MSG_FORCED);
		}
		else	/* More than one match found? */
		{
			if (mess[0] != '\0')
			{
				strcat(mess, "\n");
				write_user(user, mess, MSG_FORCED);
				intended_user = NULL;
			}
		}
	}

	return intended_user;
}


/*** Init user data structure ***/
void init_user(user)
USER_DATA *user;
{
	memset(user, 0, sizeof(USER_DATA));
	strcpy(user->desc, "- a new user");
	strcpy(user->old_site.addr, "*Unknown*");
	user->old_site.name[0] = '\0';
	strcpy(user->site.addr, user->old_site.addr);
	user->site.name[0] = '\0';
	strcpy(user->email, user->old_site.addr);
	user->gender = '?';
	user->sock = -1;
	user->level = init_user_lvl;
	user->last_input = time(NULL);	/* ie. now */
	user->attempts = max_attempts;
	user->logging_in = LOGIN_GET_NAME;
	user->cols = DEFAULT_COLS;
	user->rows = DEFAULT_ROWS;
	user->which_msgs = MSG_ALL;
	user->wrap = 1;
	user->paging = 1;
	user->vis = 1;
}


#if	READ_BD_FILES
/* Converts string like output of ctime() into time_t */
/* Note: Assumes correct format of buffer. Incorrect  */
/* format will produce indeterminate behavour.        */
time_t strtotime(char *buffer)
{
	struct tm tmp;
	char daystr[4], monstr[4];
	int year;

	sscanf(buffer, "%s %s %d %d:%d:%d %d", daystr, monstr, &tmp.tm_mday,
		&tmp.tm_hour, &tmp.tm_min, &tmp.tm_sec, &year);
	if (tmp.tm_hour < 0 || tmp.tm_hour > 23)
		tmp.tm_hour = 0;
	if (tmp.tm_min < 0 || tmp.tm_min > 59)
		tmp.tm_min = 0;
	if (tmp.tm_sec < 0 || tmp.tm_sec > 61)
		tmp.tm_sec = 0;
	tmp.tm_year = (year > 1900) ? (year - 1900) : 0;

	tmp.tm_wday = choose(daystr, days);
	if (tmp.tm_wday < 0 || tmp.tm_wday > 6)
		tmp.tm_wday = 0;
	tmp.tm_mon = choose(monstr, months);
	if (tmp.tm_mon < 0 || tmp.tm_mon > 11)
		tmp.tm_mon = 0;
	tmp.tm_isdst = -1;

	return mktime(&tmp);
}
#endif


/*** Read the users data file (if not logged ***/
/*** in) and return pointer to the user data ***/
void read_old_userfile(fp, user, name, flag)
FILE *fp;
USER_DATA *user;
char *name;
int flag;
{
	char buffer[82];
#if	READ_BD_FILES
	char *s;
	int	bd_file;

	bd_file = 0;
#endif

	fseek(fp, 0L, 0);
	fgets(buffer, sizeof(buffer), fp);		/* Password */
#if	READ_BD_FILES
	if (buffer[0] != '*')
		get_word(buffer, user->passwd, NAME_LEN);
	else
	{
		bd_file = 1;
		s = strrchr(buffer, '-');
		if (s == NULL)
			user->freeze_time = 0;
		else
		{
			s = skip_blanks(++s);
			get_word(s, user->passwd, NAME_LEN);
			user->freeze_time = -1;		/* Assume account is frozen forever */
		}
	}
#else
	get_word(buffer, user->passwd, NAME_LEN);
#endif

	fgets(buffer, sizeof(buffer), fp);		/* Previous logoff/login times */
#if	READ_BD_FILES
	if (isalpha(buffer[0]))
	{
		bd_file = 1;
		user->last_off = strtotime(buffer);
		user->last_on = 0;
		s = strrchr(buffer, ',');
		if (s == NULL)
			user->totaltime = 0L;
		else
		{
			s = skip_blanks(++s);
			sscanf(s, "%ld", &user->totaltime);
		}
	}
	else
#endif
	sscanf(buffer, "%ld %ld %ld %d",
			&user->last_off, &user->last_on,
			&user->totaltime, &user->freeze_time);

	fgets(buffer, sizeof(buffer), fp);		/* Previous site */
	get_word(buffer, user->old_site.name, SITE_LEN);
	s = skip_word(buffer);
	if (s[0] == '\0')	/* One word on the line? */
		user->old_site.addr[0] = '\0';
	else
	{
		strncpy(user->old_site.addr, user->old_site.name, 16);
		get_word(s, user->old_site.name, SITE_LEN);
	}

	fgets(buffer, sizeof(buffer), fp);		/* Description */
	get_string(buffer, user->desc, DESC_LEN);

	fgets(buffer, sizeof(buffer), fp);		/* User level */
	user->level = atoi(buffer);
	if (user->level < DUNCE || user->level > MAX_LEVEL)
		user->level = USER;

	fgets(buffer, sizeof(buffer), fp);		/* Number of mail msgs at last logoff */
	sscanf(buffer, "%d %d", &user->mailmsgs, &user->lastmail);
	if (user->mailmsgs < 0)
		user->mailmsgs = 0;
	if (user->lastmail < 0)
		user->lastmail = 0;

	fgets(buffer, sizeof(buffer), fp);		/* Number of columns on terminal */
#if	!HONOUR_TELNET
	user->cols = atoi(buffer);
	if (user->cols < MIN_COLS || user->cols > MAX_COLS)
		user->cols = DEFAULT_COLS;
#endif
	fgets(buffer, sizeof(buffer), fp);		/* Number of rows on terminal */
#if	!HONOUR_TELNET
	user->rows = atoi(buffer);
	if (user->rows < MIN_ROWS || user->rows > MAX_ROWS)
		user->rows = DEFAULT_ROWS;
#endif

	fgets(buffer, sizeof(buffer), fp);		/* Allow bolding? */
	user->use_bold = (buffer[0] == '1') ? 1 : 0;
	fgets(buffer, sizeof(buffer), fp);		/* Under arrest? */
	user->arrested = (buffer[0] == '1') ? 1 : 0;
	fgets(buffer, sizeof(buffer), fp);		/* Allow word wrapping? */
	user->wrap = (buffer[0] == '1') ? 1 : 0;

	fgets(buffer, sizeof(buffer), fp);		/* Get various flag(s) */
	if (strlen(buffer) == 1)
		user->echo   = (buffer[2] == '1') ? 1 : 0;
	else
	{
		user->paging = (buffer[0] == '0') ? 0 : 1;	/* Default to on */
		user->prompt = (buffer[1] == '1') ? 1 : 0;
		user->echo   = (buffer[2] == '1') ? 1 : 0;
		user->muzzled= (buffer[3] == '1') ? 1 : 0;
	}

	fgets(buffer, sizeof(buffer), fp);		/* Get various flag(s) */
	if (strlen(buffer) == 1)
		user->paging = (buffer[0] == '0') ? 0 : 1;	/* Default to on */
	else
	{
		user->which_msgs = (user->level < MAGICAL) ? MSG_ALL : MSG_WALL;
		if (buffer[0] == '0')	user->which_msgs &= ~MSG_TALK;
		if (buffer[1] == '0')	user->which_msgs &= ~MSG_SHOUT;
		if (buffer[2] == '0')	user->which_msgs &= ~MSG_TELL;
		if (buffer[3] == '0')	user->which_msgs &= ~MSG_ECHO;
		if (buffer[4] == '0')	user->which_msgs &= ~MSG_LOGON;
		if (buffer[5] == '0')	user->which_msgs &= ~MSG_BEEP;
#if	ALLOW_MTELLS
		if (buffer[6] == '0')	user->which_msgs &= ~MSG_MTELL;
#endif
		if (buffer[7] == '0')	user->which_msgs &= ~MSG_ATMOS;
		if (buffer[8] == '0')	user->which_msgs &= ~MSG_SYSTEM;
		if (buffer[9] == '0')	user->which_msgs &= ~MSG_WTELL;
		if (buffer[10]== '0')	user->which_msgs &= ~MSG_BCAST;
	}
}


/*** Read the users data file (if not logged ***/
/*** in) and return pointer to the user data ***/
int parse_userdata(user, line)
USER_DATA *user;
char *line;
{
	char word[10];
	int error;
	int i, j;
	int count;
	char *s;

	error = 0;
	get_word(line, word, sizeof(word));

	for (i = 0; uf_data[i].word != NULL; ++i)
	{
		if (strcmp(word, uf_data[i].word) != 0)
			continue;

		s = skip_word(line);

		switch (uf_data[i].uf_type)
		{
		case Pswd:
			get_word(s, user->passwd, NAME_LEN);
			break;
		case Times:
			sscanf(s, "%ld %ld %ld %d",
					&user->last_on,   &user->last_off,
					&user->totaltime, &user->freeze_time);
			break;
		case Site:
			get_word(s, user->old_site.name, SITE_LEN);
			s = skip_word(s);
			if (s[0] == '\0')	/* One word on the line? */
				user->old_site.addr[0] = '\0';
			else
			{
				strncpy(user->old_site.addr, user->old_site.name, 16);
				get_word(s, user->old_site.name, SITE_LEN);
			}
			break;
		case Desc:
			get_string(s, user->desc, DESC_LEN);
			break;
		case UF_Lvl:
			user->level = atoi(s);
			if (user->level < DUNCE || user->level > MAX_LEVEL)
				user->level = USER;
			break;
		case Mail:
			sscanf(s, "%d %d", &user->mailmsgs, &user->lastmail);
			if (user->mailmsgs < 0)
				user->mailmsgs = 0;
			if (user->lastmail < 0)
				user->lastmail = 0;
			break;
		case Cols:
#if	!HONOUR_TELNET
			user->cols = atoi(s);
			if (user->cols < MIN_COLS || user->cols > MAX_COLS)
				user->cols = DEFAULT_COLS;
#endif
			break;
		case Rows:
#if	!HONOUR_TELNET
			user->rows = atoi(s);
			if (user->rows < MIN_ROWS || user->rows > MAX_ROWS)
				user->rows = DEFAULT_COLS;
#endif
			break;
		case Flags:
			user->arrested=(s[0] == '1') ? 1 : 0;
			user->use_bold=(s[1] == '1') ? 1 : 0;
			user->wrap   = (s[2] == '1') ? 1 : 0;
			user->echo   = (s[3] == '1') ? 1 : 0;
			user->paging = (s[4] == '1') ? 1 : 0;
			user->prompt = (s[5] == '1') ? 1 : 0;
			break;
		case Ignores:
			count = sscanf(s, "%04X\n", &user->which_msgs);
			break;
		case Credits:
			sscanf(s, "%ld %ld",
					&user->credits_earned, &user->credits_used);
			break;
		case Gender:
			if (*s == '\0')
				user->gender = '?';
			else
				user->gender = *s;
			break;
		case Email:
			get_string(s, user->email, EMAIL_LEN);
			break;
		case Onmsg:
			get_string(s, user->onmsg, ONOFF_LEN);
			break;
		case Offmsg:
			get_string(s, user->offmsg, ONOFF_LEN);
			break;
		case Enter:
			get_string(s, user->entermsg, ENTER_EXIT_LEN);
			break;
		case Exit:
			get_string(s, user->exitmsg, ENTER_EXIT_LEN);
			break;
		case Macro1:
		case Macro2:
		case Macro3:
		case Macro4:
		case Macro5:
			j = uf_data[i].uf_type - Macro1;
			get_string(s, &user->macro[j][0], MACRO_LEN);
			break;
		default:
			error = 1;
			break;
		}

		return error;
	}

	return 1;
}


/*** Read the users data file (if not logged ***/
/*** in) and return pointer to the user data ***/
USER_DATA *get_userdata(user, name, flag)
USER_DATA *user;
char *name;
int flag;
{
	static USER_DATA user_data;
	USER_DATA *u;
	char filename[80];
	char buffer[82];
	int i, err;
	FILE *fp;

	/* see if the user is already logged on */
	if (user != NULL && user->area != NULL)
	{
		u = find_userdata(user, name, 1, 0);
		if (u != NULL)
			return(u);	/* Return pointer to current user data */
	}

	init_user(&user_data);
	strcpy(user_data.name, name);

	/* Read the user data file */
	sprintf(filename, "%s/%c/%s.D", USERDATADIR, name[0], name);
	fp = fopen(filename, "r");
	if (fp == NULL)
	{
		if (flag == 0)
			return(NULL);	/* No data file for the user specified */

		return(&user_data);	/* Point to initialized user data structure */
	}

	/* Read the data from the user data file */
	fgets(buffer, sizeof(buffer), fp);
	if (isupper(buffer[0]) || buffer[0] == '*')
		read_old_userfile(fp, &user_data, name, flag);
	else
	{
		while (!feof(fp))
		{	/* How should parse errors be handled? ~~~~~ */
			i = parse_userdata(&user_data, buffer);
			if (i == 1)
			{
				err = 1;
				break;
			}
			fgets(buffer, sizeof(buffer), fp);
		}
	}

	fclose(fp);

	return &user_data;
}


#if	SAVE_BD_FILES
/*** Save user data ***/
/* Write to temp file. If ok, rename to real file. */
int save_userdata(USER_DATA *user)
{
	time_t tm;
	char filename[80];
	char timestring[80];
	FILE *fp;

	if (user->logging_in != LOGIN_DONE)
		return 1;

	if (user_frozen(user))
		return 1;

	sprintf(filename, "%s/%c/%s.D", USERDATADIR, user->name[0], user->name);
	if ((fp = fopen(filename, "w")) == NULL)
		return 0;
	/* get current time and remove newline to add total online time to it */
	tm = time(NULL);
	strcpy(timestring, ctime(&tm));
	sprintf(&timestring[strlen(timestring) - 1], ", %lu",
			(unsigned long int) (user->totaltime + (tm - user->login)));
	if (fprintf(fp,
		"%s\n"    /* passwd */
		"%s\n"    /* last login time */
		"%s\n"    /* last login site */
		"%s\n"    /* description */
		"%d\n"    /* level */
		"%d\n"    /* mail */
		"%d\n"    /* columns */
		"%d\n"    /* rows */
		"%d\n"    /* bold */
		"%d\n"    /* arrested */
		"%d\n"    /* wrap */
		"%d%d%d%d\n"      /* paging prompt echo muzzle */
		"%d%d%d%d%d%d"    /* talk shouts tells echos logins beeps */
		"%d%d%d%d%d\n",   /* mtells atmos system wtells bcasts */
		user->passwd, timestring, user->site,
		user->desc, user->level,
		user->mailmsgs, user->mailmsgs, user->cols, user->rows,
		user->use_bold,
		user->arrested,
		user->wrap,
		user->paging, user->prompt, user->echo, user->muzzled,
		(user->which_msgs & MSG_TALK)   ? 1 : 0,
		(user->which_msgs & MSG_SHOUT)  ? 1 : 0,
		(user->which_msgs & MSG_TELL)   ? 1 : 0,
		(user->which_msgs & MSG_ECHO)   ? 1 : 0,
		(user->which_msgs & MSG_LOGON)  ? 1 : 0,
		(user->which_msgs & MSG_BEEP)   ? 1 : 0,
#if	!ALLOW_MTELLS
		0,
#else
		(user->which_msgs & MSG_MTELL)  ? 1 : 0,
#endif
		(user->which_msgs & MSG_ATMOS)  ? 1 : 0,
		(user->which_msgs & MSG_SYSTEM) ? 1 : 0,
		(user->which_msgs & MSG_WTELL)  ? 1 : 0,
		(user->which_msgs & MSG_BCAST)  ? 1 : 0
		) == EOF) {
	fclose(fp);
	/* Corrupt file! delete it, backup other user files and log this problem */
	write_user(user, "[SYSTEM ERROR] Your account is corrupt!!! Please see an administrator\n", MSG_FORCED);
	sprintf(timestring, "WRITE ERROR: Unable to save userfile for %s\n", user->name);
	write_syslog(timestring, LOG_ADMIN_FILE, 1);
	unlink(filename);
	/* We had better rename the mail files to stop the auto delete feature */
	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, user->name[0], user->name);
	sprintf(timestring, "%s/%c/%s.M-BAK", USERMAILDIR, user->name[0], user->name);
	rename(filename, timestring);
	sprintf(filename, "%s/%c/%s.P", PROFILESDIR, user->name[0], user->name);
	sprintf(timestring, "%s/%c/%s.P-BAK", PROFILESDIR, user->name[0], user->name);
	rename(filename, timestring);
	return 0;
}
fclose(fp);
return 1;
}
#else
/*** Save user data ***/
/* Write to temp file. If ok, rename to real file. */
int save_userdata(USER_DATA *user)
{
	char tempfile[80], filename[80];
	time_t current_time;
	FILE *fp;
	int count;
	int i, j;

#ifdef	DISABLE_SAVE
	return 1;
#endif

	/* If user socket is set to -1 don't save users data */
	if (user->sock == -1)
		return 1;

	/* Was user in middle of editing something? */
	if (user->edit_lines != NULL)
		user->which_msgs = user->tmp_msgs;	/* Restore the listen flags */

	sprintf(tempfile, "%s/%c/%s.T", USERDATADIR, user->name[0], user->name);
	fp = fopen(tempfile, "w");
	if (fp == NULL)
		return 0;

	time(&current_time);
	if (user->login != 0UL)
		user->totaltime += (current_time - user->login);

	count = 1;
	for (i = 0; count > 0 && uf_data[i].word != NULL; ++i)
	{
		count = fprintf(fp, "%s ", uf_data[i].word);
		if (count < 0)
			break;

		switch (uf_data[i].uf_type)
		{
		case Pswd:
			count = fprintf(fp, "%s\n", user->passwd);
			break;
		case Times:
			count = fprintf(fp, "%ld %ld %ld %d\n",
					user->last_on,   current_time,
					user->totaltime, user->freeze_time);
			break;
		case Site:
			count = fprintf(fp, "%s %s\n", user->site.addr, user->site.name);
			break;
		case Desc:
			count = fprintf(fp, "%s\n", user->desc);
			break;
		case UF_Lvl:
			count = fprintf(fp, "%d\n", user->level);
			break;
		case Mail:
			count = fprintf(fp, "%d %d\n", user->mailmsgs, user->lastmail);
			break;
		case Cols:
			count = fprintf(fp, "%d\n", user->cols);
			break;
		case Rows:
			count = fprintf(fp, "%d\n", user->rows);
			break;
		case Flags:
			fprintf(fp, "%d%d%d%d%d%d\n",
					user->arrested, user->use_bold, user->wrap,
					user->echo, user->paging, user->prompt);
			break;
		case Ignores:
			count = fprintf(fp, "%04X\n", user->which_msgs);
			break;
		case Credits:
			count = fprintf(fp, "%ld %ld\n",
					user->credits_earned, user->credits_used);
			break;
		case Gender:
			count = fprintf(fp, "%c\n", user->gender);
			break;
		case Email:
			count = fprintf(fp, "%s\n", user->email);
			break;
		case Onmsg:
			count = fprintf(fp, "%s\n", user->onmsg);
			break;
		case Offmsg:
			count = fprintf(fp, "%s\n", user->offmsg);
			break;
		case Enter:
			count = fprintf(fp, "%s\n", user->entermsg);
			break;
		case Exit:
			count = fprintf(fp, "%s\n", user->exitmsg);
			break;
		case Macro1:
		case Macro2:
		case Macro3:
		case Macro4:
		case Macro5:
			j = uf_data[i].uf_type - Macro1;
			count = fprintf(fp, "%s\n", user->macro[j]);
			break;
		}

		if (count < 0)
			break;
	}

	fclose(fp);

	/* Error writing to userdata file? */
	if (count < 0)
	{
		unlink(tempfile);
		return 0;
	}

	sprintf(filename, "%s/%c/%s.D", USERDATADIR, user->name[0], user->name);
	if (rename(tempfile, filename) < 0)		/* Check successful rename */
		return 0;

	return 1;
}
#endif


/*** Record various messages in a list ***/
void record(list, string, lines, max_lines)
List *list;
char *string;
int *lines;
int max_lines;
{
Node *node;
char *s;

	if (list == NULL)
		return;

	if (max_lines <= 0)
		return;

	/* The following loop is here on the off-chance that the*/
	/* number of lines that are allowed to be recorded is	*/
	/* reduced below number of lines already in the buffer.	*/
	/* Most of the time it won't do anything at all.		*/
	while (*lines > max_lines)
	{
		--(*lines);
		node = NodeRemHead(list);
		NodeDestroy(node);
	}

	s = strdup(string);
	if (s != NULL)
	{
		if (*lines < max_lines)
			++(*lines);
		else
		{
			node = NodeRemHead(list);
			NodeDestroy(node);
		}
		NodeAddTailNew(list, s);
	}
}


/*** review messages recorded in a list ***/
void review(user, list)
USER_DATA *user;
List *list;
{
	Node *node;
	char *s, buff[ARR_SIZE];

	if (list == NULL)
		return;

	node = NodeHead(list);
	while (!isEndOfList(list, node))
	{
		s = (char *)NodeData(node);
		node = NodeNext(node);

		if (user->level < MAGICAL)
		{
			strcpy(buff, s);

			/* Don't show site information to non-wizard. */
			/* String truncated to '%s signed on/off'.	  */
			if (list == rec_logs)
			{
				s = skip_word(buff);
				s = skip_word(s);
				s = skip_word(s);
				if (*s != '\0')
				{
					*s = '\n';
					s[1] = '\0';
				}
				s = buff;
			}
			else
			{	/* Are echo type messages being reviewed? */
				s = skip_word(buff);
				if (buff[0] == '^' && strncmp(s, "echos:^", 7) == 0)
					s = skip_word(s);
				else
					s = buff;
			}
		}

		write_user(user, s, MSG_FORCED);
	}
}


/*** Initialize various global variables ***/
int init_globals(void)
{
int error;
int i, j;
int *var;

	error = 0;

	for (i = 0; global_data[i].word != NULL; ++i)
	{
		if (global_data[i].var_type == Levstr)
		{
			j = global_data[i].init_value;
			levstr[j] = strdup(default_levstr[j]);
			strupcase( levstr[j] );
		}
		else
		{
			var = global_data[i].var;

			/* Check the limits on the variable */
			if (global_data[i].min > global_data[i].max)
			{
				fprintf(stderr, "init_globals - '%s' has invalid min or max value\n",
						global_data[i].word);
				error = 1;
			}

			/* Check the initial (default) value to make sure it is legal */
			if (global_data[i].init_value < global_data[i].min ||
				global_data[i].init_value > global_data[i].max)
			{
				fprintf(stderr, "init_globals - '%s' has bad initial value\n",
						global_data[i].word);
				error = 1;
			}

			*var = global_data[i].init_value;
		}
	}

	levstr[MAX_LEVEL + 1] = NULL;

	ulist = ListCreate();
	if (ulist == NULL)
	{
		fprintf(stderr, "Can't create linked list for user data\n");
		return 1;
	}
	num_of_users = 0;
	this_user = NULL;

	astr = ListCreate();
	if (astr == NULL)
	{
		fprintf(stderr, "Can't create linked list for area data\n");
		ListDestroy(ulist);
		return 1;
	}
	num_areas = 0;

	memset(user_ids, 0, sizeof(user_ids));
	login_count = 0;

	rec_logs = ListCreate();
	log_lines = 0;

	wiz_tells = ListCreate();
	wiz_lines = 0;

#if	HONOUR_TELNET
	if (init_telnet() == 1)
		error = 1;
#endif

	return error;
}


/*** Read in initialization data file. ***/
/*** Init and areas section may appear ***/
/*** in any order but both must appear ***/
int read_init_file(void)
{
	int found_init;
	int found_areas;
	int found_topics;
	int found_users;
	int error;
	char section[15];
	char msg[80];
	int  i, section_num;
	FILE *fp;

	error = 0;
	section_num = 0;
	found_init = 0;
	found_areas = 0;
	found_topics = 0;
	found_users = 0;

	if ((fp = fopen(INITFILE, "r")) == NULL)
	{
		perror("\nNUTS: Couldn't open initialization data file");
		write_syslog("Couldn't open initialization data file\n", LOG_ERROR, 0);
		return 1;
	}

	fgets(mess, sizeof(mess), fp);
	while (!feof(fp))
	{
		get_word(mess, section, sizeof(section));

		/* Skip blank lines or comment lines */
		if (section[0] == '\0' || section[0] == '#')
		{
			fgets(mess, sizeof(mess), fp);
			continue;
		}

		if (section[ strlen(section)-1 ] != ':')
			i = -1;
		else
		{
			i = choose(section, section_heads);
			if (i == -1)
			{
				sprintf(msg, "Unknown section type '%s'\n", mess);
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				error = 1;

				fgets(mess, sizeof(mess), fp);
				continue;
			}
		}

		switch (i)
		{
		case 0:
			if (found_init)
			{
				sprintf(msg, "Found duplicate %s section\n", section_heads[i]);
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				return 1;
			}
			section_num = i + 1;
			found_init = 1;
			break;

		case 1:
			if (found_areas)
			{
				sprintf(msg, "Found duplicate %s section\n", section_heads[i]);
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				return 1;
			}
			section_num = i + 1;
			found_areas = 1;
			break;

		case 2:
			if (found_topics)
			{
				sprintf(msg, "Found duplicate %s section\n", section_heads[i]);
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				return 1;
			}
			section_num = i + 1;
			found_topics = 1;
			break;

		case 3:
			if (found_users)
			{
				sprintf(msg, "Found duplicate %s section\n", section_heads[i]);
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				return 1;
			}
			section_num = i + 1;
			found_users = 1;
			break;

		default:
			switch (section_num)
			{
			case 1:
				if ( parse_init_section(NULL, mess) )
					error = 1;
				break;
			case 2:
				if ( parse_areas_section(NULL, mess) )
					error = 1;
				break;
			case 3:		/* This section is optional */
				if ( parse_topics_section(mess) )
					error = 1;
				break;
			case 4:		/* This section is optional */
				if ( parse_users_section(mess) )
					error = 1;
				break;
			default:
				strcpy(msg, "A data section header is missing\n");
				fprintf(stderr, msg);
				write_syslog(msg, LOG_BOOT_FILE, 0);
				error = 1;
				break;
			}
			break;
		}

		fgets(mess, sizeof(mess), fp);
	}

	if (found_init == 0 || found_areas == 0)
	{
		if (found_init == 0)
		{
			strcpy(msg, "initial data section is missing\n");
			fprintf(stderr, msg);
			write_syslog(msg, LOG_BOOT_FILE, 0);
		}
		if (found_areas == 0)
		{
			strcpy(msg, "areas data section is missing\n");
			fprintf(stderr, msg);
			write_syslog(msg, LOG_BOOT_FILE, 0);
		}
		fprintf(stderr, "A required data section is missing\n");
		error = 1;
	}

	return error;
}


/* This routine gets called for each of the lines in the */
/* initialization data section of the init_data file. It */
/* also gets called from the c_system() command handler. */
int parse_init_section(USER_DATA *user, char *line)
{
char word[82], word2[10];
int error;
int i, j;
int *var;
int value;
unsigned int uvalue;

	error = 0;

	get_word(line, word, sizeof(word));
	get_word(skip_word(line), word2, sizeof(word2));

	for (i = 0; global_data[i].word != NULL; ++i)
	{
		if (strncmp(word, global_data[i].word, strlen(word)) != 0)
			continue;

		/* Lets make sure we know which command is being set here */
		/* Enough characters must be given to uniquely identify	  */
		/* all parameters otherwise wrong one could be changed.	  */
		for (j = i + 1; global_data[j].word != NULL; ++j)
		{
			if (strncmp(word, global_data[j].word, strlen(word)) == 0)
			{
				sprintf(mess, "'%s' is ambiguous. Please be more specific\n", word);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				return 1;
			}
		}

		/* We found a valid parameter but we need to see if */
		/* we're allowed to set/change the parameters value */
		if (user != NULL)		/* Is user trying to change something? */
		{
			if (user->level < global_data[i].level)
			{
				sprintf(mess, "You can not alter the setting of '%s'\n",
						global_data[i].word);
				write_user(user, mess, MSG_FORCED);
				return 1;
			}
		}

		var = global_data[i].var;

		switch (global_data[i].var_type)
		{
		case Bool:
			if (*word2 == '1' || *word2 == '0')
				*var = *word2 - '0';
			else
			{
				i = choose(word2, onoff);
				if (i == -1)
					i = choose(word2, yesno);

				if (i != -1)
				{
					if (i == 1)
						*var = 1;
					else
						*var = 0;
				}
				else
				{
					sprintf(mess, "Value of '%s' is invalid for '%s'\n",
							word2, word);
					if (user == NULL)
						fprintf(stderr, mess);
					else
						write_user(user, mess, MSG_FORCED);
					error = 1;
				}
			}
			if (!error && user != NULL)
			{
				sprintf(mess, "%s CHANGED %s to %c\n",
						user->name, global_data[i].word, word2[0]);
				write_syslog(mess, LOG_OPTIONS, 1);
			}
			return error;

		case Int:
			value = atoi(word2);
			if (value < global_data[i].min || value > global_data[i].max)
			{
				sprintf(mess, "Value %d for '%s' is out of range\n",
						value, word);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				error = 1;
			}
			else
				*var = value;
			if (!error && user != NULL)
			{
				sprintf(mess, "%s CHANGED %s to %d\n",
						user->name, global_data[i].word, value);
				write_syslog(mess, LOG_OPTIONS, 1);
			}
			return error;

		case Uint:
			sscanf(word2, "%u", &uvalue);
			if (uvalue < (unsigned int)global_data[i].min ||
				uvalue > (unsigned int)global_data[i].max)
			{
				sprintf(mess, "Value %u for '%s' is out of range\n",
						uvalue, word);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				error = 1;
			}
			else
				*(unsigned int *)var = uvalue;
			if (!error && user != NULL)
			{
				sprintf(mess, "%s CHANGED %s to %u\n",
						user->name, global_data[i].word, uvalue);
				write_syslog(mess, LOG_OPTIONS, 1);
			}
			return error;

		case Level:
			strupcase(word2);
			for (j = 0; j <= MAX_LEVEL; ++j)
			{
				if (strncmp(word2, levstr[j], strlen(word2)) == 0)
				{
					*var = j;
					break;
				}
			}
			if (j >= sizeof(levstr))
			{
				sprintf(mess, "Invalid value for '%s' - found '%s'\n",
						word, word2);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				error = 1;
			}
			if (!error && user != NULL)

			{
				sprintf(mess, "%s CHANGED %s to %s\n",
						user->name, global_data[i].word, levstr[j]);
				write_syslog(mess, LOG_OPTIONS, 1);
			}
			return error;

		case Levstr:
			word2[LEVSTR_LEN-1] = '\0';
			strupcase(word2);
			free( levstr[ global_data[i].init_value ] );
			levstr[ global_data[i].init_value ] = strdup(word2);
			if (user != NULL)
			{
				sprintf(mess, "%s CHANGED %s to %s\n",
						user->name, global_data[i].word,
						levstr[ global_data[i].init_value ]);
				write_syslog(mess, LOG_OPTIONS, 1);
			}
			return error;
			break;
		}
	}

	sprintf(mess, "I don't know the '%s' option\n", word);
	if (user == NULL)
		fprintf(stderr, mess);
	else
		write_user(user, mess, MSG_FORCED);
	return 1;
}


/*** Search a linked list of areas for a specific area ***/
AREA_DATA *find_area_by_label(char *link_label)
{
	Node *node;
	AREA_DATA *area;

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (strcmp(link_label, area->label) == 0)
			return(area);
	}

	return NULL;
}


/*** Process area status ***/
int process_area_status(USER_DATA *user, AREA_DATA *area, char *status_word)
{
	int error;

	error = 0;

	area->status = choose(status_word, areas_status);

	/* Set default status of area */
	area->wiz_only = 0;
	area->searchable = 1;

	switch (area->status)
	{
	case AREA_STATUS_FIXED:
	case AREA_STATUS_PUBLIC:
	case AREA_STATUS_PRIVATE:
		break;

	case AREA_STATUS_WIZ_FIXED:
	case AREA_STATUS_WIZ_PUBLIC:
	case AREA_STATUS_WIZ_PRIVATE:
		area->status -= AREA_STATUS_WIZ_FIXED;
		area->wiz_only = 1;
		break;

	case AREA_STATUS_JAIL:
		if (jail != NULL)
		{
			sprintf(mess, "Too many jails! First %s and now %s\n",
					jail->name, area->name);
			if (user == NULL)
				fprintf(stderr, mess);
			else
				write_user(user, mess, MSG_FORCED);
			area->status = AREA_STATUS_PUBLIC;
			area->wiz_only = 0;		/* Jail is open to all */
			area->searchable = 0;
			error = 1;
		}
		break;

	default:
		sprintf(mess, "Unknown status type in line %d of areas section\n",
				num_areas + 1);
		if (user == NULL)
			fprintf(stderr, mess);
		else
			write_user(user, mess, MSG_FORCED);
		error = 1;
		break;
	}

	return error;
}


/*** Process area searchable flag ***/
int process_area_flags(USER_DATA *user, AREA_DATA *area, char *flags)
{
	char c;
	int ret;

	ret = 0;

	while (*flags && !isspace(*flags))
	{
		c = toupper(*flags);
		switch (toupper(c))
		{
		case 'Y':
		case 'N':
			if (area != jail)
			{
				if (c == 'Y')
					area->searchable = 1;
				else
					area->searchable = 0;
			}
			else
			{
				sprintf(mess, "Area %s is the jail. You can not change the searchable status of this area.\n",
						area->name);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				ret = 1;
			}
			break;

		case 'L':
			if (user == NULL)
			{
				if (c == 'L')
					area->linked = 1;
				else
					area->linked = 0;
			}
			else
			{
				sprintf(mess, "You can not change the linked status of area %s.\n",
						area->name);
				write_user(user, mess, MSG_FORCED);
				ret = 1;
			}
			break;

		default:
			if (user == NULL)
			{
				sprintf(mess, "Area flags for %s must be one or more of Y, N, or L.\n",
						area->name);
				fprintf(stderr, mess);
			}
			else
			{
				sprintf(mess, "Expected Y or N to indicate if message board of area %s can be searched.\n",
					area->name);
				write_user(user, mess, MSG_FORCED);
			}
			ret = 1;
			break;
		}

		++flags;
	}

	return ret;
}


/*** Handles area linkage information.     ***/
/*** NOTE: This routine creates a link list***/
/*** containing codes of areas the area is ***/
/*** linked to. This info is converted to  ***/
/*** list with pointers to areas during	   ***/
/*** post processing in verify_init_data().***/
int parse_area_linkages(USER_DATA *user, AREA_DATA *area, char *links)
{
	static char *initerror = "BOOT FAILED: Error in init file\n";
	char word[AREA_LABEL_LEN];
	char *area_link;
	int error;

	error = 0;

	/* Parse area linkage information */
	while (*links)
	{
		get_word(links, word, sizeof(word));
		links = skip_word(links);

		if (strcmp(area->label, word) == 0)
		{
			sprintf(mess, "Area '%s' links to itself\n", area->name);
			if (user == NULL)
				fprintf(stderr, mess);
			else
				write_user(user, mess, MSG_FORCED);
			error = 1;
			continue;
		}

		area_link = strdup(&word[0]);
		if (area_link == NULL)
		{
			sprintf(mess, "Can't allocate space for link to %s in area %s\n",
					word, area->name);
			if (user == NULL)
				fprintf(stderr, mess);
			else
				write_user(user, mess, MSG_FORCED);
			error = 1;
		}
		else
		{
			if (NodeAddTailNew(area->move, area_link) == NULL)
			{
				sprintf(mess, "Unable to add link '%s' for area %s\n",
						word, area->name);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				free(area_link);
				error = 1;
			}
		}
	}

	if (error && this_user == NULL)
	{
		fprintf(stderr, "Error on line %d of areas section\n", num_areas);
		write_syslog(initerror, LOG_ERROR, 0);
	}

	return error;
}


/*** Delete nodes in area linkage list ***/
void delete_area_links(List *linkage_info)
{
Node *old_node;

	/* Free all linkage information for this area */
	/* NodeDestroy() is not used here as the data */
	/* pointers for each node point to a node of  */
	/* the area linked lists compared to the usual*/
	/* situation where it points to malloc'ed data*/
	while (NodeTail(linkage_info) != (Node *)linkage_info)
	{
		old_node = NodeRemTail(linkage_info);
		free(old_node);
	}
}


/*** Read in area descriptions and joinings ***/
int parse_areas_section(USER_DATA *user, char *line)
{
	static char *initerror = "BOOT FAILED: Error in init_data file\n";
	char *s, word[AREA_NAME_LEN];
	char label[AREA_LABEL_LEN];
	char name[AREA_NAME_LEN];
	AREA_DATA temp_area;
	AREA_DATA *new_area;
	int error;

	if (num_areas >= max_areas)
	{
		sprintf(mess, "Too many areas in areas section.\n");
		fprintf(stderr, mess);
		write_syslog(initerror, LOG_ERROR, 0);
		return 1;
	}

	strtolower(line);
	error = 0;

	get_word(line, label, AREA_LABEL_LEN);
	if (find_area_by_label(label) != NULL)
	{
		sprintf(mess, "Duplicate label %s in line %d of areas section\n",
				label, num_areas + 1);
		if (user == NULL)
			fprintf(stderr, mess);
		else
			write_user(user, mess, MSG_FORCED);
		error = 1;
	}

	s = skip_word(line);
	get_word(s, name, AREA_NAME_LEN);

	s = skip_word(s);
	get_word(s, word, sizeof(word));

	strcpy(temp_area.name, name);
	if (process_area_status(user, &temp_area, word) != 0)
	{
		write_syslog(initerror, LOG_ERROR, 0);
		error = 1;
	}

	/* Can area message board be searched by all  */
	/* or only by the MAGICAL users (wiz and up)? */
	s = skip_word(s);
	if (process_area_flags(user, &temp_area, s) != 0)
		error = 1;

	/* If error detected, don't bother trying to do anything more */
	if (error)
		return 1;

	new_area = (AREA_DATA *)malloc(sizeof(AREA_DATA));
	if (new_area == NULL)
	{
		sprintf(mess, "Unable to create new area data structure\n");
		if (user == NULL)
			fprintf(stderr, mess);
		else
			write_user(user, mess, MSG_FORCED);
		return 1;
	}

	/* Initialize area data structure and add it to linked list */
	strcpy(new_area->label, label);
	strcpy(new_area->name, name);
	new_area->topic[0] = '\0';
	new_area->status = temp_area.status;
	new_area->mess_num = 0;
	new_area->move = ListCreate();
	new_area->conv = ListCreate();
	new_area->conv_lines = 0;
	new_area->echos = ListCreate();
	new_area->echo_lines = 0;
	new_area->wiz_only = temp_area.wiz_only;
	new_area->searchable = temp_area.searchable;
	new_area->linked = temp_area.linked;
	if (new_area->status == AREA_STATUS_JAIL)
	{
		jail = new_area;
		new_area->searchable = 0;
		new_area->status = AREA_STATUS_PUBLIC;
	}

	s = skip_word(s);
	if (parse_area_linkages(user, new_area, s) != 0)
		error = 1;

	if (error == 0)
	{
		(void)NodeAddTailNew(astr, new_area);
		++num_areas;
	}
	else
	{
		ListDestroy(new_area->echos);
		ListDestroy(new_area->conv);
		delete_area_links(new_area->move);
		free(new_area->move);
		free(new_area);

		if (user == NULL)
		{
			fprintf(stderr, "Error on line %d of areas section\n", num_areas);
			write_syslog(initerror, LOG_ERROR, 0);
			error = 1;
		}
	}

	return error;
}


/*** Read in default area topic messages ***/
int parse_topics_section(char *line)
{
	static int line_num = 0;
	char label[AREA_LABEL_LEN];
	AREA_DATA *area;
	char *topic;

	++line_num;

	get_word(line, label, sizeof(label));
	topic = skip_word(line);

	if (*topic == '\0')
	{
		sprintf(mess, "Missing area topic on line %d of topics section\n", line_num);
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return 1;
	}

	strtolower(label);
	area = find_area_by_label(label);
	if (area == NULL)
	{
		sprintf(mess, "Can't find area with label '%s'\n", label);
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return 1;
	}

	get_string(topic, area->topic, TOPIC_LEN);
	return 0;
}


/*** Read in special user account information ***/
int parse_users_section(char *line)
{
	static int line_num = 0;
	char name[NAME_LEN], lev_str[LEVSTR_LEN];
	char pswd[NAME_LEN], *s;
	USER_DATA *user_data;
	int level;

	++line_num;

	get_user_name(line, name, sizeof(name));
	s = skip_word(line);
	get_word(s, lev_str, sizeof(lev_str));
	s = skip_word(s);
	get_word(s, pswd, sizeof(pswd));
	s = skip_word(s);	/* Point to user description */

	if (name[0] == '\0' || lev_str[0] == '\0' || pswd[0] == '\0')
	{
		sprintf(mess, "Missing data on line %d of user account section\n", line_num);
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return 1;
	}

	level = choose(lev_str, levstr);
	if (level == -1)
	{
		sprintf(mess, "User level '%s' on line %d of user account section is invalid\n", lev_str, line_num);
		fprintf(stderr, mess);
		write_syslog(mess, LOG_BOOT_FILE, 0);
		return 1;
	}

	if (!user_exists(name))
	{
		user_data = get_userdata(NULL, name, 1);

		strcpy(user_data->passwd, crypt(pswd, SALT));
		if (s[0] != '\0')
			get_string(s, user_data->desc, DESC_LEN);
		user_data->level = level;

		(void)save_userdata(user_data);

		sprintf(mess, "Special user \"%s\" created during talker startup\n",
				user_data->name);
		write_syslog(mess, LOG_USER_FILE, 1);
	}

	return 0;
}


/* Convert all linking information from a linked list of */
/* labels to a linked list which points directly at the  */
/* area data for the area. This saves much time later on.*/
int convert_area_link_info(USER_DATA *user, char *area_name, List *move_info)
{
Node *move_node;
Node *next_move_node;
Node *node;
Node *next_node;
AREA_DATA *found_area;
char *link_label;
int error;

	error = 0;

	move_node = NodeHead(move_info);
	while (!isEndOfList(move_info, move_node))
	{
		link_label = (char *)NodeData(move_node);

		found_area = find_area_by_label(link_label);
		if (found_area != NULL)
		{	/* Here we deviate from previous uses of linked lists */
			free(link_label);
			NodeData(move_node) = found_area;
		}
		else
		{
			sprintf(mess, "Failed to find area with label '%s' for area %s\n",
					link_label, area_name);
			if (user == NULL)
				fprintf(stderr, mess);
			else
				write_user(user, mess, MSG_FORCED);

			error = 1;
		}

		move_node = NodeNext(move_node);
	}

	/* Look for multiple links from this area to another */
	move_node = NodeHead(move_info);
	while (!isEndOfList(move_info, move_node))
	{
		next_move_node = NodeNext(move_node);
		found_area = (AREA_DATA *)NodeData(move_node);

		node = NodeNext(move_node);
		while (!isEndOfList(move_info, node))
		{
			next_node = NodeNext(node);

			if (found_area == (AREA_DATA *)NodeData(node))
			{
				sprintf(mess, "Duplicate link to '%s' for area %s\n",
						found_area->name, area_name);
				if (user == NULL)
					fprintf(stderr, mess);
				else
					write_user(user, mess, MSG_FORCED);
				error = 1;

				/* Remember: Area nodes are a little different from the norm */
				(void)NodeRemove(node);
				free(node);
			}

			node = next_node;
		}

		move_node = next_move_node;
	}

	return error;
}


/* Perform additional tests on global variables after init_data	*/
/* file has been read to look for additional errors or to make	*/
/* adjustments to any of the values that were read in.			*/
int verify_init_data(USER_DATA *user)
{
Node *area_node;
AREA_DATA *area;
int error;

	error = 0;

	/* Check some things which can only be set in initialization data file */

	if (user == NULL)
	{
		/* The following situations should never occur but	*/
		/* in case they do we won't count them as critical	*/
		/* but set max lines to 0 to provide a hint that	*/
		/* there was a problem at boot time.				*/
		if (rec_logs == NULL)
		{
			fprintf(stderr, "The rec_logs list pointer is NULL\n");
			max_log_lines = 0;
		}
		if (wiz_tells == NULL)
		{
			fprintf(stderr, "The wiz_tells list pointer is NULL\n");
			max_wiz_lines = 0;
		}

		if (port < MIN_PORT || port > MAX_PORT)
		{
			fprintf(stderr, "Port number is invalid or was not specified\n");
			error = 1;
		}

		if (jail == NULL)
		{
			area = (AREA_DATA *)NodeData( NodeHead(astr) );

			fprintf(stderr, "No area was specified as the jail. Using %s\n",
					area->name);
			jail = area;
		}	

		/* Convert all linking information from a linked list of */
		/* labels to a linked list which points directly at the  */
		/* area data for the area. This saves much time later on.*/
		area_node = NodeHead(astr);
		while (!isEndOfList(astr, area_node))
		{
			area = (AREA_DATA *)NodeData(area_node);
			area_node = NodeNext(area_node);

			if (convert_area_link_info(NULL, area->name, area->move) != 0)
				error = 1;
		}
	}

	/* Now check on some things which can be modified */
	/* at any time via the use of the .system command */

	if (allow_new)
	{
		if (min_login_lvl > init_user_lvl)
			allow_new = 0;
	}

	/* Validate the idle_mention, idle_warning, and idle_logout variables */
	if (idle_logout == 0)	/* No auto-logout? */
	{
		if (idle_warning > 0)
		{
			idle_warning = 0;

			strcpy(mess, "Auto-logout is disabled - ignoring idle_warning time.\n");
			error = 1;
		}
	}
	else	/* Auto-logout is enabled. Validate idle_* variables */
	{
		if (idle_warning == 0)	/* No warning of auto-logout to be given? */
		{
			if (idle_mention > 0 && idle_mention >= idle_logout)
			{
				sprintf(mess, "idle_mention must be less than idle_logout\n");
				error = 1;
			}
		}
		else	/* Warning of auto-logout will be given */
		{
			if (idle_warning <= idle_mention)
			{
				sprintf(mess, "idle_warning must be greater than idle_mention.\n");
				error = 2;	/* Use 2 since other errors may have occurred */
			}

			if (idle_logout <= idle_warning)
			{
				/* First print message re: idle_warning from previous test */
				if (error == 2)
				{
					if (user == NULL)
						fprintf(stderr, mess);
					else
						write_user(user, mess, MSG_SYSTEM);
				}
				sprintf(mess, "idle_logout must be greater than idle_warning.\n");
				error = 1;
			}
		}
	}

	if (error != 0)
	{
		if (user == NULL)
			fprintf(stderr, mess);
		else
			write_user(user, mess, MSG_SYSTEM);
		error = 1;
	}
	return error;
}


/*** count no. of messages (counts no. of newlines in a file) ***/
int messcount(filename)
char *filename;
{
	int count;
	FILE *fp;

	count = 0;
	if ((fp = fopen(filename, "r")) != NULL)
	{
		fgets(mess, sizeof(mess), fp);
		while (!feof(fp))
		{
			++count;
			fgets(mess, sizeof(mess), fp);
		}
		fclose(fp);
	}

	return count;
}


/**** mid copy copies chunk from string strf to string strt
	 (used in write_board & prompt) ***/
void midcpy(strf, strt, fr, to)
char *strf, *strt;
int fr, to;
{
	int f;

	for (f = fr; f <= to; ++f)
	{
		if (!strf[f])
		{
			strt[f - fr] = '\0';
			return;
		}
		strt[f - fr] = strf[f];
	}
	strt[f - fr] = '\0';
}


/*** Print prompt ***/
void prompt(USER_DATA *user)
{
	time_t tm_num;
	char timestr[30];

	/* Only show prompt if user has asked for the time-of-day */
	/* prompts and they haven't been temporarily turned off.  */
	if (user->prompt && !user->noprompt)
	{
		time(&tm_num);
		midcpy(ctime(&tm_num), timestr, 11, 15);
		sprintf(mess, "<%s %s>\n", timestr, user->name);
		write_user(user, mess, MSG_FORCED);
	}
}


/*** Do a wild-card string match ***/
/* Returns 0 if the strings match. */
int wild_strcmp(wild, str)
char *wild, *str;
{
	int w_len, s_len;

	/* Can't do a match if either string is pointing to a null */
	if ( !(*wild && *str) )
		return 1;

	w_len = strlen(wild) - 1;	/* Don't count possible '*' in string */

	/* This handles wildcards on alphabetic IP addresses */
	if (wild[0] == '*')
	{
		s_len = strlen(str);
		if (s_len <= w_len)
			return 1;
		return strncasecmp(&wild[1], &str[s_len - w_len], w_len);
	}

	/* This handles wildcards on numeric IP addresses */
	if (wild[w_len] == '*')
		return strncasecmp(wild, str, w_len);

	/* No wild-card used. Strings must match exactly. */
	return strcasecmp(wild, str);
}


/*** Assign a user ID number for user ***/
int assign_id(void)
{
	int i, j;

	/* Don't assign an ID if we can't handle the user */
	if (num_of_users + login_count >= ABS_MAX_USERS)
		return -1;

	for (i = 0; i < FD_SETSIZE/CHAR_BIT; ++i)
		for (j = 0; j < CHAR_BIT; ++j)
		{
			if ( !(user_ids[i] & (1 << j)) )
			{
				user_ids[i] |= (1 << j);
				return(i * CHAR_BIT + j);
			}
		}

	return -1;	/* No available IDs */
}


/*** Free a user ID ***/
void free_id(int id)
{
	user_ids[id / CHAR_BIT] &= ~(1 << (id % CHAR_BIT));	/* Free user ID */
}


/*** Allocate memory for a new user data ***/
/*** structure, add it to linked list of ***/
/*** users and return pointer to data.   ***/
USER_DATA *add_user_data(void)
{
	USER_DATA *u;
	int id;

	/* If an ID can't be assigned we are */
	/* probably at the maximum number of */
	/* users connected to this program.  */
	id = assign_id();
	if (id < 0)
		return NULL;

	u = (USER_DATA *)malloc(sizeof(USER_DATA));
	if (u == NULL)
	{
		free_id(id);
		return u;
	}

	init_user(u);

#if	HONOUR_TELNET
	u->tn = new_tnstat();
	if (u->tn == NULL)
	{
		free(u);
		free_id(id);
		return NULL;
	}
#endif

	u->user_id = id;
	(void)NodeAddTailNew(ulist, u);
	++login_count;
	return u;
}


#if	SU_PROTECT
/*** Protect SU users by ensuring that they are always SU's ***/
/*** NOTE: Addition of get_word() and get_user_name() seems ***/
/*** to have fixed problem which caused users to be dunced  ***/
/*** as a result of buffer overflows. This is now obsolete. ***/
void su_protect(user)
USER_DATA *user;
{
static char *su_list[] = { "Fred", NULL };
int i;

	for (i = 0; su_list[i] != NULL; ++i)
		if (strcmp(user->name, su_list[i]) == 0)
		{
			if (user->level != MAX_LEVEL)
			{
				write_user(user, "\07*** Your user level was not SU. It has been reset. ***\07\n\n", MSG_FORCED);
				write_syslog(mess, LOG_MISC, 1);
			}
			user->level = MAX_LEVEL;
			return;
		}
}
#endif


/*** Extract a site struct out of a single line of text ***/
/*** Only the first IP address and name will be checked.***/
void extract_site(char *text, struct site *site)
{
	int len, wc;
	char *s;

	site->addr[0] = '\0';
	site->name[0] = '\0';
	wc = 0;

	text = skip_blanks(text);
	do {	/* iterate through the words */
		s = strchr(text, ' ');
		if (s != NULL)
			*s = '\0';

		len = strspn(text, "1234567890.*");
		if (len == strlen(text))
		{
			if (site->addr[0] == '\0')
			{
				strncpy(site->addr, text, sizeof(site->addr));
				site->addr[sizeof(site->addr) - 1] = '\0';
			}
		}
		else
		{
			if (site->name[0] == '\0')
			{
				strncpy(site->name, text, sizeof(site->name));
				site->name[sizeof(site->name) - 1] = '\0';
			}
		}

		if (s != NULL)
		{
			*s = ' ';	/* reset the string to its orignal value */
			text = skip_blanks(s);
		}
	} while (*text && ++wc < 3);
}


/*** check to see if user site is banned ***/
int banned(site_to_check, filename)
struct site *site_to_check;
char *filename;
{
	char line[SITE_LEN + 2];
	struct site banned_site;
	FILE *fp;

	if ((fp = fopen(filename, "r")) == NULL)
		return 0;

	fgets(line, sizeof(line), fp);
	while (!feof(fp))
	{
		extract_site(line, &banned_site);
		if ((wild_strcmp(banned_site.addr, site_to_check->addr) == 0) ||
			(wild_strcmp(banned_site.name, site_to_check->name) == 0))
		{
			fclose(fp);
			return 1;
		}

		fgets(line, sizeof(line), fp);
	}

	fclose(fp);
	return 0;
}


/*** check to see if the users account is frozen ***/
time_t user_frozen(USER_DATA *user_data)
{
time_t current_time;
time_t time_val;

	current_time = time(NULL);
	time_val = user_data->last_off + (time_t)(user_data->freeze_time * 86400L);

	if (user_data->freeze_time == -1)
		return -1;			/* Account is frozen forever */

	if (user_data->freeze_time != 0 && current_time <= time_val)
		return time_val;	/* Time when account will be unfrozen */

	return 0;				/* Account is not frozen */
}


int is_port_full(USER_DATA *user)
{
	if (user == NULL || num_of_users >= ABS_MAX_USERS ||
		(num_of_users >= max_users && user->level < MAGICAL))
	{
		write_user(user, "\nSorry - we are full at the moment, try again later\n\n", MSG_FORCED);
		return 1;
	}

	return 0;
}


/*** check to see if user has had max login attempts ***/
void attempts(user)
USER_DATA *user;
{
#if	HONOUR_TELNET
	tnsetopt(user->tn, TNEcho, WEARENT);
	tnsetstat(user->tn, ECHOCHARS, user->echo); /* Reset per user request */
#else
	echo_on(user);
#endif

	if (--user->attempts < 0)
	{
		write_user(user, "\nMaximum attempts reached...\n\n", MSG_FORCED);
		c_quit();
		return;
	}

	user->logging_in = LOGIN_GET_NAME;
	write_user(user, "Give me a name: ", MSG_FORCED);
}


/*** This is login function - first part of prog users encounter ***/
void login(user)
USER_DATA *user;
{
	char name[NAME_LEN], passwd[NAME_LEN];
	USER_DATA *user_data;
	time_t time_val;
	int i;

	switch (user->logging_in)
	{
	case LOGIN_GET_NAME:
		/* User has entered his login name... */
		get_user_name(inpstr, name, sizeof(name));
		/* User has entered his login name... */
		if (!strcmp(name, "Quit"))
		{
			write_user(user, "\nAbandoning login attempt\n\n", MSG_FORCED);
			c_quit();
			return;
		}
		/* This allows someone to see who's on from the login prompt
		 * so they needn't bother to log in if their mates aren't on.
		 * I think its a nice idea, you may find it intrusive.
		 * Remove it if you must */
		if (!strcmp(name, "Who"))
		{
#if	PORT_WHO
			inpstr = skip_word(inpstr);
			c_who();
#else
			who_cmd(user, 0);
#endif
			write_user(user, "\nGive me a name: ", MSG_FORCED);
			return;
		}
		if (name[0] < ' ' || !strlen(name))
		{
			write_user(user, "\nGive me a name: ", MSG_FORCED);
			return;
		}
		if (strlen(name) < 3)
		{
			write_user(user, "Name too short\n\n", MSG_FORCED);
			attempts(user);
			return;
		}
		if (strlen(name) > NAME_LEN - 1)
		{
			write_user(user, "Name too long\n\n", MSG_FORCED);
			attempts(user);
			return;
		}
		if (strcmp(name, "Someone") == 0)
		{
			write_user(user, "That name cannot be used\n\n", MSG_FORCED);
			attempts(user);
			return;
		}

		/* see if only letters in login */
		for (i = 0; i < strlen(name); ++i)
		{
			if (!isalpha(name[i]))
			{
				write_user(user, "Only letters are allowed in login name\n\n", MSG_FORCED);
				attempts(user);
				return;
			}
		}

		user_data = get_userdata(user, name, 1);

		/* CLL refers to min level of a user who can re-open the port.	*/
		/* Do NOT change the CLL reference here. Change its #define.	*/
		if (!system_open && user_data->level < CLL)
		{
			write_user(user, "\nSorry - the system is closed to further logins at the moment\n\n", MSG_FORCED);
			c_quit();
			return;
		}

		if (user_data->level < min_login_lvl)
		{
			sprintf(mess, "\nSorry. This port is only for users of level %s and above\n\n",
					levstr[min_login_lvl]);
			write_user(user, mess, MSG_FORCED);
			c_quit();
			return;
		}

		time_val = user_frozen(user_data);
		if (time_val != 0)
		{
			sprintf(mess, "Attempted login by frozen user %s.\n", user_data->name);
			write_syslog(mess, LOG_AUTH_FILE, 1);
			if (time_val == -1)
				sprintf(mess, "\nSorry, your account is frozen forever\n\n");
			else
				sprintf(mess, "\nSorry, your account is frozen until %s\n\n", ctime(&time_val));
			write_user(user, mess, MSG_FORCED);
			c_quit();
			return;
		}

		/* user_data contains information read from the users data file. */
		/* Update user_data with information unique to this login and    */
		/* then copy the now complete and updated structure back to the  */
		/* current structure which is already in the linked list of users*/
		user_data->sock = user->sock;
#if	HONOUR_TELNET
		user_data->tn = user->tn;
		user_data->cols = user->cols;
		user_data->rows = user->rows;
#endif
		user_data->user_id = user->user_id;
		user_data->attempts = user->attempts;
		memcpy(&user_data->site, &user->site, sizeof(struct site));
		memcpy(user, user_data, sizeof(USER_DATA));

		if (is_port_full(user))
		{
			attempts(user);
			return;
		}

		user->logging_in = LOGIN_GET_PSWD;
#if HONOUR_TELNET
		tnsetopt(user->tn, TNEcho, WEARE);
		tnsetstat(user->tn, ECHOCHARS, 0);	/* Do not echo passwords */
#else
		echo_off(user);
#endif
		write_user(user, "\rGive me a password: ", MSG_FORCED);
		break;

	case LOGIN_GET_PSWD:	/* User is entering password... */
		strcpy(passwd, crypt(inpstr, SALT));
		if (strlen(passwd) == 0)
		{
			write_user(user, "\rGive me a password: ", MSG_FORCED);
			return;
		}
		if (strlen(passwd) > NAME_LEN - 1)
		{
			write_user(user, "\nPassword too long\n\n", MSG_FORCED);
			attempts(user);
			return;
		}
		if (strlen(passwd) < 4)
		{
			write_user(user, "\nPassword too short\n\n", MSG_FORCED);
			attempts(user);
			return;
		}

		/* Too bad...someone else finished logging in */
		/* before this user entered their password.   */
		if (is_port_full(user))
		{
			attempts(user);
			return;
		}

		/* If this is a new user, password will be empty */
		if (user->passwd[0] == '\0')
			strcpy(user->passwd, passwd);	/* Save encrypted password */
		else	/* User exists */
		{
			if (strcmp(user->passwd, passwd) == 0)
				add_user(user);
			else
			{
				write_user(user, "\nIncorrect login\n\n", MSG_FORCED);
				attempts(user);
			}
			return;
		}

		/** deal with new user **/
		if (!allow_new)
		{
			write_user(user, "\n\nSorry. New users are not allowed on at the moment.\n", MSG_FORCED);
			write_user(user, "Either try again later or send mail requesting an account.\n\n", MSG_FORCED);
			attempts(user);
			return;
		}
		if (banned(&user->site, BANFILE_NEW))
		{
			sprintf(mess, "Attempted login by %s from banned site %s.\n",
					user->name, print_site(&user->site));
			write_syslog(mess, LOG_AUTH_FILE, 1);
			write_user(user, "\nSorry. New users from your site are banned.\n", MSG_FORCED);
			c_quit();
			return;
		}
		write_user(user, "New user...Please re-enter password: ", MSG_FORCED);
		user->logging_in = LOGIN_CONFIRM;
		break;

	case LOGIN_CONFIRM:
		get_word(inpstr, passwd, sizeof(passwd));
		if (strlen(passwd) == 0)
		{
			write_user(user, "\nNew user...\nPlease re-enter password: ", MSG_FORCED);
			return;
		}
		if (strcmp(user->passwd, crypt(passwd, SALT)) != 0)
		{
			write_user(user, "\nPasswords do not match\n\n", MSG_FORCED);
			user->passwd[0] = 0;
			attempts(user);
			return;
		}
		if (strcmp(user->name, user->passwd) == 0)
		{
			write_user(user, "\nYou can not use your name as your password\n\n", MSG_FORCED);
			user->passwd[0] = 0;
			attempts(user);
			return;
		}
		strcpy(user->passwd, crypt(passwd, SALT));
		sprintf(mess, "New id \"%s\" created\n", user->name);
		write_syslog(mess, LOG_USER_FILE, 1);
		add_user(user);
		(void)save_userdata(user);	/* Save information for new user */
		break;
	}
}


/*** Closes user socket ***/
void logoff_user(USER_DATA *user)
{
	int socket;

	socket = user->sock;
	if (socket != -1)
	{
		close(socket);
		user->sock = -1;
	}
}


/*** Closes socket & removes a user from the linked list ***/
void delete_user(USER_DATA *user)
{
	Node *node;

	logoff_user(user);

	/* This routine can only be called with a pointer to a user	*/
	/* that is in the linked list of users so NodeFind should	*/
	/* not return NULL unless memory is seriously corrupted.	*/
	node = NodeFind(ulist, user);
	(void)NodeRemove(node);

#if	HONOUR_TELNET	/* Anything else need to be done here?? ~~~~~ */
	free(user->tn);
#endif

	/* If the next user node to be processed is the one we are deleting */
	/* make nextnode point to the user after the one we are removing.	*/
	if (nextnode == node)
		nextnode = NodeNext(node);

	NodeDestroy(node);
}


/*** Function to clear an areas conversation buffer ***/
void cbuff(area)
AREA_DATA *area;
{
	ListRemAll(area->conv);
	area->conv_lines = 0;
}


void check_area_status(USER_DATA *user, AREA_DATA *area)
{
	if (area->status == AREA_STATUS_PRIVATE && find_num_in_area(area) <= PRINUM)
	{
		write_alluser(user, "Area access returned to public\n", area, 0, MSG_SYSTEM);
		cbuff(area);
		write_alluser(user, "Conversation buffer cleared\n", area, 0, MSG_SYSTEM);
		area->status = AREA_STATUS_PUBLIC;
	}
}


/*** Closes socket & does relevant output to other users & files.***/
/*** NOTE: This routine must not be called when telnet support is***/
/*** enabled, input from user is being processed, and the user to***/
/*** be quit is the same as pointed to by this_user. Call the    ***/
/*** c_quit() routine instead otherwise the talker will crash.   ***/
void user_quit(USER_DATA *user)
{
	Node *node;
	AREA_DATA *area;
	int id;

	id = user->user_id;
	free_id(id);

/* see if user has quit before he logged in */
	if (user->logging_in != LOGIN_DONE)
	{
		delete_user(user);
		--login_count;
		return;
	}

/* User was logged in so we have a bit more to do */
	if (!save_userdata(user))
	{
		sprintf(mess, "%s : Couldn't save your stats\n", syserror);
		write_user(user, mess, MSG_FORCED);
		sprintf(mess, "ERROR: Couldn't save %s's stats in user_quit()\n", user->name);
		write_syslog(mess, LOG_ERROR, 1);
	}
	write_user(user, "\nSigning off...\n\n", MSG_FORCED);

	area = user->area;		/* Remember area user just vacated */
	user->area = NULL;		/* User won't see any more messages */
	check_area_status(user, area);

/* send message to other users & conv file & reset some vars */
	sprintf(mess, "SIGN OFF: %s %s\n", user->name, user->desc);
	write_alluser(user, mess, NULL, 0, MSG_LOGON);
	sprintf(mess, "%s signed off\n", user->name);
	write_syslog(mess, LOG_LOGINS, 1);
	record_login(mess);

	if (user->edit_lines != NULL)
		ListDestroy(user->edit_lines);
	ListDestroy(user->tells);
	delete_user(user);
	--num_of_users;

	/* Clear user ignore bits for users after someone just logged off */
	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		((USER_DATA *)NodeData(node))->ignore[id / CHAR_BIT] &= ~(1 << (id % CHAR_BIT));
		node = NodeNext(node);
	}

#if	PORT_WHO
	list_users(NULL, -1, NULL);	/* Update the who file */
#endif
}


/* We can't use yore() directly as a callback function */
/* since it needs arguments so use this routine instead*/
void more_callback()
{
	if (more(this_user, this_user->users_file) == MORE_DONE)
		this_user->callback = NULL;
}


/*** Page a file out to user like unix "more" comamand ***/
/* This function outputs CR-LF at the end of the lines as*/
/* necessary to ensure that lines will start at the left */
/* side of the screen on terminals that need both chars. */
/* NOTE: Files output during log in of a user should not */
/* be longer then DEFAULT_COLS columns long.			 */
int more(user, filename)
USER_DATA *user;
char *filename;
{
	static char *more_prompt = "*** Press RETURN to continue, or Q to quit: ";
	int line_len;					/* Number of characters on current line */
	int mess_len;					/* Number of characters in mess[] buffer*/
	int lines;
	int max_lines;
	int max_cols;
	int more_state;					/* Indicates need to show line number */
	int show_numbers;				/* Should line numbers be displayed?  */
	long file_posn;
	char num[10], buff[161];
	char *s;
	FILE *fp;

	if (user->callback != NULL)
	{
		if (toupper(inpstr[0]) == 'Q')
		{
			this_user->file_posn = 0L;
			this_user->show_nums = 0;
			if (this_user->tmpfile)	/* Is it a temporary file? */
			{
				this_user->tmpfile = 0;
				unlink(this_user->users_file);
			}
			user->noprompt = 0;
			user->callback = NULL;
			return MORE_DONE;
		}
	}

	if ((fp = fopen(filename, "r")) == NULL)
	{
		user->file_posn = 0L;
		user->show_nums = 0;
		return MORE_NO_FILE;
	}

	if (!user->paging)
	{
		mess_len = 0;
		user->msg_num = 0;

		fgets(buff, sizeof(buff), fp);
		while (!feof(fp))
		{
			if (user->show_nums)
			{
				sprintf(num, "[%d] ", ++user->msg_num);
				write_user(user, num, MSG_FORCED);
			}
			write_user(user, buff, MSG_FORCED);

			fgets(buff, sizeof(buff), fp);
		}
	}
	else
	{
		/* Return to where we left off */
		more_state = show_numbers = user->show_nums;	/* Assume new message */
		max_lines = user->rows - 2;
		max_cols = user->cols;
		file_posn = user->file_posn;

		if (file_posn == 0L)
		{
			user->msg_num = 0;
		}
		else
		{	/* Check to see if last char. previously output was a newline */
			--file_posn;
			fseek(fp, file_posn, 0);
			if (getc(fp) != '\n')
				more_state = 0;	/* Oops...we are in the middle of a message */
		}

		if (!user->paging || this_user->logging_in != LOGIN_DONE)
			max_lines = 0;		/* Turn off paging */

		/* loop until end of file or end of page reached */
		lines = 0;
		line_len = 0;
		buff[sizeof(buff) - 1] = '\0';
		fgets(buff, sizeof(buff) - 1, fp);
		mess[0] = '\0';
		mess_len = 0;
		s = buff;
	}

	while (!feof(fp) && (max_lines == 0 || lines < max_lines))
	{
		/* Starting a new line and want to show message numbers? */
		if (show_numbers && more_state == 1)
		{	/* This is the only reliable time to update the message number */
			sprintf(num, "[%d] ", ++user->msg_num);
			strcpy(&mess[mess_len], num);
			line_len = strlen(num);
			mess_len += line_len;
			more_state = 0;
		}
		while (*s && *s != '\n' && line_len < max_cols && mess_len < (ARR_SIZE -10))
		{
			mess[mess_len++] = *s++;
			++line_len;
			++file_posn;
		}

		/* Are we at the end of a line or end of a screen line? */
		if (*s == '\n' || line_len >= max_cols)
		{
			/* We just found end of line so ignore newline char */
			/* so we don't wind up with blank line by mistake.  */
			if (*s == '\n')
			{
				more_state = 1;		/* Indicate we want a new line number */
				++s;				/* Skip over the newline character.   */
				++file_posn;
			}

			mess[mess_len++] = '\n';
			++lines;
			line_len = 0;
		}
		if (mess_len >= (ARR_SIZE - 10))
		{
			mess[mess_len] = '\0';
			write_user(user, mess, MSG_FORCED);
			mess_len = 0;
		}
		if (*s == '\0')
		{
			fgets(buff, sizeof(buff) - 1, fp);
			s = buff;
		}
	}

	if (mess_len > 0)
	{
		mess[mess_len] = '\0';
		write_user(user, mess, MSG_FORCED);
	}

	more_state = MORE_NOTDONE;
	if (feof(fp))
	{
		user->file_posn = 0L;
		user->show_nums = 0;
		user->noprompt = 0;
		write_user(this_user, "\n", MSG_FORCED);
		if (user->tmpfile)
		{
			user->tmpfile = 0;
			unlink(filename);
		}
		more_state = MORE_DONE;
	}
	else
	{
		strncpy(user->users_file, filename, 80);
		user->file_posn = file_posn;

		/* If last line didn't end in a newline, add */
		/* one so prompt will be on a line by itself */
		if (line_len > 0)
			sprintf(mess, "\n%s", more_prompt);
		else
		{
			strcpy(mess, more_prompt);
			if (show_numbers)
				user->show_nums = 1;
		}
		write_user(user, mess, MSG_FORCED);
		user->noprompt = 1;
		user->callback = more_callback;
	}

	fclose(fp);

	return more_state;
}


#if	!HONOUR_TELNET
/*** Tell telnet not to echo characters - for password entry ***/
void echo_off(USER_DATA *user)
{
	if (!PASSWORD_ECHO)
	{
#if	DEBUG_TELNET
		write_user(user, "*SENT WILL ECHO*\n", MSG_FORCED);	/* ~~~~~ */
#endif
#if	HONOUR_TELNET
		tnsetopt(this_user->tn, TNEcho, THEYARENT);
#else
		write_user(user, "\xFF\xFB\x01", MSG_FORCED);	/* Output 255, 251, 1 to turn off echo */
#endif
	}
}


/*** Tell telnet to echo characters ***/
void echo_on(USER_DATA *user)
{
	if (!PASSWORD_ECHO)
	{
#if	DEBUG_TELNET
		write_user(user, "*SENT WONT ECHO*\n", MSG_FORCED);	/* ~~~~~ */
#endif
#if	HONOUR_TELNET
		tnsetopt(this_user->tn, TNEcho, THEYARE);
#else
		write_user(user, "\xFF\xFC\x01", MSG_FORCED);	/* Output 255, 252, 1 to turn on echo */
#endif
	}
}
#endif


/*** Return a time string ***/
char *timeline(full_time)
int full_time;
{
	static char timestr[30];
	time_t tm_num;

	time(&tm_num);
	if (full_time)
	{
		strcpy(timestr, ctime(&tm_num));
		timestr[ strlen(timestr) - 1 ] = '\0';
	}
	else
		midcpy(ctime(&tm_num), timestr, 4, 15);
	return timestr;
}


/*** Send a string to a specified log file ***/
void write_syslog(str, logfile, write_time)
char *str;
char *logfile;
int write_time;
{
	FILE *fp;
	time_t tm_num;
	char *timestr;
	char line[20];
#if	LOG_MULTI_FILES
	char filename[80];
#endif

	if (!syslog_on || logfile == LOG_NONE)
		return;

	time(&tm_num);
	timestr = ctime(&tm_num);

#if	LOG_MULTI_FILES
#if	LOG_DAILY_FILES
	sprintf(filename, "%s/%.3s/%s", LOGDIR, timestr, logfile);
#else
	sprintf(filename, "%s/%s", LOGDIR, logfile);
#endif
	if ( (fp = fopen(filename, "a")) == NULL )
		return;
#else
	if ( (fp = fopen(SYSTEM_LOG, "a")) == NULL )
		return;
#endif

	if (!write_time)
		fputs(str, fp);
	else
	{
		sprintf(line, "%.15s ", &timestr[4]);
		fputs(line, fp);
		fputs(str, fp);
	}
	fclose(fp);
}


#if	NEW_SOCKET_IO
/*** perform_socket_write for all Non-Windows platforms ***/
int perform_socket_write(int sock, char *str, size_t length)
{
	char buff[80];
	ssize_t result;

	if (length <= 0)
	{
		sprintf(buff, "SYSERR: perform_socket_write() called with length %d", length);
		write_syslog(buff, LOG_ERROR, 1);
		return 0;
	}
	
	result = write(sock, str, length);

	if (result > 0)		/* Write was successful. */
		return result;

	if (result == 0)
	{	/* This should never happen! */
		write_syslog("SYSERR: Huh??  write() returned 0???  Please report this!", LOG_ERROR, 1);
		return -1;
	}

	/* result < 0, so an error was encountered - is it transient?	*/
	/* Unfortunately, different systems use different constants to	*/
	/* indicate this.												*/

#ifdef EAGAIN       /* POSIX */
	if (errno == EAGAIN)
		return 0;
#endif

#ifdef EWOULDBLOCK  /* BSD */
	if (errno == EWOULDBLOCK)
		return 0;
#endif

#ifdef EDEADLK      /* Macintosh */
	if (errno == EDEADLK)
		return 0;
#endif

	/* Looks like the error was fatal.  Too bad. */
	return -1;
}


/*
 * write_to_socket takes a socket, and text to write to the
 * socket.  It keeps calling the system-level write() until all
 * the text has been delivered to the OS, or until an error is
 * encountered.
 *
 * Returns:
 *  0  If all is well and good,
 * -1  If an error was encountered, so that the player should be cut off
 */
/*** This routine sends a string of characters down socket ***/
int write_to_socket(USER_DATA *user, char *txt, int bytes_to_write)
{
	ssize_t bytes_written;
	char line[80];

	while (bytes_to_write > 0)
	{	/* Don't write to users socket if there was an error */
		if (user->sock_err)	/* In case of a SIGPIPE signal or other error */
			return -1;

		bytes_written = perform_socket_write(user->sock, txt, bytes_to_write);

		if (bytes_written < 0 || user->sock_err)
		{
			/* Fatal error.  Disconnect the player. */
			sprintf(line, "Error writing to socket %d ", user->sock);
			write_syslog(line, LOG_ERROR, 1);
			if (user->logging_in != LOGIN_GET_NAME)
			{
				sprintf(line, "for %s ", user->name);
				write_syslog(line, LOG_ERROR, 0);
			}
			sprintf(line, "(sock_err = %d)\n", user->sock_err);
			write_syslog(line, LOG_ERROR, 0);
			return -1;
		}
		if (bytes_written == 0)
		{
			/*
			* Temporary failure -- socket buffer full.  For now we'll just
			* cut off the player, but eventually we'll stuff the unsent
			* text into a buffer and retry the write later.  JE 30 June 98.
			*/
			write_syslog("write_to_socket: User %s - socket %d would block",
						user->name, user->sock);
			return -1;
		}

		txt += bytes_written;
		bytes_to_write -= bytes_written;

#if	DEBUG_SOCKET
		if (bytes_to_write > 0)
		{
			sprintf(line, "write_to_socket: short write for %s", user->name);
			write_syslog(line, LOG_ERROR, 1);
		}
#endif
	}

	return 0;
}
#else
#define write_to_socket(user, str, length)	write(user->sock, str, length)
#endif	/* NEW_SOCKET_IO */


/*** write_user sends a string to a users socket ***/
/*** NOTE: Once disconnect bit is set in users	 ***/
/*** data structure, they will get no more msgs. ***/
void write_user(user, str, msg_type)
USER_DATA *user;
char *str;
unsigned int msg_type;
{
	char buff[ARR_SIZE];			/* Buffer holding string to output */
	int buff_len;					/* Number of characters in buff[] */
	char *s;						/* Pointer into the buff[] array */
	int max_cols;					/* Maximum number of columns on screen */
	int line_len;					/* Number of characters on current line */
	int column;						/* Current screen column number */
	int code_len;					/* Number of chars in bold code */
	int bold_on;					/* Says if we are inside bolded string */
	int wrap;						/* Says if word wrap is to be used */
	char **hilight_codes;			/* Points to bold "codes" to be used */
	int error;

	if ( (user->which_msgs & msg_type) == 0 )
		return;

	/* Ignore the write request if user is in BAFK mode, had */
	/* a socket error, or the user is marked for disconnect. */
	if (user->bafk || user->sock_err || user->disconnect)
		return;

	/* Let SIGPIPE handler know to which user message will be sent */
	which_user = user;

	/* If this_user is NULL skip ignoring message checks as message	*/
	/* would be coming from the sigalrm_handler() stuff (ie. atmospherics).	*/
	if (this_user != NULL)
	{
		/* If user is ignoring user who originated message, don't send it */
		buff_len = this_user->user_id;
		if ( user->ignore[ buff_len / CHAR_BIT ] & (1 << (buff_len % CHAR_BIT)) )
			return;
	}

	if (allow_bold && user->use_bold)
	{
		hilight_codes = bold_codes;
		code_len = 4;
	}
	else
	{
		hilight_codes = normal_codes;
		code_len = 1;
	}

	bold_on = 0;
	buff_len = 0;
	column = 0;
	max_cols = user->cols;
	wrap = user->wrap;
	line_len = 0;
	s = buff;

	while (*str)		/* loop until end of string */
	{
		while (*str && *str != '\n' && line_len < max_cols && buff_len < (ARR_SIZE - 6))
		{
			if (*str != '^')
			{
				*s++ = *str++;
				++buff_len;
				++line_len;
			}
			else	/* Found request for bold text? */
			{
				if (str[1] == '^')	/* Nope. User wants a '^' character */
				{
					*s++ = *str++;
					++buff_len;
					++line_len;
				}
				else
				{
					bold_on ^= 1;					/* Flip bold flag */
					strcpy(s, hilight_codes[bold_on]);	/* Add Bold code */
					s += code_len;
					buff_len += code_len;			/* Chars in bold code just added */
				}
				++str;	/* Skip over the '^' character */
			}
		}
		if (*str == '\n' || line_len >= max_cols)
		{
			/* We have just wrapped so ignore new line at end of line */
			/* so we don't wind up with a blank line by mistake.	  */
			if (line_len >= max_cols && str[1] == '\n')
				++str;	/* Points to newline which will be dealt with next */
			if (*str == '\n' && bold_on)		/* Was bold left on? */
			{	/* Turn off bold so it doesn't go past end of a line */
				strcpy(s, hilight_codes[0]);	/* Add Bold off code */
				s += code_len;
				buff_len += code_len;			/* Chars in bold code just added */
				bold_on = 0;					/* Clear bold flag */
			}
			if (*str == '\n' || (wrap && (line_len >= max_cols)))
			{
				if (*str == '\n')	/* This is in case we have filled screen line */
					++str;			/* Skip over newline */
				*s++ = '\r';
				*s++ = '\n';
				buff_len += 2;
			}
			line_len = 0;		/* Only do if we are wrapping? ~~~~~ */
		}
		if (buff_len >= (ARR_SIZE - 6))
		{
			error = write_to_socket(user, buff, buff_len);
			if (error < 0)	/* Hm...got an error writing to users socket */
			{
#if	DEBUG_SOCKET
#if	NEW_SOCKET_IO
				sprintf(buff, "*write_user 1 - err %d, sock_err %d*\r\n", error, user->sock_err);
#else
				sprintf(buff, "*write_user 1 - err %d*\r\n", error);
#endif
				write_to_socket(this_user, buff, strlen(buff));
#endif
				user->sock_err = 1;
				return;
			}
			s = buff;
			buff_len = 0;
		}
	}

	if (bold_on)	/* Was bolding left on? */
	{
		if ((buff_len + code_len) > sizeof(buff))	/* No room for off code? */
		{
			error = write_to_socket(user, buff, buff_len);	/* Output what we have */
			if (error < 0)	/* Hm...got an error writing to users socket */
			{
#if	DEBUG_SOCKET
#if	NEW_SOCKET_IO
				sprintf(buff, "*write_user 2 - err %d, sock_err %d*\r\n", error, user->sock_err);
#else
				sprintf(buff, "*write_user 2 - err %d*\r\n", error);
#endif
				write_to_socket(this_user, buff, strlen(buff));
#endif
				user->sock_err = 1;
				return;
			}
			buff_len = 0;
			s = buff;
		}
		strcpy(s, hilight_codes[0]);
		buff_len += code_len;
		bold_on = 0;
	}
	if (buff_len > 0)
	{
		error = write_to_socket(user, buff, buff_len);	/* This will not handle bold */
		if (error < 0)	/* Hm...got an error writing to users socket */
			user->sock_err = 1;
#if	DEBUG_SOCKET
#if	NEW_SOCKET_IO
		sprintf(buff, "*write_user 3 - err %d, sock_err %d*\r\n", error, user->sock_err);
#else
		sprintf(buff, "*write_user 3 - err %d*\r\n", error);
#endif
		write_to_socket(this_user, buff, strlen(buff));
#endif
	}
}


/*** output to all areas if area==-1 else only users in same area ***/
/*** user will receive output as well if sent_to_user is set to 1 ***/
void write_alluser(user, str, area, send_to_user, msg_type)
USER_DATA *user;
char *str;
AREA_DATA *area;
int send_to_user;
unsigned int msg_type;
{
	Node *node;
	USER_DATA *u;

	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		u = (USER_DATA *)NodeData(node);
		node = NodeNext(node);

		if ((!send_to_user && user == u) || u->area == NULL)
			continue;

		if (u->area == area || area == NULL)
			write_user(u, str, msg_type);
	}
}


/*** This function is used to create a file which will be output in pages ***/
void page_user_output(USER_DATA *user, char *text, int func)
{
FILE *fp;
int cnt;

	switch (func)
	{
	case PGOUT_NEW:
		if (tmpnam(user->users_file) == NULL)
		{
			write_user(user, "Sorry - Couldn't create name for temporary file", MSG_FORCED);
			write_syslog("ERROR: Couldn't create name for temporary file in page_user_output()\n", LOG_ERROR, 1);
			return;
		}

		user->tmpfile = 1;
		break;

	case PGOUT_ADD:
		if ((fp = fopen(user->users_file, "a")) == NULL)
		{
			sprintf(mess, "%s : couldn't open temporary file\n", syserror);
			write_user(user, mess, MSG_FORCED);
			write_syslog("ERROR: Couldn't open tempfile for append in page_user_output()\n", LOG_ERROR, 1);
			return;
		}

		cnt = strlen(text);
		if (cnt != fwrite(text, 1, cnt, fp))
		{
			/* How should a write error be handled? ~~~~~ */
		}
		fclose(fp);
		break;

	case PGOUT_DONE:
		(void)more(user, user->users_file);
		break;
	}
}


/*** set up data for new user if he can get on ***/
void add_user(user)
USER_DATA *user;
{
	char filename[80];
	USER_DATA *u_old;
	Node *node;
	char type[12];
	int i;

	--login_count;	/* User is no longer logging in */

#if HONOUR_TELNET
	tnsetopt(user->tn, TNEcho, WEARENT);
	tnsetstat(user->tn, ECHOCHARS, user->echo); /* resync */
#else
	echo_on(user);
#endif

	/* Is user already logged on? */
	u_old = find_userdata(user, user->name, 1, 0);
	if (u_old != NULL)
	{	/* Keep old userdata structure and delete new */
		/* structure after copying some data items.   */
		write_user(user, "\nYou are already signed on - switching to old session\n\n", MSG_FORCED);
		this_user = u_old;	/* It was pointing to node about to be deleted */
		write_user(u_old, "\nSwitching to new session...\n\n", MSG_FORCED);
		close(u_old->sock);
		u_old->sock = user->sock;
		memcpy(&u_old->old_site, &u_old->site, sizeof(struct site));
		memcpy(&u_old->site, &user->site, sizeof(struct site));
		u_old->cols = user->cols;
		u_old->rows = user->rows;
#if	HONOUR_TELNET
		tnsetstat(u_old->tn, SOCKET, u_old->sock);
#endif

		free_id(user->user_id);
		node = NodeFind(ulist, user);	/* Find node just added to list */
		(void)NodeRemove(node);
		if (nextnode == node)
			nextnode = NodeNext(node);
		NodeDestroy(node);
#if	SU_PROTECT
		su_protect(u_old);
#endif
		look_cmd(u_old);
		prompt(u_old);
		sprintf(mess, "RELOG FOR: %s %s\n", u_old->name, u_old->desc);
		write_alluser(u_old, mess, NULL, 0, MSG_LOGON);
		return;
	}

	user->logging_in = LOGIN_DONE;
	user->freeze_time = 0;

	if (user->arrested)
		user->area = jail;
	else
		user->area = (AREA_DATA *)NodeData( NodeHead(astr) );
	user->login = time(NULL);
	user->tells = ListCreate();
	user->tell_lines = 0;
	++num_of_users;

	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, user->name[0], user->name);
	user->mailmsgs = messcount(filename);

#if	PORT_WHO
	list_users(NULL, -1, NULL);	/* Update the who file */
#endif

/* Send intro stuff */
	if (PASSWORD_ECHO)
	{
		/* Send enough blank lines to clear user password from the screen */
		for (i = 0; i < 5; ++i)
			write_user(user, "\n\n\n\n\n\n\n\n\n\n", MSG_FORCED);
	}
	switch (user->level)
	{
	case DUNCE:
	case USER:
		type[0] = '\0';
		break;
	case WIZARD:
		sprintf(type, "%s ", levstr[ user->level ]);
		break;
	case SU:
	case SU_SU:
		strcpy(type, "caretaker ");
		break;
	}
	sprintf(mess, "\n\n\nWelcome %s%s!\n", type, user->name);
	write_user(user, mess, MSG_FORCED);
	if (user->last_off != 0L)
	{
		sprintf(mess, "Last logged in %.24s from %s\n",
				ctime(&user->last_off), print_site(&user->old_site));
		write_user(user, mess, MSG_FORCED);
	}

/* send 2nd message of the day */
	i = user->paging;
	user->paging = 0;
	(void)more(user, MOTD2);
	user->paging = i;

#if	SU_PROTECT
	su_protect(u);
#endif

	look_cmd(user);		/* Show description of area */

/* does user have mail? */
	if (user->mailmsgs > 0)
	{
		if (user->lastmail < user->mailmsgs)
			write_user(user, "\n^** YOU HAVE NEW MAIL **^\n", MSG_FORCED);
		else
			write_user(user, "\n^** YOU HAVE MAIL **^\n", MSG_FORCED);
	}
	prompt(user);

/* send message to other users and to file */
	type[0] = '\0';
	if (user->arrested)
		sprintf(type, "[JAILED] ");
	else
	{
		if (login_show_lvl && user->level >= login_show_min)
			sprintf(type, "[%s] ", levstr[user->level]);
	}
	sprintf(mess, "%sSIGN ON: %s %s\n", 
			type, user->name, user->desc);
	write_alluser(user, mess, NULL, 0, MSG_LOGON);
	sprintf(mess, "%s signed on from %s\n",
			user->name, print_site(&user->site));
	write_syslog(mess, LOG_LOGINS, 1);
	record_login(mess);
}


/*** Comparison routine used by qsort() ***/
/** Sorts user names for each user level **/
int cmp_people(const void *user1, const void *user2)
{
	USER_DATA *u1 = *((USER_DATA **)user1);
	USER_DATA *u2 = *((USER_DATA **)user2);
	int i;

	if (u1->logging_in == LOGIN_DONE &&
		u2->logging_in != LOGIN_DONE)
			return -1;
	if (u1->logging_in != LOGIN_DONE &&
		u2->logging_in == LOGIN_DONE)
			return 1;

	if (u1->level > u2->level)
		return -1;
	if (u1->level < u2->level)
		return 1;

	if (u1->name[0] != '\0' && u2->name[0] == '\0')
		return -1;
	if (u1->name[0] == '\0' && u2->name[0] != '\0')
		return 1;

	i = strcmp(u1->name, u2->name);
	if (i != 0)
		return i;

	if (u1->user_id < u2->user_id)
		return -1;
	if (u1->user_id > u2->user_id)
		return 1;

	return 0;	/* We should never get this far */
}


/*** Comparison routine used by qsort() ***/
/*** Sorts user names for each area.    ***/
int cmp_who(const void *user1, const void *user2)
{
	USER_DATA *u1 = *((USER_DATA **)user1);
	USER_DATA *u2 = *((USER_DATA **)user2);

	if (u1->area < u2->area)
		return -1;
	if (u1->area > u2->area)
		return 1;

	if (u1->level > u2->level)
		return 1;
	if (u1->level < u2->level)
		return -1;

	return strcmp(u1->name, u2->name);
}


#define OUTPUT_WHO(mess)  \
		{ \
		if (user == NULL) \
			fputs(mess, who_fp); \
		else \
			write_user(user, mess, MSG_FORCED); \
		}

/***********************************************************/
/* List users in given area, on the board, or another port */
/* people == 0 -> list in conventional format (who command)*/
/* people == 1 -> list in WIZARD format (people command)   */
/* people == -1 -> if PORT_WHO defined, write to who file  */
/* people == -port -> list users on the specified port     */
/* area != NULL -> only users in this area of this port    */
/* area == NULL -> list all users logged in to this port   */
/* PORT_WHO does not apply to (people == 1)                */
/***********************************************************/
void list_users(user, people, area)
USER_DATA *user;
#if	PORT_WHO
long people;
#else
int people;
#endif
AREA_DATA *area;
{
	unsigned int ignore_all, listen_all;
	int idle, min, invis_cnt;
	USER_DATA *u, **list;
	Node *node;
	int num, t, cols;
	int user_cnt;
	char user_name[NAME_LEN];
	char temp[80];
	time_t now;
#if PORT_WHO
	char filename[80];
	FILE *who_fp;

	if (people < 0)
	{
		if (people < -1)
		{
			sprintf(filename, "%s/who.%ld", TMPDIR, -people);
			if (access(filename, F_OK) != 0)
			{
				write_user(user, "No information is currently available for that port\n", MSG_FORCED);
				return;
			}

			if (tmpnam(temp) == NULL)
			{
				write_user(user, "Sorry - Couldn't create name for temporary file", MSG_FORCED);
				write_syslog("ERROR: Couldn't create name for temporary file in list_users()\n", LOG_ERROR, 1);
				return;
			}

			if (file_copy(filename, temp) == -1)
			{
				write_user(user, "Sorry, can't create the temporary file\n", MSG_FORCED);
				return;
			}

			user->tmpfile = 1;
			(void)more(user, temp);
			return;
		}

		sprintf(filename, "%s/who.%u", TMPDIR, port);
		who_fp = fopen(filename, "w");
		if (who_fp == NULL)
		{
			write_user(user, "Sorry, can't create the who file\n", MSG_FORCED);
			return;
		}
	}
#endif

	invis_cnt = 0;
	user_cnt = 0;

	/* Who uses people who are really logged in and in given area. */
	if (people == 1)
		num = num_of_users + login_count;
	else
		num = find_num_in_area(area);
	if (num <= 0)
		list = NULL;
	else
	{
		if ( (list = (void *)malloc(sizeof(USER_DATA *) * num)) == NULL ) 
			num = 0;
	}

	/*** Fill array with pointers to user data structures ***/
	t = 0;
	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node) && t < num)
	{
		u = (USER_DATA *)NodeData(node);
		node = NodeNext(node);

		/* People lists everyone regardless of login status,	*/
		/* otherwise user must be logged in and in current area */
		if ( people == 1 || (u->area != NULL && (u->area == area || area == NULL)) )
		{
			list[t++] = u;
		}
	}

	if (num > 1)
	{
		if (people == 1)
			qsort(list, num, sizeof(USER_DATA *), cmp_people);
		else
			qsort(list, num, sizeof(USER_DATA *), cmp_who);
	}

	time(&now);
	if (people == 1)
		OUTPUT_WHO("Name            : Level   Line Lstn Vis Idle Mins Site\n");

/* go through list of users connected to this port */
	for (t = 0; t < num; ++t)
	{
		u = list[t];

		if (area != NULL)		/* List for specific area? */
		{
			/* Only list visible users in same area who are not this user */
			if (area != u->area || user == u || !u->vis)
				continue;
		}

		/* Is the user not logged in yet? */
		if (u->area == NULL)
		{
			if (people == 1 && u->logging_in != LOGIN_DONE)
			{
				if (u->name[0] == '\0')
					sprintf(mess, "LOGIN from %s on line %d\n",
							print_site(&u->site), u->user_id);
				else
				{
					sprintf(mess, "LOGIN by %s from %s on line %d\n",
							u->name, print_site(&u->site), u->user_id);
				}
				OUTPUT_WHO(mess);
			}
		}
		else	/* This user in online */
		{	/* Only count invisible users and don't show them	*/
			/* if user asking for the list isn't high enough.	*/
			if (!u->vis)
			{
				if (people == -1 || (user->level < u->level && u->level > USER))
				{
					++invis_cnt;
					continue;
				}
			}

			/* Set variables which state the contents of 'which_msgs' */
			/* when individuals ignore or listen to everything.		  */
			if (u->level < MAGICAL)
			{
				ignore_all = MSG_FORCED | MSG_BCAST;	/* Users always see these msgs */
				listen_all = MSG_ALL;
			}
			else
			{
				ignore_all = MSG_FORCED;
				listen_all = MSG_WALL;
			}

			min = (now - u->login) / 60;
			idle = (now - u->last_input) / 60;

			strcpy(user_name, u->name);
			if (!u->vis)
				user_name[0] = tolower(user_name[0]);

			if (people == 1)
			{
				cols = this_user->cols - 50;
				if (cols < 0)
					cols = this_user->cols;
				sprintf(mess, "%-*s : %-*s %3d %4s %3s %4d %4d %.*s\n",
						NAME_LEN, user_name, LEVSTR_LEN,
						u->arrested ? "JAILED" : levstr[u->level],
						u->user_id,
						(u->which_msgs == ignore_all) ? "NO" :
							(u->which_msgs == listen_all ? "YES" : "SOME"),
							yesno[u->vis], idle, min,
							cols, print_site(&u->site));
			}
			else
			{
				/* Temp buffer will contain user name and the users real */
				/* description or something saying what they are doing.  */
				if (u->afk)
					sprintf(temp, "%s is AFK", user_name);
				else if (u->idle_mention > 0)
					sprintf(temp, "%s appears to be sleeping", user_name);
				else if (u->file_posn != 0L)
					sprintf(temp, "%s is reading something", user_name);
				else if (u->edit_lines != NULL)
				{
					if (u->pro_enter)
						sprintf(temp, "%s is entering a profile", user_name);
					else
						sprintf(temp, "%s is entering something", user_name);
				}
				else if (u->which_msgs == ignore_all)
					sprintf(temp, "%s is ignoring everyone", user_name);
				else if (u->arrested)
					sprintf(temp, "%s is under arrest", user_name);
				else if (u->stun)
					sprintf(temp, "%s has been stunned", user_name);
				else if (u->gagged)
					sprintf(temp, "%s is wearing a gag", user_name);
				else if (u->muzzled)
					sprintf(temp, "%s is wearing a muzzle", user_name);
				else
					sprintf(temp, "%s %s", user_name, u->desc);
				if (area != NULL)	/* For a single area only? */
				{
					if (user_cnt == 0)
						OUTPUT_WHO("You can see:\n");
					sprintf(mess, "    %s\n", temp);
				}
				else
				{
#if PORT_WHO
					if (people == -1)
					{
#if BIRDDOG_FIND
						sprintf(mess, "(%s) [%s] %s %s\n",
								u->area->name, levstr[u->level],
								u->name, u->desc);
#else
						sprintf(mess, "%-33.33s : %-*s : %-*s: %d mins\n",
								temp, LEVSTR_LEN,
								u->arrested ? "JAILED" : levstr[u->level],
								AREA_NAME_LEN, u->area->name, min);
#endif
					}
					else
#endif
					sprintf(mess, "%-40.40s : %-*s : %-*s: %d mins\n",
							temp, LEVSTR_LEN,
							u->arrested ? "JAILED" : levstr[u->level],
							AREA_NAME_LEN, u->area->name, min);
				}
			}
			OUTPUT_WHO(mess);
			++user_cnt;
		}
	}
	if (list != NULL)
		free(list);

	if (area != NULL)
	{
		if (user_cnt == 0)
			OUTPUT_WHO("You are alone here\n");
	}
	else
	{	/* Mention number of invisible users if listing who is logged in */
		if (invis_cnt > 0)
		{
			sprintf(mess, "\nThere are %d users invisible to you\n", invis_cnt);
			OUTPUT_WHO(mess);
		}
	}

	if (area == NULL)	/* area is not NULL when called by .look */
	{
		sprintf(mess, "\nTotal of %d users signed on\n", user_cnt);
		OUTPUT_WHO(mess);
	}
	if (people == -1)
		fclose(who_fp);
}


/*** skip any leading blanks in str ***/
char *skip_blanks(str)
char *str;
{
	while (*str && *str <= ' ')
		++str;
	return str;
}


/*** return pos. of second word in str ***/
char *skip_word(str)
char *str;
{
	char *pos = str;

	while (*pos <= ' ' && *pos)
		++pos;
	while (*pos > ' ')
		++pos;
	while (*pos <= ' ' && *pos)
		++pos;
	return pos;
}


/* Returns index of a choice made from a list */
/* Only as many characters as are in 'word'   */
/* will be checked for a match.				  */
int choose(char *word, char *choices[])
{
	int i, j, len;

	if (*word == '\0')
		return -1;

	len = strlen(word);

	for (i = 0; choices[i] != NULL; ++i)
	{
		for (j = 0; j < len; ++j)
		{
			if (toupper(word[j]) != toupper(choices[i][j]))
				break;
		}
		if (j >= len)
			return i;
	}

	return -1;
}


/* Insert a space at pos to str so that users can type ;smiles or ; smiles */
void insert_space(str, pos)
char *str;
int  pos;
{
	char tmpcmd[ARR_SIZE];

	strcpy(tmpcmd, &str[pos]);
	str[pos] = ' ';
	strcpy(&str[pos + 1], tmpcmd);
}


/*** gets number of command entered (if any) ***/
int get_com_index(str)
char *str;
{
	char *s, comstr[20];	/* No command word will ever be longer than this? */
	int cmd_len;
	int index;
	int pos;

	get_word(str, comstr, sizeof(comstr));	/* Put first word of input into comstr */
	strtolower(comstr);

	/* Handle various aliases for commonly used commands.	*/
	/* > to .tell, ; or : to .emote, / or ;; to .premote, ! to .semote */
	pos = 0;
	if (strncmp(comstr, ";;", 2) == 0)
	{
		pos = 2;
		strcpy(comstr, ".premote");
	}
	/* The : is here to satisfy all the people that are used to IRC */
	else if (comstr[0] == ';' || comstr[0] == ':')
	{
		pos = 1;
		strcpy(comstr, ".emote");
	}
	else if (comstr[0] == '/')
	{
		pos = 1;
		strcpy(comstr, ".premote");
	}
	else if (comstr[0] == '!')
	{
		pos = 1;
		strcpy(comstr, ".semote");
	}
	else if (comstr[0] == '>')
	{
		pos = 1;
		strcpy(comstr, ".tell");
	}
	else if (comstr[0] == '[')
	{
		pos = 1;
		strcpy(comstr, ".sayto");
	}
	if (pos > 0)
		insert_space(inpstr, pos);

	if (comstr[0] != '.')
		return CMD_BAD;

	index = 0;
	s = &comstr[1];
	if (*s == '\0')
		return CMD_BAD;
	cmd_len = strlen(comstr) - 1;	/* Don't count the '.' */
	while (cmd_info[index].func != NULL)
	{
		if (strncmp(cmd_info[index].string, s, cmd_len) == 0)
			return index;
		++index;
	}
	return CMD_BAD;
}


/*** This routine performs a case-insensitive search ***/
/*** of source string ss looking for string sf       ***/
int instr(ss, sf)
char *ss, *sf;
{
	int ofs;

	if (*sf == '\0')	/* This shouldn't happen but just in case... */
		return -1;

	while (*ss)
	{
		ofs = 0;
		do {
			if (sf[ofs] == '\0' && ofs > 0)
				return 1;
			if (toupper(sf[ofs]) != toupper(ss[ofs]))
				break;
		} while (++ofs);

		++ss;
	}
	return 0;
}


/*** Finds number or users in given area ***/
/* If area=-1 it returns total user count. */
int find_num_in_area(AREA_DATA *area)
{
	Node *node;
	int num;

	if (area == NULL)
		return num_of_users;

	num = 0;

	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		if (((USER_DATA *)NodeData(node))->area == area)
			++num;

		node = NodeNext(node);
	}
	return num;
}


/*** Convert seconds to "weeks, days, hours, minutes" format ***/
char *secstostring(time_t seconds)
{
	static char string[80];
	char *p;
	int weeks, days, hours, mins;
	int i;	/* Used to count number of items converted to string */

	i = 0;

	mins = seconds / 60;

	hours = mins / 60;
	mins  = mins % 60;

	days  = hours / 24;
	hours = hours % 24;

	weeks = days / 7;
	days  = days % 7;

	string[0] = '\0';
	p = string;
	if (weeks > 0)
	{
		if (weeks == 1)
			strcpy(p, "1w");
		else
			sprintf(p, "%dw", weeks);
		++i;
	}

	p += strlen(p);
	if (days > 0)
	{
		if (p > string)
		{
			*p++ = ',';
			*p++ = ' ';
		}
		if (days == 1)
			strcpy(p, "1d");
		else
			sprintf(p, "%dd", days);
		++i;
	}

	p += strlen(p);
	if (hours > 0)
	{
		if (p > string)
		{
			*p++ = ',';
			*p++ = ' ';
		}
		if (hours == 1)
			strcpy(p, "1h");
		else
			sprintf(p, "%dh", hours);
		++i;
	}

	p += strlen(p);
	if (mins > 0)
	{
		if (p > string)
		{
			*p++ = ',';
			*p++ = ' ';
		}
		if (mins == 1)
			strcpy(p, "1m");
		else
			sprintf(p, "%dm", mins);
		++i;
	}

	/* After we have had more than two other larger time values than */
	/* seconds output to the string, seconds become insignificant.	 */
	if (i < 3)
	{
		p += strlen(p);
		if (p > string)
		{
			*p++ = ',';
			*p++ = ' ';
		}
		seconds %= 60;
		if (seconds == 1)
			strcpy(p, "1s");
		else
			sprintf(p, "%ds", (int)seconds);
	}

	return string;
}


/*** Get a number from a string. Update the pointer to the ***/
/*** input string to the first character after the digits. ***/
int get_num(s)
char **s;
{
	int num;

	if (!isdigit(**s))
		num = -1;
	else
		num = atoi(*s);

	while (isdigit(**s))
		++(*s);

	return num;
}


/*** Check a list of message numbers to see that they are valid ***/
int check_list(user, max_num, num_list)
USER_DATA *user;
int max_num;
char *num_list;
{
	int num1, num2;
	int count;
	char *s;

	count = 0;
	s = num_list;

	while (*s)
	{
		s = skip_blanks(s);
		num1 = get_num(&s);
		if (num1 < 0)
		{
			if (num1 < 0)
				write_user(user, "Invalid number\n", MSG_FORCED);
			if (num1 > max_num)
			{
				sprintf(mess, "There are only %d messages\n", max_num);
				write_user(user, mess, MSG_FORCED);
			}
			count = -1;
			break;
		}
		++count;

		s = skip_blanks(s);
		if (*s == ',')
		{
			++s;
			continue;
		}
		if (*s != '-')
			continue;

		s = skip_blanks(++s);
		num2 = get_num(&s);
		if (num2 <= 0 || num2 <= num1 || num2 > max_num)
		{
			if (num2 < 0)
				write_user(user, "Invalid number\n", MSG_FORCED);
			if (num2 <= num1)
				write_user(user, "End of range not greater than start of range\n", MSG_FORCED);
			if (num2 > max_num)
				write_user(user, "Not that many messages\n", MSG_FORCED);
			count = -1;
			break;
		}
		/* num1 was already counted so we don't add 1 */
		count += (num2 - num1);
	}

	return count;
}


/*** Number comparison routine used by delete_messages() ***/
int int_cmp(const void *int1, const void *int2)
{
	int i1 = *((int *)int1);
	int i2 = *((int *)int2);

	if (i1 < i2)
		return -1;
	if (i1 > i2)
		return 1;
	return 0;
}


/*** Delete messages from a named file ***/
/*** Returns number of messages deleted***/
int delete_messages(user, filename, max_cnt, str)
USER_DATA *user;
char *filename;
int max_cnt;
char *str;
{
	int del_count;		/* Number of messages to be deleted */
	int line;			/* Number of current message */
	int *list;			/* Points to array of message numbers */
	int index;			/* Index into the list array */
	int num1, num2;		/* Start and end of message range */
	char tmp_name[13];	/* Name of the temporary file */
	FILE *fp, *tfp;
	char *s;

	if (strcmp(str, "all") == 0)
	{	/* Truncate the file (in case its a symbolic link) */
		fp = fopen(filename, "w");
		if (fp != NULL)
			fclose(fp);
		return max_cnt;
	}

	/* Check the list of message numbers */
	del_count = check_list(user, max_cnt, str);
	if (del_count <= 0)
		return 0;

	/* Allocate array to hold list of messages to be deleted */
	list = (int *)malloc(del_count * sizeof(int));
	if (list == NULL)
	{
		write_user(user, "Sorry - not enough memory to delete messages\n", MSG_FORCED);
		sprintf(mess, "ERROR: Not enough memory to delete messages from %s\n", filename);
		write_syslog(mess, LOG_ERROR, 1);
		return 0;
	}

	/* Fill array with numbers stating messages to be deleted */
	index = 0;
	s = str;
	while (*s)
	{
		s = skip_blanks(s);
		num1 = get_num(&s);
		list[index++] = num1++;	/* num1++ just in case a range is requested */

		s = skip_blanks(s);
		if (*s == ',')
		{
			++s;
			continue;
		}
		if (*s != '-')
			continue;

		s = skip_blanks(++s);
		num2 = get_num(&s);
		while (num1 <= num2)
			list[index++] = num1++;
	}

	/* Check highest message number to see if its valid */
	if (index < 1)
	{
		sprintf(mess, "No messages deleted - missing or invalid numbers\n");
		write_user(user, mess, MSG_FORCED);
		free(list);
		return 0;
	}

	/* Sort the array */
	if (del_count > 1)
		qsort(list, del_count, sizeof(int), int_cmp);

	/* Check highest message number to see if its valid */
	if (list[index-1] > max_cnt)
	{
		sprintf(mess, "No messages were deleted as there are only %d messages\n",
				max_cnt);
		write_user(user, mess, MSG_FORCED);
		free(list);
		return 0;
	}

	/* Need to eliminate duplicate entries (if any) in list[] */
	line = 1;	/* Start checking against entry after list[index] */
	for (index = 0; index < del_count - 1; ++index)
	{
		if (list[index] != list[index + line])
			continue;

		while (index + line < del_count - 1)
		{
			if (list[index] == list[index + line])
				++line;		/* A duplicate. Point to next entry */
		}
		--line;		/* Now contains number of duplicates (Started at 1) */

		if (line > 0)	/* Were any duplicate entries found? */
		{
			/* num1 will hold number of entries remaining in list[] past duplicates */
			/* (index + line + 1) is offset to first entry past last duplicate		*/
			num1 = del_count - (index + line + 1);
			if (num1 > 0)	/* Any remaining entries in list[] to be moved? */
				memcpy(&list[index + 1], &list[index + line + 1], num1 * sizeof(int));
			del_count -= line;		/* Update number of entries remaining in list[] */
		}

		line = 1;	/* Continue checking against entry after list[index] */
	}

	if (tmpnam(tmp_name) == NULL)
	{
		write_user(user, "Sorry - Couldn't create name for temporary file", MSG_FORCED);
		write_syslog("ERROR: Couldn't create name for temporary file in delete_messages()\n", LOG_ERROR, 1);
		free(list);
		return 0;
	}

	/* Now we are ready to open the files */
	if ((fp = fopen(filename, "r")) == NULL)
	{
		free(list);
		return 0;
	}

	if ((tfp = fopen(tmp_name, "w")) == NULL)
	{
		write_user(user, "Sorry - Couldn't open temporary file", MSG_FORCED);
		write_syslog("ERROR: Couldn't open temporary file in delete_messages()\n", LOG_ERROR, 1);
		fclose(fp);
		free(list);
		return 0;
	}

	/* Copy messages to temporary file */
	index = 0;		/* Offset into list of message numbers */
	line = 0;		/* Number of current message */
	fgets(mess, sizeof(mess), fp);
	while (!feof(fp) && index < del_count)
	{
		++line;						/* Count the line just read */
		if (line == list[index])	/* Is this line being deleted? */
			++index;				/* Point to next message to delete */
		else
			fputs(mess, tfp);		/* Copy message to output file */

		fgets(mess, sizeof(mess), fp);
	}

	/* Copy any remaining message lines */
	if (!feof(fp))
	{
		/* mess already has a message to be copied to the output file */
		while (!feof(fp))
		{
			fputs(mess, tfp);
			fgets(mess, sizeof(mess), fp);
		}
	}

	free(list);		/* We don't need the list of message numbers anymore */

	/* Close all files and replace original file with the new file.	*/
	/* Don't delete file before rename is successful. ~~~~~			*/
	fclose(fp);
	fclose(tfp);

	if (file_copy(tmp_name, filename) == -1)
	{
		write_user(user, "Sorry - error copying temp file", MSG_FORCED);
		write_syslog("ERROR: Couldn't copy temp file in delete_messages()\n", LOG_ERROR, 1);
		del_count = 0;
	}
	unlink(tmp_name);

	return del_count;
}


/*** Say user speech ***/
void say_speech(user)
USER_DATA *user;
{
	char type[10];
	AREA_DATA *area;

	if (user->stun)
	{
		write_user(user, "You can't talk while you are stunned\n", MSG_FORCED);
		return;
	}
	switch (inpstr[strlen(inpstr) - 1])
	{
	case '?':
		strcpy(type, "ask");
		break;
	case '!':
		strcpy(type, "exclaim");
		break;
	default:
		strcpy(type, "say");
		break;
	}
	sprintf(mess, "You %s: %s\n", type, inpstr);
	write_user(user, mess, MSG_FORCED);
	if (user->vis)
		sprintf(mess, "%s %ss: %s\n", user->name, type, inpstr);
	else
		sprintf(mess, "A ghostly voice %ss: %s\n", type, inpstr);
	area = user->area;
	write_alluser(user, mess, area, 0, MSG_TALK);
	record_say(area, mess);
}


/*** Copy a file ***/
int file_copy(char *source, char *dest)
{
	FILE *fp_in, *fp_out;
	int cnt, done;

	fp_in = fopen(source, "r");
	if (fp_in == NULL)
		return -1;

	fp_out = fopen(dest, "w");
	if (fp_out == NULL)
		return -1;

	done = 0;
	do {
		cnt = fread(mess, 1, sizeof(mess), fp_in);
		if (cnt < sizeof(mess))
			done = 1;		/* Last block of data to copy */
		if (cnt > 0)
			if (cnt != fwrite(mess, 1, cnt, fp_out))
				done = -1;	/* Error while writing data */
	} while (done == 0);

	fclose(fp_out);
	fclose(fp_in);

	if (done >= 0)
		done = 0;

	return done;
}


/**************************** COMMAND FUNCTIONS ******************************/

/*** Call a function to execute command (if user is allowed) ***/
void exec_com(void)
{
	static char *bad_cmd = "Sorry. I don't know that command.\n";

#if	LOG_CMD
	{
	char stuff[ARR_SIZE];

		sprintf(stuff, "%s: '%s'\n", this_user->name, inpstr);
		write_syslog(stuff, "cmds.log", 1);
	}
#endif

	/* When arrested, a user can only issue the rules command */
	if (this_user->arrested && strcmp(cmd_info[com_index].string, "rules") != 0)
	{
		write_user(this_user, "You can't do that while you are under arrest.\n", MSG_FORCED);
		return;
	}

	/* see if user is allowed to use the command */
	if (this_user->level < cmd_info[com_index].level)
	{
		write_user(this_user, bad_cmd, MSG_FORCED);
		return;
	}

	inpstr = skip_word(inpstr);	/* get rid of commmand word */

	if (cmd_info[com_index].func != NULL)
		cmd_info[com_index].func();
	else
		write_user(this_user, bad_cmd, MSG_FORCED);

	if (strcmp(cmd_info[com_index].string, "quit") == 0)
		this_user->noprompt = 1;
}


/*** gets number of verb entered ***/
int get_verb_response(char *verb)
{
	int index;

	index = 0;
	while (verb_info[index].verb != NULL)
	{
		if (strcmp(verb, verb_info[index].verb) == 0)
			return index;
		++index;
	}
	return -1;
}


/*** Handle verb style commands ***/
void do_verb(void)
{
	char name[NAME_LEN];
	USER_DATA *user2;
	int i, index;
	char response[ARR_SIZE];
	char *s;

	get_user_name(inpstr, name, sizeof(name));

	index = get_verb_response(cmd_info[com_index].string);
	if (index < 0)
	{
		write_user(this_user, "Hm...You seem to have forgotten how to do that.\n", MSG_FORCED);
		sprintf(mess, "Couldn't find verb %s in verb table\n", cmd_info[com_index].string);
		write_syslog(mess, LOG_ERROR, 1);
		return;
	}

	s = strchr(verb_info[index].response, '@');	/* Look for @ in response string */

	/* If response has @, another user name is required */
	if (s != NULL && name[0] == '\0')
	{
		sprintf(mess, "You need to give the name of the person you want to %s\n",
				cmd_info[com_index].string);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	if (s == NULL)	/* Is there no @ in response? */
	{	/* If name was given, see if there is another response */
		if (name[0] != '\0')
		{	/* Is next verb line for same verb as current one? */
			if (verb_info[index+1].verb == NULL)
				i = 1;
			else
				i = strcmp(verb_info[index].verb, verb_info[index+1].verb);
			if (i != 0)
			{
				write_user(this_user, "That action does not require another user\n", MSG_FORCED);
				return;
			}

			++index;
		}
	}

	if (name[0] != '\0')
	{
		if ((user2 = find_userdata(this_user, name, 0, 1)) == NULL)
			return;
	}

	/* Build response string for action */
	s = verb_info[index].response;
	i = 0;
	while (*s)
	{
		if (*s != '@')
			response[i++] = *s;
		else
		{
			strcpy(&response[i], user2->name);
			i = strlen(response);
		}

		++s;
	}
	response[i] = '\0';

	sprintf(mess, "%s %s\n", vis_user_name(this_user), response);
	write_alluser(this_user, mess, this_user->area, 1, MSG_FORCED);
}


/*** Log off a user ***/
void c_quit(void)
{
#if	HONOUR_TELNET
	/* Mark this user for deletion only. We can't delete it yet	*/
	/* as the telnet code is not finished with the tnstat part	*/
	/* of the users data structure.								*/
	this_user->disconnect = 1;
#else
	user_quit(this_user);
#endif
}


/*** Display information about currently logged in users ***/
#if	PORT_WHO
void who_cmd(USER_DATA *user, int people, long portnum)
#else
void who_cmd(USER_DATA *user, int people)
#endif
{
	time_t tm;

	/* display current time */
	time(&tm);
	sprintf(mess, "\n*** Current users as of %.24s ***\n\n", ctime(&tm));
	write_user(user, mess, MSG_FORCED);

	/* display information on all users */
#if	PORT_WHO
	if (portnum != 0)
		list_users(user, -portnum, NULL);
	else
		list_users(user, people, NULL);
#else
	list_users(user, people, NULL);
#endif
}


/*** Show a list of who is currently logged in ***/
void c_who(void)
{
#if	!PORT_WHO
	who_cmd(this_user, 0);
#else
	long portnum;

	if (inpstr[0] == '\0')
	{
		who_cmd(this_user, 0, 0);
		return;
	}

	portnum = atol(inpstr);
	if (portnum < MIN_PORT || portnum > MAX_PORT)
	{
		write_user(this_user, "Sorry, that is not a valid port number\n", MSG_FORCED);
		return;
	}

	who_cmd(this_user, 0, portnum);
#endif
}


/*** shout sends speech to all users regardless of area ***/
void c_shout(void)
{
Node *node;
AREA_DATA *area;

	if (!inpstr[0])
	{
		write_user(this_user, "Shout what?\n", MSG_FORCED);
		return;
	}
	if (this_user->muzzled || this_user->gagged)
	{
		write_user(this_user, "You can't do that at the moment.\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "You shout: %s\n", inpstr);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "%s shouts: %s\n", vis_user_name(this_user), inpstr);
	write_alluser(this_user, mess, NULL, 0, MSG_SHOUT);

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		record_say(area, mess);
	}
}


/*** tells another user something without anyone else hearing ***/
void c_tell(void)
{
	char other_user[NAME_LEN], *name;
	USER_DATA *user2;
	int i;

	get_user_name(inpstr, other_user, sizeof(other_user));
	inpstr = skip_word(inpstr);
	if (other_user[0] == '\0' || inpstr[0] == '\0')
	{
		write_user(this_user, "Usage: .tell <user> <message>\n", MSG_FORCED);
		return;
	}
	if (this_user->gagged)
	{
		write_user(this_user, "You can't do that at the moment.\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Talking to yourself is the first sign of madness\n", MSG_FORCED);
		return;
	}

	if ( (user2->which_msgs & MSG_TELL) == 0)
	{
		sprintf(mess, "%s is ignoring tells^\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
	}
	if (user2->afk)
	{
		sprintf(mess, "^%s is AFK^\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
	}
	name = vis_user_name(this_user);

	switch (inpstr[strlen(inpstr) - 1])
	{
	case '?':
		i = 0;
		break;
	case '!':
		i = 1;
		break;
	default:
		i = 2;
		break;
	}
	sprintf(mess, "^You %s %s:^ %s\n", tell_type1[i], user2->name, inpstr);
	write_user(this_user, mess, MSG_FORCED);
	record_tell(this_user, mess);

	/* If user2 is ignoring this user, don't send the tell */
	if (get_ignore(user2, this_user))
	{
		if (show_user_ign)
		{
			sprintf(mess, "%s is ignoring you!^\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
		}
	}
	else
	{
		sprintf(mess, "^-> %s %s %s:^ %s\n",
				name, tell_type2[i], vis_user_name(user2), inpstr);
		write_user(user2, mess, MSG_TELL);
		record_tell(user2, mess);
	}
	if (show_whispers)
	{
		if (this_user->area == user2->area)
		{
			sprintf(mess, "%s whispers something to %s\n",
					name, vis_user_name(user2));
			write_alluser(this_user, mess, this_user->area, 0, MSG_TELL);
		}
	}
}


/*** get ignore info - ie: is user1 ignoring user2? ***/
int get_ignore(USER_DATA* user1, USER_DATA *user2)
{
	return user1->ignore[user2->user_id / CHAR_BIT] & (1 << (user2->user_id % CHAR_BIT));
}


/*** .ignore/.listen user username ***/
void listen_user(USER_DATA *user, char *name, int flag)
{
	static char *state_msg[] = { "ignore", "listen to" };
	USER_DATA *u;
	int set, id;

	if (name[0] == '\0')
	{
		write_user(user, "You need to give me a name first\n", MSG_FORCED);
		return;
	}
	if ((u = find_userdata(user, name, 0, 1)) == NULL)
		return;
	if (u == user)
	{
		write_user(user, "You always have to pay attention to yourself!\n", MSG_FORCED);
		return;
	}
	set = get_ignore(user, u);
	if ( (set && !flag) || (!set && flag) )
	{
		sprintf(mess, "You are already %s %s\n", state_msg[flag], u->name);
		write_user(user, mess, MSG_FORCED);
		return;
	}
	if (!flag && u->level > user->level)
	{
		write_user(user, "You can't do that\n", MSG_FORCED);
		return;
	}
	id = u->user_id;
	user->ignore[ id / CHAR_BIT ] ^= (1 << (id % CHAR_BIT));
	sprintf(mess, "You %s %s\n", state_msg[flag], u->name);
	write_user(user, mess, MSG_FORCED);
}


/*** listen to or ignore certain types of messages */
void listen_cmd(user, flag)
USER_DATA *user;
int flag;
{
	static char *state_msg[] = { "ignore", "listen to" };
	char msg_type[NAME_LEN];
	int i, len, mask;

	if (!inpstr[0])
	{
		if (user->level < MAGICAL)
		{
			sprintf(mess, "Usage: .%s all/atmos/echo/logon/shout/system/talk/tell\n",
					cmd_info[com_index].string);
		}
		else
		{
			sprintf(mess, "Usage: .%s all/atmos/bcast/echo/logon/shout/system/talk/tell/wtell\n",
					cmd_info[com_index].string);
		}
		write_user(user, mess, MSG_FORCED);
		sprintf(mess, "       .%s user <name>\n", cmd_info[com_index].string);
		write_user(user, mess, MSG_FORCED);
		return;
	}

	get_word(inpstr, msg_type, sizeof(msg_type));
	len = strlen(msg_type);
	if (strncmp(msg_type, "user", len) == 0)
	{
		inpstr = skip_word(inpstr);
		get_user_name(inpstr, msg_type, sizeof(msg_type));
		listen_user(user, msg_type, flag);
		return;
	}

	/* We want to ignore any final 's' that may be on word from user */
	if (len > 1 && msg_type[len - 1] == 's')
		msg_type[--len] = '\0';
	for (i = 0; listen_cmd_info[i].word != NULL; ++i)
	{
		if (user->level >= listen_cmd_info[i].level)
		{
			if (strncmp(msg_type, listen_cmd_info[i].word, len) == 0)
				break;
		}
	}

	if (listen_cmd_info[i].word == NULL)
	{
		write_user(user, "Huh? You want to do what?\n", MSG_FORCED);
		return;
	}

	if (listen_cmd_info[i].mask != MSG_ALL)
		mask = listen_cmd_info[i].mask;
	else
	{
		if (user->level < MAGICAL)
			mask = (MSG_ALL & ~MSG_BCAST);	/* Users can't ignore broadcasts */
		else
			mask = MSG_WALL;
	}
	if (flag)
		user->which_msgs |= mask;		/* Set the state of the bit(s) */
	else
	{
		user->which_msgs &= ~mask;		/* Clear the state of the bit(s) */
		user->which_msgs |= MSG_FORCED;	/* In case mask is MSG_ALL or MSG_WALL */
	}

	sprintf(mess, "You %s %s messages\n", state_msg[flag], listen_cmd_info[i].word);
	write_user(user, mess, MSG_FORCED);

	if (show_ignores)
	{
		sprintf(mess, "%s will now %s %s messages\n",
				vis_user_name(user), state_msg[flag], listen_cmd_info[i].word);
		write_alluser(user, mess, user->area, 0, MSG_SYSTEM);
	}
}


/*** listen to messages of a certain type or from a particular user ***/
void c_listen(void)
{
	listen_cmd(this_user, 1);
}


/*** ignore messages of a certain type or from a particular user ***/
void c_ignore(void)
{
	listen_cmd(this_user, 0);
}


/*** look describes the surrounding scene **/
void look_cmd(USER_DATA *user)
{
	char filename[80];
	AREA_DATA *area, *linked_area;
	Node *node;

	area = user->area;
	sprintf(mess, "\nArea: %s (%s)\n", area->name, areas_status[area->status]);
	write_user(user, mess, MSG_FORCED);

/* open and read area description file */
	sprintf(filename, "%s/%s", ROOMINFODIR, area->name);
	(void)more(user, filename);

/* show exits from area if area is linked to other than itself */
	if (NodeHead(area->move) == (Node *)area->move)
		write_user(user, "There appears to be no way out of here.", MSG_FORCED);
	else
	{
		write_user(user, "Exits go to:", MSG_FORCED);

		node = NodeHead(area->move);
		while (!isEndOfList(area->move, node))
		{
			linked_area = (AREA_DATA *)NodeData(node);
			node = NodeNext(node);

			sprintf(mess, " %s", linked_area->name);
			write_user(user, mess, MSG_FORCED);
		}
	}
	write_user(user, "\n", MSG_FORCED);
	list_users(user, 0, area);	/* Display people in same area */

	if (area->linked)
	{
		sprintf(filename, "%s/%s", MESSDIR, area->name);
		area->mess_num = messcount(filename);
	}
	sprintf(mess, "There are %d messages on the board\n", area->mess_num);
	write_user(user, mess, MSG_FORCED);
	if (!strlen(area->topic))
		write_user(user, "There is no current topic here\n", MSG_FORCED);
	else
	{
		sprintf(mess, "Current topic: %s\n\n", area->topic);
		write_user(user, mess, MSG_FORCED);
	}
}


/*** look describes the surrounding scene **/
void c_look(void)
{
	look_cmd(this_user);
}


/*** Search a linked list of areas for a specific area ***/
AREA_DATA *find_area_by_name(USER_DATA *user, char *name, int exact)
{
	List *list;
	Node *node;
	AREA_DATA *area;
	int len;

	strtolower(name);
	len = strlen(name);
	list = user->area->move;

	/* Look for matching area connected to users current location */
	node = NodeHead(list);
	while (!isEndOfList(list, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (exact)
		{
			if (strcmp(name, area->name) == 0)
				return(area);
		}
		else
		{
			if (strncmp(name, area->name, len) == 0)
				return(area);
		}
	}

	/* Couldn't find matching area connected to users location	*/
	/* so lets see if there is another area somewhere that is	*/
	/* not connected to the current area which matches.			*/
	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (exact)
		{
			if (strcmp(name, area->name) == 0)
				return(area);
		}
		else
		{
			if (strncmp(name, area->name, len) == 0)
				return(area);
		}
	}

	return NULL;
}


/*** Returns 1 if user can get to the named area from their ***/
/*** current area or 0 if they can't. The new_area argument ***/
/*** is set to the pointer to the specified area. If area   ***/
/*** is not directly connected to the users current area 	***/
/*** the teleport argument will be set to 1.				***/
/*** Note: Messages go to user issuing the command.			***/
int is_area_reachable(USER_DATA *user, char *area_name, AREA_DATA **new_area, int *teleport)
{
	Node *node;
	AREA_DATA *area;		/* Where user being moved is currently located */
	AREA_DATA *nearby_area;	/* Pointer to area connected to one user is in */
	AREA_DATA *found_area;
	int i;

/* see if area exists */
	i = strlen(area_name);

	found_area = find_area_by_name(user, area_name, 0);
	if (found_area == NULL)
	{
		write_user(this_user, "There is no such area\n", MSG_FORCED);
		return 0;
	}

	if (user->area == found_area)
	{
		if (user == this_user)
			write_user(this_user, "Having trouble with your eyes? You are in that area now!\n", MSG_FORCED);
		else
		{
			sprintf(mess, "%s is in that area now!\n", user->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		return 0;
	}

	*new_area = found_area;
	*teleport = 0;	/* Assume area is directly connected */

	area = user->area;
	node = NodeHead(area->move);
	while (!isEndOfList(area->move, node))
	{
		nearby_area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (nearby_area == found_area)
			return 1;
	}

	*teleport = 1;	/* Room is not directly connected */

	/* Is user magical or is user being moved by magical user? */
	if (user->level >= MAGICAL ||
		(user != this_user && this_user->level >= MAGICAL))
	{
		return 1;
	}

	write_user(this_user, "You can't get there from here\n", MSG_FORCED);
	return 0;
}


/*** go moves user into different area ***/
void go_cmd(USER_DATA *user, AREA_DATA *new_area, int teleport)
{
	char *name;
	char entmess[30];

	if (user->level < MAGICAL)
	{
		if (new_area->wiz_only)
		{
			sprintf(mess, "Sorry. That area is for wizards and up only.\n");
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

#if	0
		if (!user->arrested && new_area == jail && jail != NULL)
		{
			if (this_user == user)
				sprintf(mess, "Sorry. You can't go to the %s right now\n",
						new_area->name);
			else
				sprintf(mess, "Sorry. %s can't go to the %s right now\n",
						user->name, new_area->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
#endif
	}

	if (new_area->status == AREA_STATUS_PRIVATE && user->invite != new_area)
	{	/* Show error message to user issuing the command */
		write_user(this_user, "Sorry - that area is currently private\n", MSG_FORCED);
		return;
	}

/* send output to old area */
	if (teleport && user != this_user)
		write_user(user, "\nA force grabs you and pulls you through the ether!!\n", MSG_FORCED);

	name = vis_user_name(user);

	if (!user->vis)
	{
		if (user == this_user)	/* Is the user moving themself? */
		{
			if (user->level >= MAGICAL && user->level != SU)
				write_alluser(user, "Some magic disturbs the air\n", user->area, 0, MSG_SYSTEM);
		}
		else
		{
			/* Wizards and above show exit message except for SUs who don't */
			sprintf(mess, "%s is pulled into the great beyond!\n", name);
			write_alluser(user, mess, user->area, 0, MSG_SYSTEM);
		}
	}
	else
	{
		if (teleport)
			sprintf(mess, "%s disappears in a puff of magic!\n", user->name);
		else
			sprintf(mess, "%s goes to the %s\n", user->name, new_area->name);
		write_alluser(user, mess, user->area, 0, MSG_SYSTEM);
	}
	check_area_status(user, user->area);

/* send output to new area */
	user->area = new_area;

	if (!user->vis)
	{
		/* Levels above USER show an entry message except for SUs who don't */
		if (user->level >= MAGICAL && user->level != SU)
			write_alluser(user, "Some magic disturbs the air\n", new_area, 0, MSG_SYSTEM);
	}
	else
	{
		if (user != this_user)	/* Is someone else moving the user? */
			sprintf(mess, "%s appears from nowhere!\n", name);
		else
		{
			if (!teleport)
				strcpy(entmess, "walks in");
			else
				strcpy(entmess, "arrives in a blinding flash!");
			sprintf(mess, "%s %s!\n", name, entmess);
		}
		write_alluser(user, mess, new_area, 0, MSG_SYSTEM);
	}

/* The user has been moved */
	if (user->invite == new_area)
		user->invite = NULL;
	look_cmd(user);
}


/*** A user wants to move to a different area ***/
void c_go(void)
{
	char area_name[AREA_NAME_LEN];
	AREA_DATA *new_area;
	int teleport;

#if	GO_CMD_DEFAULT
	if (inpstr[0] == '\0')
	{
		new_area = (AREA_DATA *)NodeData( NodeHead(astr) );
		strcpy(area_name, new_area->name);
	}
	else
	{
		/* If GO_CMD_DEFAULT is defined, only the next statement */
		/* is executed as part of the else clause resulting in a */
		/* check to see if the area is connected to users area.  */
		get_word(inpstr, area_name, sizeof(area_name));
	}
#else
	if (inpstr[0] == '\0')
	{
		write_user(this_user, "Usage: .go <area>\n", MSG_FORCED);
		return;
	}

	get_word(inpstr, area_name, sizeof(area_name));
#endif

	if ( !is_area_reachable(this_user, area_name, &new_area, &teleport) )
		return;
	go_cmd(this_user, new_area, teleport);
}


/*** User asks for permission to enter area marked private ***/
void c_knock(void)
{
	char area_name[AREA_NAME_LEN];
	AREA_DATA *new_area;
	int teleport;
	char *name;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .knock <area>\n", MSG_FORCED);
		return;
	}

	get_word(inpstr, area_name, sizeof(area_name));
	if ( !is_area_reachable(this_user, area_name, &new_area, &teleport) )
		return;

	if (new_area->status < AREA_STATUS_PRIVATE)
	{
		write_user(this_user, "That area is public\n", MSG_FORCED);
		return;
	}

	sprintf(mess, "You knock on the %s door.\n", new_area->name);
	write_user(this_user, mess, MSG_FORCED);

	name = vis_user_name(this_user);

	sprintf(mess, "%s is knocking on the door.\n", name);
	write_alluser(this_user, mess, new_area, 0, MSG_SYSTEM);

/* send message to users in current area */
	sprintf(mess, "%s knocks on the %s door.\n", name, new_area->name);
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);
}


/*** area_access sets area to private or public ***/
void area_access(user, priv)
USER_DATA *user;
int priv;
{
	static char *noset = "The status of this area can't be changed\n";
	AREA_DATA *area;
	char *name;

	area = user->area;

/* see if areas access can be set */
	if (area->status == AREA_STATUS_FIXED)
	{
		write_user(user, noset, MSG_FORCED);
		return;
	}

/* see if access already set to user request */
	if (priv == (area->status == AREA_STATUS_PRIVATE))
	{
		sprintf(mess, "The area is already %s!\n", areas_status[ area->status ]);
		write_user(user, mess, MSG_FORCED);
		return;
	}

	name = vis_user_name(user);

/* set to public */
	if (!priv)
	{
		write_user(user, "Area now set to public\n", MSG_FORCED);
		sprintf(mess, "%s has set the area to public\n", name);
		write_alluser(user, mess, area, 0, MSG_SYSTEM);
		area->status = AREA_STATUS_PUBLIC;
		cbuff(area);
		return;
	}

/* need at least PRINUM users to make area private unless user level >= MAGICAL */
	if (find_num_in_area(area) < PRINUM && user->level < MAGICAL)
	{
		sprintf(mess, "You need at least %d people before you can make an area private\n", PRINUM);
		write_user(user, mess, MSG_FORCED);
		return;
	};
	write_user(user, "Area now set to private\n", MSG_FORCED);
	sprintf(mess, "%s has set the area to private\n", name);
	write_alluser(user, mess, area, 0, MSG_SYSTEM);
	area->status = AREA_STATUS_PRIVATE;
}


/*** Make an area private so no one else can enter ***/
void c_private(void)
{
	area_access(this_user, 1);
}


/*** Make an area public so any one can enter ***/
void c_public(void)
{
	area_access(this_user, 0);
}


/*** invite someone into private area ***/
void c_invite_user(void)
{
	USER_DATA *u;
	AREA_DATA *area;
	char other_user[NAME_LEN];
	char *name;

	area = this_user->area;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .invite <user>\n", MSG_FORCED);
		return;
	}
	if (area->status < AREA_STATUS_PRIVATE)
	{
		write_user(this_user, "Invitations are not required for public areas\n", MSG_FORCED);
		return;
	}
	get_user_name(inpstr, other_user, sizeof(other_user));

/* see if other user exists */
	if ((u = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;

	if (this_user == u)
	{
		write_user(this_user, "Inviting yourself won't help cure your feeling of loneliness.\n", MSG_FORCED);
		return;
	}
	if (u->area == this_user->area)
	{
		sprintf(mess, "%s is already here, silly!\n", u->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	name = vis_user_name(this_user);
	sprintf(mess, "%s has been invited to join %s\n", u->name, name);
	write_alluser(this_user, mess, u->area, 0, MSG_SYSTEM);
	sprintf(mess, "%s has invited you to the %s\n", name, area->name);
	write_user(u, mess, MSG_SYSTEM);
	sprintf(mess, "You have invited %s to join you\n", u->name);
	write_user(this_user, mess, MSG_FORCED);
	u->invite = area;
}


/*** emote func used for expressing emotional or visual stuff ***/
void c_emote(void)
{
	char *name;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .emote <text>\n", MSG_FORCED);
		return;
	}
	name = vis_user_name(this_user);
	if (inpstr[0] == '\'')
		sprintf(mess, "%s%s\n", name, inpstr);
	else
		sprintf(mess, "%s %s\n", name, inpstr);

/* write & record output */
	write_alluser(this_user, mess, this_user->area, 1, MSG_TALK);
	record_say(this_user->area, mess);
}


/*** Delete an area ***/
void delete_named_area(char *s)
{
AREA_DATA *area, *area_to_delete;
Node *area_node;
List *link_info;
Node *link_node;
Node *next_link;
char word[AREA_NAME_LEN];

	if (num_areas < 2)
	{
		sprintf(mess, "You can't delete that area as it is the only one left!\n");
		write_user(this_user, mess, MSG_FORCED);
	}

	get_word(s, word, sizeof(word));

	/* Get a pointer to area data node by its label. */
	area_to_delete = find_area_by_name(this_user, word, 1);
	if (area_to_delete == NULL)
	{
		sprintf(mess, "Can't find exact match for area with name '%s'\n",
				word);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	/* Don't delete an area which contains users */
	if (find_num_in_area(area_to_delete) > 0)
	{
		sprintf(mess, "Can't delete area '%s' until it is empty of users\n",
				area_to_delete->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	/* Remove all links to this area. */
	/* Remember: each area has only a */
	/* single link to any given area. */
	area_node = NodeHead(astr);
	while (!isEndOfList(astr, area_node))
	{
		area = (AREA_DATA *)NodeData(area_node);
		if (area != area_to_delete)
		{
			link_info = area->move;
			link_node = NodeHead(link_info);
			while (!isEndOfList(link_info, link_node))
			{
				next_link = NodeNext(link_node);

				if ((AREA_DATA *)NodeData(link_node) == area_to_delete)
				{
					(void)NodeRemove(link_node);
					NodeDestroy(link_node);
					break;	/* Found only link to area */
				}

				link_node = next_link;
			}
		}

		area_node = NodeNext(area_node);
	}

	/* And finally remove the area */
	area_node = NodeFind(astr, area_to_delete);
	(void)NodeRemove(area_node);
	--num_areas;

	ListDestroy(area_to_delete->echos);
	ListDestroy(area_to_delete->conv);
	delete_area_links(area_to_delete->move);
	free(area_to_delete->move);
	NodeDestroy(area_node);

#if	DEL_AREA_FILES
	/* Delete areas description and message board */
	sprintf(mess, "%s/%s", ROOMINFODIR, area->name);
	unlink(mess);
	sprintf(mess, "%s/%s", MESSDIR, area->name);
	unlink(mess);
#endif

	sprintf(mess, "Area '%s' has been removed\n", word);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "%s DELETED area %s\n", this_user->name, word);
	write_syslog(mess, LOG_AREAS, 1);
}


/*** Create or edit the description for an area ***/
void describe_area(AREA_DATA *area)
{
	sprintf(mess, "%s is entering an area description...\n", vis_user_name(this_user));
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);

	sprintf(mess, "\n** Entering description for area %s **\n", area->name);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(this_user->users_file, "%s/%s", ROOMINFODIR, area->name);
	this_user->edit_max = 0;
	edit_file();
}


/*** Gives current status of areas ***/
void enhanced_areas_command()
{
	static char *area_cmds[] = { "topic", "info", "add", "modify", "describe", "delete", NULL };
	static char *modify_options[] = { "status", "searchable", "links", NULL };
	char word[AREA_NAME_LEN], *s;
	int old_status;
	int old_wiz_only;
	int old_searchable;
	AREA_DATA *area, *old_jail;
	List *links, *old_links;
	Node *area_node;
	int i;

	get_word(inpstr, word, sizeof(word));
	s = skip_word(inpstr);

	i = choose(word, area_cmds);
	if ((i == -1 && word[0] != '\0') ||
		(i > 1 && *s == '\0'))
	{
		write_user(this_user, "Usage: .areas\n", MSG_FORCED);
		write_user(this_user, "       See .help for additional options\n", MSG_FORCED);
		return;
	}

	/* Make sure person is allowed to modify area information */
	/* If they are only setting the area topic, that is ok.   */
	if (this_user->level < AREA_MODIFY_LEVEL ||
		(this_user->level < MAGICAL && i > 0))
	{
		write_user(this_user, "You can not modify the area information\n", MSG_FORCED);
		return;
	}

	switch (i)
	{
	case 0:	/* topic */
		get_word(s, word, sizeof(word));	/* Get area name */
		s = skip_word(s);
		strtolower(word);
		area = find_area_by_name(this_user, word, 1);
		if (area == NULL)
		{
			sprintf(mess, "Can't find exact match for area '%s'.\n", word);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		get_string(inpstr, area->topic, TOPIC_LEN);
		break;

	case 1:	/* info */
		page_user_output(this_user, NULL, PGOUT_NEW);
		page_user_output(this_user, "Link   Area name        Status       Searchable\n\n", PGOUT_ADD);

		area_node = NodeHead(astr);
		while (!isEndOfList(astr, area_node))
		{
			area = (AREA_DATA *)NodeData(area_node);
			area_node = NodeNext(area_node);

			if (area == jail)
				i = AREA_STATUS_JAIL;
			else
			{
				i = area->status;
				if (area->wiz_only)
					i += AREA_STATUS_WIZ_FIXED;
			}
			sprintf(mess, "%-*s  %-*s %-*s  %-3s\n",
					AREA_LABEL_LEN, area->label,
					AREA_NAME_LEN, area->name,
					AREA_STATUS_LEN, areas_status[i],
					yesno[area->searchable]);
			page_user_output(this_user, mess, PGOUT_ADD);
		}
		page_user_output(this_user, NULL, PGOUT_DONE);
		break;
	case 2:	/* add */
		if (parse_areas_section(this_user, s) == 0)
		{
			area = (AREA_DATA *)NodeData( NodeTail(astr) );
			if (convert_area_link_info(this_user, area->name, area->move) == 0)
			{
				sprintf(mess, "Area %s has been added\n", area->name);
				write_user(this_user, mess, MSG_FORCED);
				describe_area(area);
				sprintf(mess, "%s ADDED area %s\n", this_user->name, area->name);
				write_syslog(mess, LOG_AREAS, 1);
			}
		}
		break;
	case 3:	/* modify */
		strtolower(s);
		get_word(s, word, sizeof(word));	/* Get area name */
		s = skip_word(s);
		area = find_area_by_name(this_user, word, 1);
		if (area == NULL)
		{
			sprintf(mess, "Can't find exact match for area '%s'.\n", word);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		get_word(s, word, sizeof(word));	/* Get modify command */
		s = skip_word(s);

		i = choose(word, modify_options);
		switch (i)
		{
		case 0:	/* status */
			old_status = area->status;
			old_wiz_only = area->wiz_only;
			old_searchable = area->searchable;
			old_jail = jail;
			if (process_area_status(this_user, area, s) == 0)
			{
				if (area == old_jail)
				{
					jail = NULL;
					sprintf(mess, "You need a new area for the jail as %s was the jail.\n",
							old_jail->name);
					write_user(this_user, mess, MSG_FORCED);
				}
				sprintf(mess, "Status of area %s has been changed.\n", area->name);
				write_user(this_user, mess, MSG_FORCED);
			}
			else
			{
				area->status = old_status;
				area->wiz_only = old_wiz_only;
				area->searchable = old_searchable;
				jail = old_jail;

				sprintf(mess, "Status of area %s left unchanged.\n", area->name);
				write_user(this_user, mess, MSG_FORCED);
			}
			break;
		case 1: /* search */
			if (process_area_flags(this_user, area, s) == 0)
				sprintf(mess, "Searchable status of area %s has been changed.\n", area->name);
			else
				sprintf(mess, "Searchable status of area %s left unchanged.\n", area->name);
			write_user(this_user, mess, MSG_FORCED);
			break;
		case 2: /* links */
			links = ListCreate();
			old_links = area->move;
			area->move = links;
			strtolower(s);
			i = parse_area_linkages(this_user, area, s);
			if (i == 0)
			{
				if (convert_area_link_info(this_user, area->name, area->move) != 0)
				{
					area->move = old_links;
					i = 1;
				}
			}
		
			if (i == 0)
			{
				delete_area_links(old_links);
				free(old_links);
				sprintf(mess, "Links from area %s have been changed.\n", area->name);
			}
			else
			{
				area->move = old_links;
				delete_area_links(links);
				free(links);
				sprintf(mess, "Links from area %s have not been changed.\n", area->name);
			}
			write_user(this_user, mess, MSG_FORCED);
			break;
		default:
			sprintf(mess, "Unknown modify option '%s'. See .help for usage information\n", word);
			write_user(this_user, mess, MSG_FORCED);
			break;
		}

		if (i >= 0)
		{
			sprintf(mess, "%s MODIFIED %s for area %s\n",
					this_user->name, modify_options[i], area->name);
			write_syslog(mess, LOG_AREAS, 1);
		}
		break;
	case 4:	/* describe */
		get_word(s, word, sizeof(word));	/* Get area name */
		s = skip_word(s);
		strtolower(word);
		area = find_area_by_name(this_user, word, 1);
		if (area == NULL)
		{
			sprintf(mess, "Can't find exact match for area with name '%s'.\n", word);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		describe_area(area);
		sprintf(mess, "%s DESCRIBED area %s\n", this_user->name, area->name);
		write_syslog(mess, LOG_AREAS, 1);
		break;
	case 5:	/* delete */
		delete_named_area(s);
		break;
	default:
		sprintf(mess, "Unknown command '%s'. See .help for usage information\n", word);
		write_user(this_user, mess, MSG_FORCED);
		break;
	}
}


/*** Gives current status of areas ***/
void c_areas(void)
{
	char filename[80];
	Node *node;
	AREA_DATA *area;
	int  status;
	char buff[39];

	if (*inpstr != '\0')
	{
		enhanced_areas_command();
		return;
	}

	page_user_output(this_user, NULL, PGOUT_NEW);
	page_user_output(this_user, "\nArea name       Status     Users Msgs  Search     Topic\n\n", PGOUT_ADD);

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (area == jail)
			status = AREA_STATUS_JAIL;
		else
		{
			status = area->status;
			if (area->wiz_only)
				status += AREA_STATUS_WIZ_FIXED;
		}

		if (area->linked)
		{
			sprintf(filename, "%s/%s", MESSDIR, area->name);
			area->mess_num = messcount(filename);
		}
		sprintf(mess, "%-*s %-*s %4d %4d%c %c  ",
				AREA_NAME_LEN-1, area->name,
				AREA_STATUS_LEN, areas_status[status],
				find_num_in_area(area), area->mess_num,
				area->linked ? 'L' : ' ',
				yesno[area->searchable][0]);

		if (area->topic[0] == '\0')
			strcpy(buff, "<no topic>");
		else
		{
			strncpy(buff, area->topic, sizeof(buff)-1);
			buff[sizeof(buff)-1] = '\0';
		}
		strcat(mess, buff);
		strcat(mess, "\n");
		mess[0] = toupper(mess[0]);
		page_user_output(this_user, mess, PGOUT_ADD);
	}

	sprintf(mess, "\nTotal of %d areas\n\n", num_areas);
	page_user_output(this_user, mess, PGOUT_ADD);
	page_user_output(this_user, NULL, PGOUT_DONE);
}


/*** save message to area message board file ***/
void write_board(user, str, permanent)
USER_DATA *user;
char *str;
int permanent;
{
	FILE *fp;
	char filename[80];

/* open board file */
	sprintf(filename, "%s/%s", MESSDIR, user->area->name);
	if ((fp = fopen(filename, "a")) == NULL)
	{
		sprintf(mess, "%s : message can't be written\n", syserror);
		write_user(user, mess, MSG_FORCED);
		sprintf(mess, "ERROR: Couldn't open %s message board file to write in write_board()\n", user->area->name);
		write_syslog(mess, LOG_ERROR, 1);
		return;
	}

/* write message */
	if (!permanent)
		sprintf(mess, "(%s) From %s: %s\n", timeline(0), vis_user_name(user), str);
	else
		sprintf(mess, "[%s] From %s: %s\n", timeline(0), vis_user_name(user), str);
	fputs(mess, fp);
	fclose(fp);

/* send output */
	write_user(user, "You write the message on the board\n", MSG_FORCED);
	if (user->vis)
		sprintf(mess, "%s writes a message on the board\n", user->name);
	else
		sprintf(mess, "A ghostly hand writes a message on the board\n");
	write_alluser(user, mess, user->area, 0, MSG_SYSTEM);
	user->area->mess_num++;
}


/*** save a temporary message to area message board file ***/
void c_write_board(void)
{
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .write <message>\n", MSG_FORCED);
		return;
	}

	write_board(this_user, inpstr, 0);
}


/*** save a "permanent" message to area message board file ***/
void c_etch_board(void)
{
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .etch <message>\n", MSG_FORCED);
		return;
	}

	write_board(this_user, inpstr, 1);
}


/*** read the message board ***/
void c_read_board(void)
{
	char filename[80];
	AREA_DATA *area;
	int i;

	/* Check to see if a message board was specified */
	if (*inpstr == '\0')
		area = this_user->area;
	else
	{
		area = find_area_by_name(this_user, inpstr, 0);
		if (area == NULL)
		{
			sprintf(mess, "Can't find area specified by %s\n", inpstr);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
	}

	/* Can't read message board if area is for wiz only and */
	/* user is not magical user or the message board is not */
	/* searchable and user is not in that area.             */
	if ( ((area == jail || area->wiz_only) && this_user->level < MAGICAL) ||
		(this_user->area != area && !area->searchable))
	{
		write_user(this_user, "Sorry - You can't read that board right now\n", MSG_FORCED);
		return;
	}

	sprintf(filename, "%s/%s", MESSDIR, area->name);
	sprintf(mess, "\n*** The %s message board ***\n", area->name);
	mess[9] = toupper(mess[9]);
	write_user(this_user, mess, MSG_FORCED);

	if (this_user->level >= MAGICAL)
		this_user->show_nums = 1;

	/* Don't change these three lines. This handles the remote chance */
	/* a read board command is issued just as the daily message board */
	/* expire begins. If there were messages which the expire function*/
	/* removed, user would never be told that there are no messages.  */
	i = more(this_user, filename);
	if (i == MORE_NO_FILE || !area->mess_num)
		write_user(this_user, "There are no messages on the board\n", MSG_FORCED);

/* let others know user is reading a message board */
	sprintf(mess, "%s reads the %s message board\n",
			vis_user_name(this_user), area->name);
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);
}


/*** wipe board (erase file) ***/
void c_wipe_board(void)
{
	char filename[80];
	int lines;

	if (*inpstr == '\0')
	{
		write_user(this_user, "Usage: .wipe n/n,n/n1-n2/all\n", MSG_FORCED);
		return;
	}

	sprintf(filename, "%s/%s", MESSDIR, this_user->area->name);
	if (this_user->area->linked)
		this_user->area->mess_num = messcount(filename);

	if (this_user->area->mess_num == 0)
	{
		write_user(this_user, "There are no messages on the message board\n", MSG_FORCED);
		return;
	}

	lines = delete_messages(this_user, filename, this_user->area->mess_num, inpstr);

	if (lines > 0)
	{
		this_user->area->mess_num -= lines;

		sprintf(mess, "You wiped %d messages from the board\n", lines);
		write_user(this_user, mess, MSG_FORCED);
		if (this_user->vis)
			sprintf(mess, "%s wipes some messages from the board\n", this_user->name);
		else
			sprintf(mess, "A ghostly hand wipes some messages from the board\n");
		write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);

		sprintf(mess, "%s WIPED %d messages from %s\n", this_user->name, lines, filename);
		write_syslog(mess, LOG_WIPE, 1);
	}
}


/*** get user site from user name ***/
void c_user_site(void)
{
	char other_user[NAME_LEN];
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (other_user[0] == '\0')
	{
		write_user(this_user, "Usage: .site <user>\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;

/* write site */
	sprintf(mess, "The site for %s is %s\n", user2->name, print_site(&user2->site));
	write_user(this_user, mess, MSG_FORCED);
}


/*** sets area topic ***/
void c_topic(void)
{
	if (!inpstr[0])
	{
		if (!strlen(this_user->area->topic))
			write_user(this_user, "There is no current topic here\n", MSG_FORCED);
		else
		{
			sprintf(mess, "Current topic: %s\n", this_user->area->topic);
			write_user(this_user, mess, MSG_FORCED);
		}
		return;
	}
	get_string(inpstr, this_user->area->topic, TOPIC_LEN);

/* send output to users */
	sprintf(mess, "Topic set to %s\n", this_user->area->topic);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "%s has set the topic to %s\n", vis_user_name(this_user), this_user->area->topic);
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);
}


/*** sets user status to visible or invisible ***/
void visible(user, vis)
USER_DATA *user;
int vis;
{
	if (user->vis && vis)
	{
		write_user(user, "You are already visible!\n", MSG_FORCED);
		return;
	}
	if (!user->vis && !vis)
	{
		write_user(user, "You are already invisible!\n", MSG_FORCED);
		return;
	}

	user->vis = vis;
	if (vis)
	{
		write_user(user, "POP! You reappear!\n", MSG_FORCED);
		sprintf(mess, "POP! %s materialises in the area!\n", user->name);
	}
	else
	{
		write_user(user, "You fade, shimmer and vanish...\n", MSG_FORCED);
		sprintf(mess, "%s fades, shimmers, and vanishes!\n", user->name);
	}
	write_alluser(user, mess, user->area, 0, MSG_SYSTEM);
}


/*** Make a user visible ***/
void c_visible(void)
{
	visible(this_user, 1);
}


/*** Make a user invisible ***/
void c_invisible(void)
{
	visible(this_user, 0);
}


/*** Throw off an annoying bastard (or throw off someone for a laugh) ***/
void c_kill_user(void)
{
	char name[NAME_LEN];
	USER_DATA *victim;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .kill <user>\n", MSG_SYSTEM);
		return;
	}
	get_user_name(inpstr, name, sizeof(name));
	if ((victim = find_userdata(this_user, name, 0, 1)) == NULL)
		return;

	strcpy(name, victim->name);	/* Keep a copy of victims name */

	if (victim == this_user)
	{
		write_user(this_user, "Suicide is not an option here no matter how bad things get\n", MSG_SYSTEM);
		return;
	}

/* can't kill SU */
	if (this_user->level <= victim->level)
	{
		write_user(this_user, "That wouldn't be wise...\n", MSG_SYSTEM);
		sprintf(mess, "%s thought about killing you\n", this_user->name);
		write_user(victim, mess, MSG_SYSTEM);
		return;
	}

/* record killing */
	sprintf(mess, "%s KILLED %s\n", this_user->name, victim->name);
	write_syslog(mess, LOG_KILL, 1);

/* kill user */
	sprintf(mess, "A bolt of white lightning streaks from the heavens and blasts %s!!\n", vis_user_name(victim));
	write_alluser(victim, mess, victim->area, 0, MSG_SYSTEM);
	write_user(victim, "A bolt of white lightning streaks from the heavens and blasts you!!\nYou have been removed from this reality...\n", MSG_FORCED);
	user_quit(victim);
	write_alluser(this_user, "There is a rumble of thunder\n", NULL, 1, MSG_SYSTEM);
	sprintf(mess, "You killed %s leaving nothing but ashes.\n", name);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Force quit of all users and shutdown the talker ***/
void do_shutdown(void)
{
	Node *node;
	AREA_DATA *area;
	USER_DATA *user;

	if (shutd == NULL)
		sprintf(mess, "*** Talker SHUTDOWN %s (KILL/TERM signal) ***\n", timeline(1));
	else
		sprintf(mess, "*** Talker SHUTDOWN by %s on %s ***\n", this_user->name, timeline(1));
	write_syslog(mess, LOG_BOOT_FILE, 0);

	if (num_of_users > 0)
	{
		if (shutd != NULL)
			write_user(this_user, "Quitting users...\n", MSG_FORCED);

		node = NodeHead(ulist);
		while (!isEndOfList(ulist, node))
		{
			user = (USER_DATA *)NodeData(node);
			node = NodeNext(node);

			if (user->area == NULL || user == this_user)
				continue;

			write_user(user, "\n*** Talker shutting down ***\n\n", MSG_FORCED);
			user_quit(user);
		}

		if (this_user != NULL)
		{
			if (shutd != NULL)
				write_user(this_user, "Now quitting you...\n\n*** Goodbye from NUTS ***\n", MSG_FORCED);
			user_quit(this_user);
		}
	}

#if	HONOUR_TELNET
	cleanup_telnet();
#endif

/* close listen socket */
	close(listen_sock);

#if	PORT_WHO
	sprintf(mess, "%s/who.%u", TMPDIR, port);
	unlink(mess);
#endif

	/* Free all area information */
	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		ListDestroy(area->echos);
		ListDestroy(area->conv);
		delete_area_links(area->move);
		free(area->move);
	}
	ListDestroy(astr);

	/* Free the remaining linked list items */
	ListDestroy(wiz_tells);
	ListDestroy(rec_logs);

	exit(0);
}


/*** shutdown talker ***/
void c_shutdown_talker(void)
{
	if (shutd != this_user)
	{
		write_user(this_user, "Are you sure about this (y/n)? ", MSG_FORCED);
		shutd = this_user;
		this_user->noprompt = 1;
		this_user->callback = c_shutdown_talker;
	}
	else	/* see if input is answer to shutdown query */
	{
		if ( tolower(inpstr[0]) == 'y')
			do_shutdown();	/* No return from this call */

		shutd = NULL;
		this_user->noprompt = 0;
		this_user->callback = NULL;
	}
}


/*** search for specific word in the message files ***/
void c_search(void)
{
	Node *node;
	AREA_DATA *area;
	int  occured = 0;
	char filename[80];
	char line[ARR_SIZE];		/* Original line read from file */
	FILE *fp;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .search <search string>\n", MSG_FORCED);
		return;
	}

	page_user_output(this_user, NULL, PGOUT_NEW);

/* look through boards */
	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if ((area->wiz_only && this_user->level < MAGICAL)
			|| !area->searchable)
		{
			continue;
		}

		sprintf(filename, "%s/%s", MESSDIR, area->name);
		if ((fp = fopen(filename, "r")) == NULL)
			continue;
		fgets(line, sizeof(line), fp);
		while (!feof(fp))
		{
			if (!instr(line, inpstr))
			{
				fgets(line, sizeof(line), fp);
				continue;
			}
			sprintf(mess, "%s : %s", area->name, line);
			mess[0] = toupper(mess[0]);
			page_user_output(this_user, mess, PGOUT_ADD);
			++occured;
			fgets(line, sizeof(line), fp);
		}
		fclose(fp);
	}
	if (!occured)
		write_user(this_user, "No occurences found\n\n", MSG_FORCED);
	else
	{
		sprintf(mess, "\n%d occurences found\n\n", occured);
		page_user_output(this_user, mess, PGOUT_ADD);
	}
	page_user_output(this_user, NULL, PGOUT_DONE);
}

/*** review recorded messages of various types ***/
void c_review(void)
{
	static char *options[] = { /*"talk",*/ "tells", "logons", "wtells", "echos", NULL};
	static int levels[] = { /*USER,*/ USER, USER, WIZARD, USER };
	int option;
	char word[10];
	List *list;

	get_word(inpstr, word, sizeof(word));
	if (word[0] == '\0')
		option = 0;
	else
	{
		option = choose(word, options);
		if (option == -1 || (levels[option] > this_user->level))
		{
			if (this_user->level < MAGICAL)
				write_user(this_user, "Usage: .review [ tells | logons | echos ]\n", MSG_FORCED);
			else
				write_user(this_user, "Usage: .review [ tells | logons | wtells | echos ]\n", MSG_FORCED);
			return;
		}

		++option;
	}

	switch (option)
	{
	case 0:		/* speech and emotes */
		write_user(this_user, "*** Reviewing Conversation ***\n", MSG_FORCED);
		list = this_user->area->conv;
		break;
	case 1:		/* private tells and emotes */
		write_user(this_user, "*** Reviewing Tells ***\n", MSG_FORCED);
		list = this_user->tells;
		break;
	case 2:		/* login and logoffs */
		write_user(this_user, "*** Reviewing Logon/logoffs ***\n", MSG_FORCED);
		list = rec_logs;
		break;
	case 3:		/* wizard tells and emotes */
		write_user(this_user, "*** Reviewing Wiztells ***\n", MSG_FORCED);
		list = wiz_tells;
		break;
	case 4:		/* echos */
		write_user(this_user, "*** Reviewing Echos ***\n", MSG_FORCED);
		list = this_user->area->echos;
		break;
	}

	review(this_user, list);

	write_user(this_user, "*** End of review ***\n", MSG_FORCED);
}


/*** help function ***/
void c_help(void)
{
	int user_level, com_level;
	int com, nl;
	char filename[ARR_SIZE], word[ARR_SIZE], word2[ARR_SIZE];

	user_level = this_user->arrested ? DUNCE : this_user->level;

/* help for one command */
	get_word(inpstr, word, sizeof(word));
	if (word[0] != '\0')
	{
		sprintf(word2, ".%s", word);	/* Make word in to a command */
		com = get_com_index(word2);		/* Lets see if it is a command */

		/* Deal with help relating to specific commands */
		if (com != CMD_BAD)		/* User is asking for help on a command */
		{
			if (user_level < cmd_info[com].level)
				write_user(this_user, "There is no such command\n", MSG_FORCED);
			else
			{	/* Get command name and ignore shortcut indicators in cmd_info[] array */
				get_word(cmd_info[com].string, word2, sizeof(word2));
				sprintf(filename, "%s/%s", HELPDIR, word2);
				if (more(this_user, filename) == MORE_NO_FILE)
					write_user(this_user, "Sorry - no help information was found for that command\n", MSG_FORCED);
			}
			return;
		}

		/* Make sure word doesn't contain any funny characters in */
		/* it which could be an attempt to change directories.	  */
		if (strchr(word, '.') != NULL || strchr(word, '/') != NULL)
			nl = MORE_NO_FILE;
		else
		{
			sprintf(filename, "%s/%s", HELPDIR, word);
			nl = more(this_user, filename);
		}
		if (nl == MORE_NO_FILE)
			write_user(this_user, "Sorry - no help information was found for that topic\n", MSG_FORCED);
		return;
	}

/* general help */
	write_user(this_user, "\n*** Commands available ***\n\n", MSG_FORCED);
	for (com_level = DUNCE; com_level <= user_level; ++com_level)
	{
		sprintf(mess, "^(%s)\n", levstr[com_level]);
		write_user(this_user, mess, MSG_FORCED);

		com = 0;
		nl = 0;
		while (cmd_info[com].func != NULL)
		{
			if (cmd_info[com].level != com_level)
			{
				++com;
				continue;
			}
			sprintf(mess, "%-10s ", cmd_info[com].string);
			write_user(this_user, mess, MSG_FORCED);
			++nl;
			++com;
			if (nl == 7)
			{
				write_user(this_user, "\n", MSG_FORCED);
				nl = 0;
			}
		}

		if (nl > 0)
			write_user(this_user, "\n", MSG_FORCED);
	}
	write_user(this_user, "\nAll commands start with a '.' and can be abbreviated.\n", MSG_FORCED);
	write_user(this_user, "For further help, type .help <command> or .help general for general help.\n\n", MSG_FORCED);
}


/*** Broadcast message to everyone without the "X shouts:" bit ***/
void c_broadcast(void)
{
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .bcast <message>\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "*** %s ***\n", inpstr);
	write_alluser(this_user, mess, NULL, 1, MSG_BCAST);
}


/*** Show the latest system news ***/
void c_news(void)
{
	write_user(this_user, "\n*** News ***\n", MSG_FORCED);
	if (more(this_user, NEWSFILE) == MORE_NO_FILE)
		write_user(this_user, "There is no news today\n\n", MSG_FORCED);
}


/*** Display system status and values of various options ***/
void system_status(user)
USER_DATA *user;
{
char line[80];
int i;

	static char *clop[] = { "CLOSED", "OPEN" };
	static char *allowstrs[] = { "DISALLOWED", "ALLOWED" };

	write_user(user, "\n*** System Status ***\n\n", MSG_FORCED);

	sprintf(line, "Booted (PID %d)", process_id);
	sprintf(mess, "%-20s: %.24s  (%s ago)\n",
			line, ctime(&start_time),
			secstostring(time(NULL) - start_time) );
	write_user(user, mess, MSG_FORCED);

	write_user(user, "User levels         : ", MSG_FORCED);
	for (i = 0; i <= MAX_LEVEL; ++i)
	{
		sprintf(mess, "%s ", levstr[i]);
		write_user(user, mess, MSG_FORCED);
		if (i > 0 && (i % 6) == 0)
			write_user(user, "\n                      ", MSG_FORCED);
	}
	write_user(user, "\n", MSG_FORCED);

	sprintf(mess, "Port number         : %-16d", port);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Max topic length    : %d\n", TOPIC_LEN);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "System logging      : %-16s", onoff[syslog_on]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "No. of profile lines: %d\n", profile_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "Talker login status : %-16s", clop[system_open]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Tell review lines   : %d\n", max_tell_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "New users           : %-16s", allowstrs[allow_new]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Area review lines   : %d\n", max_area_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "Min login level     : %-16s", levstr[min_login_lvl]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Echo review lines   : %d\n", max_echo_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "Default user level  : %-16s", levstr[init_user_lvl]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Login/logoff lines  : %d\n", max_log_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "No auto-logout level: %-16s", levstr[no_logout_lvl]);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Wiztell review lines: %d\n", max_wiz_lines);
	write_user(user, mess, MSG_FORCED);

	sprintf(line, "Current no. of users: %d of %d", num_of_users, max_users);
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Atmospherics        : %s\n", onoff[atmos_on]);
	write_user(user, mess, MSG_FORCED);
#if	DEBUG_TALKER
sprintf(line, "     Login count is : %d\n", login_count);	/* ~~~~~ */
write_user(user, line, MSG_FORCED);
#endif

	sprintf(mess, "No. of areas        : %-16d", num_areas);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Stop fake messages  : %s\n", onoff[prevent_fakes]);
	write_user(user, mess, MSG_FORCED);

	sprintf(mess, "Max log-in attempts : %-16d", max_attempts);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Bold in messages    : %s\n", allowstrs[allow_bold]);
	write_user(user, mess, MSG_FORCED);

	sprintf(line, "Alarm timer         : %d secs.", heartbeat);
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Login level show    : %s\n", onoff[login_show_lvl]);
	write_user(user, mess, MSG_FORCED);

	sprintf(line, "Log-in time out     : %d secs.", login_timeout);
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Login show min.     : %s\n", levstr[login_show_min]);
	write_user(user, mess, MSG_FORCED);

	if (idle_mention > 0)
		sprintf(line, "Idling mention      : %d minutes", idle_mention);
	else
		sprintf(line, "Idling mention      : Disabled");
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Show examines       : %s\n", onoff[show_examines]);
	write_user(user, mess, MSG_FORCED);

	if (idle_warning > 0)
		sprintf(line, "Auto-logout warning : %d minutes", idle_warning);
	else
		sprintf(line, "Auto-logout warning : Disabled");
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Show whispers       : %s\n", onoff[show_whispers]);
	write_user(user, mess, MSG_FORCED);

	if (idle_logout > 0)
		sprintf(line, "Auto-logout time    : %d minutes", idle_logout);
	else
		sprintf(line, "Auto-logout         : Disabled");
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Show ignores        : %s\n", onoff[show_ignores]);
	write_user(user, mess, MSG_FORCED);

	sprintf(line, "Message lifetime    : %d days", message_life);
	sprintf(mess, "%-38s", line);
	write_user(user, mess, MSG_FORCED);
	sprintf(mess, "Show ignoring user  : %s\n\n", onoff[show_user_ign]);
	write_user(user, mess, MSG_FORCED);
}


/*** Display system status or edit values of various parameters ***/
void c_system(void)
{
static char *set_options[] = { "set", NULL };
char option[8], *s;
int i;

	get_word(inpstr, option, sizeof(option));
	s = skip_word(inpstr);

	i = choose(option, set_options);
	if ((i == -1 && option[0] != '\0') ||
		(i == 0 && *s == '\0'))
	{
		write_user(this_user, "Usage: .system\n", MSG_FORCED);
		write_user(this_user, "     | .system set <parameter> <value>\n", MSG_FORCED);
		return;
	}

	/* Show new system status after value is changed */
	/* If an error in parsing occurs, returns a 1	 */
	/* which will keep it from showing parameters.	 */
	/* Kind of nasty in a way but also elegant.		 */
	if (i == 0)
	{
		i = parse_init_section(this_user, s);
		if (i == 0)
			i = verify_init_data(this_user);
	}
		
	if (i != 1)
		system_status(this_user);
}


/*** Move user somewhere else ***/
void c_move(void)
{
	char other_user[NAME_LEN];
	char area_name[AREA_NAME_LEN];
	USER_DATA *user2;
	AREA_DATA *new_area;
	int teleport;

/* do checks */
	get_user_name(inpstr, other_user, sizeof(other_user));
	get_word(skip_word(inpstr), area_name, sizeof(area_name));
	if (other_user[0] == '\0' || area_name[0] == '\0')
	{
		write_user(this_user, "Usage: .move <user> <area>\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;

	if (this_user == user2)		/* Is user is moving himself? */
	{
		write_user(this_user, "There is an easier way to move yourself\n", MSG_FORCED);
		return;
	}

/* see if user to be moved is of a lower level */
	if (this_user->level <= user2->level)
	{
		write_user(this_user, "Hmm ... inadvisable\n", MSG_FORCED);
		sprintf(mess, "%s thought about moving you\n", this_user->name);
		write_user(user2, mess, MSG_FORCED);
		return;
	}

	if ( !is_area_reachable(user2, area_name, &new_area, &teleport) )
		return;

	go_cmd(user2, new_area, teleport);

	sprintf(mess, "%s MOVED %s to area %s\n",
			this_user->name, user2->name, new_area->name);
	write_syslog(mess, LOG_MOVE, 1);
}


/*** Echo function writes straight text to screen ***/
void c_echo(void)
{
	static char *err = "Sorry - you can't echo that\n";
	char *str, word[NAME_LEN];
	AREA_DATA *area;
	Node *node;
	USER_DATA *user;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .echo <text>\n", MSG_FORCED);
		return;
	}

	if (prevent_fakes)
	{
		/* Skip over any non-printable characters in input */
		for (str = inpstr; *str; ++str)
		{
			if (isalpha(*str) || *str == '-')
				break;
		} 
		/* Get first word & check it for illegal stuff */
		get_word(str, word, sizeof(word));

		/* Prevent faking of SIGN ON/OFF messages, the faking of stuff	*/
		/* from invisible users, and the faking of tell messages.	*/
		if (strcasecmp(word, "SIGN") == 0 || strcasecmp(word, "RELOG") == 0 ||
			strcasecmp(word, "Someone") == 0 ||
			strcasecmp(word, "You") == 0 ||
			(login_show_lvl && word[0] == '[') ||
			strncmp(word, "->", 2) == 0)
		{
			write_user(this_user, err, MSG_FORCED);
			return;
		}

		/* Echo not allowed if first word is the name of a logged in user */
		user = find_userdata(this_user, word, 1, 0);
		if (user != NULL)
		{
			write_user(this_user, err, MSG_FORCED);
			return;
		}
	}

/* write message */
	sprintf(mess, "^%s echos:^ ", this_user->name);
	str = &mess[ strlen(mess) ];
	strcat(mess, inpstr);
	strcat(mess, "\n");

	area = this_user->area;
	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		user = (USER_DATA *)NodeData(node);
		node = NodeNext(node);

		if (user->area == area)
		{
			if (user->level < MAGICAL)
				write_user(user, str, MSG_ECHO);
			else
				write_user(user, mess, MSG_ECHO);
		}
	}
	record_say(this_user->area, str);
	record_echo(this_user->area, mess);
}


/*** Set user description ***/
void c_set_desc(void)
{
	if (!inpstr[0])
	{
		sprintf(mess, "Your description is: %s\n", this_user->desc);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}
	get_string(inpstr, this_user->desc, DESC_LEN);
	(void)save_userdata(this_user);
	sprintf(mess, "You are now known as: %s %s\n", this_user->name, this_user->desc);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Display version of code being run ***/
void c_version(void)
{
	char buff[80];

	sprintf(buff, "NUTS version %s (rev %.*s)\n",
			VERSION, rcsid[20] == ' ' ? 3 : 4, &rcsid[17]);
	write_user(this_user, buff, MSG_FORCED);
#if	HONOUR_TELNET
	sprintf(buff, "Telnet library %s by Birddog (modified by Casey)"
#if	DEBUG_TELNET
			" (DEBUG)"
#endif
				"\n", TELNETVERSION);
	write_user(this_user, buff, MSG_FORCED);
#endif
#if	USE_WRAPPER
	sprintf(buff, "TCP wrappers are enabled"
#if	PARANOID
                                " (paranoid mode)"
#endif
                                "\n");
	write_user(this_user, buff, MSG_FORCED);
#endif
	write_user(this_user, "\n", MSG_FORCED);
}


/*** This routine checks for a valid edit command ***/
int edit_file_valid_cmd(char *line)
{
int i;

	if (line[0] != '.')		/* No dot, then no command */
		return 0;

	if (line[2] == '\0')	/* Single character command? */
	{	/* Check for valid alphabetic commands */
		if (strchr("abdfhinpqrsvx", line[1]) != NULL)
			return 1;
	}

	/* Only thing left is a number */
	i = strspn(&line[1], "0123456789");
	if (line[i+1] == '\0')
		return 1;

	return 0;
}


void edit_file_show_cmds(int detailed)
{
	write_user(this_user, "\nEdit commands:", MSG_FORCED);
	if (!detailed)
	{
		write_user(this_user, " .nn, .a, .b, .d, .f, .h, .i, .n, .p, .q, .r, .s, .v, .x\n", MSG_FORCED);
		write_user(this_user, "[Type .h for help]\n", MSG_FORCED);
	}
	else
	{
		write_user(this_user, "\n    .nn   go to line nn (ie. .10 to go to line 10)\n", MSG_FORCED);
		write_user(this_user, "    .a    abandon changes and keep existing file\n", MSG_FORCED);
		write_user(this_user, "    .b    go back to previous line\n", MSG_FORCED);
		write_user(this_user, "    .d    delete current line\n", MSG_FORCED);
		write_user(this_user, "    .f    go forward to next line\n", MSG_FORCED);
		write_user(this_user, "    .h    display this help information\n", MSG_FORCED);
		write_user(this_user, "    .i    insert new line before the current line\n", MSG_FORCED);
		write_user(this_user, "    .n    go to next line\n", MSG_FORCED);
		write_user(this_user, "    .p    go to previous line\n", MSG_FORCED);
		write_user(this_user, "    .q    quit and abandon changes (same as .a)\n", MSG_FORCED);
		write_user(this_user, "    .r    remove all lines in edit buffer\n", MSG_FORCED);
		write_user(this_user, "    .s    save contents of edit buffer and exit\n", MSG_FORCED);
		write_user(this_user, "    .v    view lines in edit buffer\n", MSG_FORCED);
		write_user(this_user, "    .x    exit and save contents of edit buffer (same as .s)\n", MSG_FORCED);
	}
}


/*** Show current contents of edit buffer ***/
void edit_file_show_buffer(void)
{
Node *node;

	if (this_user->edit_cnt > 0)
	{
		write_user(this_user, "\nCurrent contents of edit buffer:\n", MSG_FORCED);
		node = NodeHead(this_user->edit_lines);
		while (!isEndOfList(this_user->edit_lines, node))
		{
			if (NodeData(node) == NULL)
				strcpy(mess, "\n");
			else
				sprintf(mess, "%s\n", (char *)NodeData(node));
			write_user(this_user, mess, MSG_FORCED);
			node = NodeNext(node);
		}
	}
}


/*** Exit file edit mode ***/
void edit_file_exit(void)
{
char *name;

	name = vis_user_name(this_user);
	if (this_user->pro_enter)
		sprintf(mess, "%s finishes entering a profile\n", name);
	else
		sprintf(mess, "%s finishes entering something\n", name);
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);

	ListDestroy(this_user->edit_lines);
	this_user->edit_lines = NULL;
	this_user->pro_enter = 0;

	this_user->which_msgs = this_user->tmp_msgs;	/* Restore listen flags */
	this_user->noprompt = 0;
	this_user->callback = NULL;
}


/*** Perform initialization when entering file edit mode ***/
void edit_file_initialize(void)
{
FILE *fp;
int done;
char *s, *buff;

	this_user->edit_cnt = 0;
	this_user->edit_lines = ListCreate();
	if (this_user->edit_lines == NULL)
	{
		sprintf(mess, "Sorry - Not enough memory to perform edit at this time.\n");
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	/* Read the contents of the existing file (if any) */
	fp = fopen(this_user->users_file, "r");
	if (fp != NULL)
	{
		done = 0;
		do {
			s = fgets(mess, sizeof(mess), fp);
			if (s == NULL)
				break;

			mess[ strlen(mess)-1 ] = '\0';	/* Strip trailing newline */
			buff = strdup(mess);
			if (buff == NULL)
			{
				write_user(this_user, "Can't edit file at this time\n", MSG_FORCED);
				edit_file_exit();
				return;
			}

			if (NodeAddTailNew(this_user->edit_lines, buff) != NULL)
				++this_user->edit_cnt;
			else
			{
				write_user(this_user, "Can't edit file at this time\n", MSG_FORCED);
				edit_file_exit();
				return;
			}
		} while (this_user->edit_max == 0 ||
				this_user->edit_cnt < this_user->edit_max);

		fclose(fp);
	}

	this_user->callback = edit_file;

	this_user->edit_ptr = NodeHead(this_user->edit_lines);
	this_user->edit_which = 1;

	this_user->noprompt = 1;
	this_user->tmp_msgs = this_user->which_msgs;	/* Save listen flags */
	this_user->which_msgs = MSG_FORCED;

	if (this_user->edit_max > 0)
	{
		sprintf(mess, "You are allowed a maximum of %d lines.\n", this_user->edit_max);
		write_user(this_user, mess, MSG_FORCED);
	}

	edit_file_show_cmds(0);
	edit_file_show_buffer();
	sprintf(mess, "\nLine %d (%d lines in buffer)    [Type .h for help]\n",
			this_user->edit_which,
			this_user->edit_cnt);
	write_user(this_user, mess, MSG_FORCED);
	if (this_user->edit_cnt > 0)
	{
		s = (char *)NodeData( NodeHead(this_user->edit_lines) );
		if (s == NULL)
			write_user(this_user, "\n", MSG_FORCED);
		else
		{
			sprintf(mess, "%s\n", s);
			write_user(this_user, mess, MSG_FORCED);
		}
	}
}


void edit_file_save(void)
{
FILE *fp;
Node *node;

	if (this_user->edit_cnt < 1)
	{
		if (this_user->pro_enter)
			sprintf(mess, "Your profile has been erased\n\n");
		else
			sprintf(mess, "The file %s has been erased\n\n", this_user->users_file);
		write_user(this_user, mess, MSG_FORCED);
		unlink(this_user->users_file);
		return;
	}

	/* Read the contents of the existing file (if any) */
	fp = fopen(this_user->users_file, "w");
	if (fp == NULL)
	{
		write_user(this_user, "Unable to output edit buffer to disk...abandoning edit\n", MSG_FORCED);
		return;
	}

	node = NodeHead(this_user->edit_lines);
	while (!isEndOfList(this_user->edit_lines, node))
	{
		if (NodeData(node) == NULL)
			strcpy(mess, "\n");
		else
			sprintf(mess, "%s\n", (char *)NodeData(node));
		fputs(mess, fp);
		node = NodeNext(node);
	}

	fclose(fp);

	write_user(this_user, "Your changes have been saved\n\n", MSG_FORCED);
}


/*** Edit the contents of a file ***/
void edit_file(void)
{
static char *no_memory_error = "Out of memory...line unchanged\n";
static char *no_more_lines = "You cannot add any more lines - edit buffer is full\n";
static char *at_first_line = "You are already at the first line in the edit buffer\n";
static char *at_last_line = "You are at the last line in the edit buffer\n";
int no_prompt;
int line;
Node *node;
char *s;

#if	LOG_CMD
	{
	char stuff[ARR_SIZE];

		sprintf(stuff, "%s: '%s'\n", this_user->name, inpstr);
		write_syslog(stuff, "cmds.log", 1);
	}
#endif

	if (this_user->edit_lines == NULL)
	{
		edit_file_initialize();
		return;
	}

	no_prompt = 0;

	if (!edit_file_valid_cmd(inpstr))
	{
		inpstr[80] = '\0';

		/* A return by itself moves to next line (if any) */
		/* of the file rather than adding a blank line.   */
		if (inpstr[0] == '\0')
		{
			if (this_user->edit_which <= this_user->edit_cnt &&
				this_user->edit_which < this_user->edit_max)
			{
				++this_user->edit_which;
			}
			else
			{
				write_user(this_user, at_last_line, MSG_FORCED);
			}
		}
		else	/* Adding or changing a line */
		{
			if (this_user->edit_max > 0 && this_user->edit_which > this_user->edit_max)
			{
				write_user(this_user, no_more_lines, MSG_FORCED);
				no_prompt = 1;
			}
			else
			{
				s = strdup(inpstr);
				if (s == NULL)
				{
					write_user(this_user, no_memory_error, MSG_FORCED);
					return;
				}

				/* Replacing an existing line in edit buffer? */
				if (this_user->edit_which <= this_user->edit_cnt)
				{
					if (NodeData(this_user->edit_ptr) != NULL)
						free( NodeData(this_user->edit_ptr) );
					NodeData(this_user->edit_ptr) = s;
				}
				else	/* We are adding a new line */
				{
					node = NodeAddTailNew(this_user->edit_lines, s);
					if (node == NULL)
					{
						write_user(this_user, no_memory_error, MSG_FORCED);
						free(s);
						return;
					}
					this_user->edit_ptr = node;
					++this_user->edit_cnt;
				}

				if (this_user->edit_which < this_user->edit_max)
					++this_user->edit_which;
				else
					write_user(this_user, no_more_lines, MSG_FORCED);
			}
		}

		if (this_user->edit_which <= this_user->edit_cnt &&
			this_user->edit_which < this_user->edit_max)
		{
			this_user->edit_ptr = NodeNext(this_user->edit_ptr);
		}
	}
	else	/* Deal with the command */
	{
		if (isdigit(inpstr[1]))		/* Go to specific line */
		{
			line = atoi(&inpstr[1]);
			if (line > 0 && line <= this_user->edit_cnt)
			{
				this_user->edit_which = 0;
				node = NodeHead(this_user->edit_lines);
				while (!isEndOfList(this_user->edit_lines, node))
				{
					if (++this_user->edit_which == line)
						break;

					node = NodeNext(node);
				}
				this_user->edit_ptr = node;
			}
			else
			{
				if (line <= 0)
					sprintf(mess, "The line number must be greater than 0\n");
				else
				{
					sprintf(mess, "There are only %d lines in the edit buffer\n",
							this_user->edit_cnt);
				}
				write_user(this_user, mess, MSG_FORCED);
			}
		}
		else
		{
			switch (inpstr[1])
			{
			case 'a':	/* Abort edit */
			case 'q':
				write_user(this_user, "Abandoning edit mode. Edit buffer was not saved.\n\n", MSG_FORCED);
				edit_file_exit();
				return;
			case 'd':	/* Delete line */
				if (this_user->edit_cnt <= 0)
					write_user(this_user, "There are no lines in the edit buffer\n", MSG_FORCED);
				else
				{
					if (this_user->edit_which > this_user->edit_cnt)
						write_user(this_user, "There is no line to delete\n", MSG_FORCED);
					else
					{
						node = this_user->edit_ptr;
						if (this_user->edit_which < this_user->edit_cnt)
							this_user->edit_ptr = NodeNext(node);
						else	
						{
							this_user->edit_ptr = NodePrev(node);
							if (this_user->edit_which > 1)
								--this_user->edit_which;
						}
						--this_user->edit_cnt;
						(void)NodeRemove(node);
						NodeDestroy(node);
					}
				}
				break;
			case 'h':	/* Show help */
				edit_file_show_cmds(1);
				no_prompt = 1;
				break;
			case 'i':	/* Insert a new line */
				if (this_user->edit_max > 0 && this_user->edit_cnt >= this_user->edit_max)
				{
					write_user(this_user, no_more_lines, MSG_FORCED);
					no_prompt = 1;
				}
				else
				{	/* Insert a new line before current one */
					node = NodePrev(this_user->edit_ptr);	/* Get pointer to the previous line */
					node = NodeAddNew(node, NULL);		/* Adds new line (ie. node) after 'node' */
					if (node == NULL)
						write_user(this_user, no_memory_error, MSG_FORCED);
					else
					{
						this_user->edit_ptr = node;
						++this_user->edit_cnt;
					}
				}
				break;
			case 'f':	/* Next line */
			case 'n':
				if (this_user->edit_which > this_user->edit_cnt &&
					this_user->edit_which < this_user->edit_max)
				{
					write_user(this_user, at_last_line, MSG_FORCED);
				}
				else
				{
					if (this_user->edit_which < this_user->edit_cnt)
						this_user->edit_ptr = NodeNext(this_user->edit_ptr);
					++this_user->edit_which;
				}
				break;
			case 'b':	/* Previous line */
			case 'p':
				if (this_user->edit_which <= 1)
					write_user(this_user, at_first_line, MSG_FORCED);
				else
				{
					if (this_user->edit_which <= this_user->edit_cnt)
						this_user->edit_ptr = NodePrev(this_user->edit_ptr);
					--this_user->edit_which;
				}
				break;
			case 'r':	/* Remove all lines in edit buffer */
				ListRemAll(this_user->edit_lines);
				this_user->edit_ptr = (Node *)this_user->edit_lines;
				this_user->edit_cnt = 0;
				this_user->edit_which = 1;
				break;
			case 's':	/* Save lines in edit buffer and exit */
			case 'x':
				edit_file_save();
				edit_file_exit();
				return;
			case 'v':	/* View lines in edit buffer */
				if (this_user->edit_cnt > 0)
					edit_file_show_buffer();
				else
					write_user(this_user, "\n^The edit buffer is empty\n", MSG_FORCED);
				break;
			}
		}
	}

	sprintf(mess, "\nLine %d (%d lines in buffer)    [Type .h for help]\n",
			this_user->edit_which,
			this_user->edit_cnt);
	write_user(this_user, mess, MSG_FORCED);
	if (!no_prompt)
	{
		if (this_user->edit_which > 0 &&
			this_user->edit_which <= this_user->edit_cnt)
		{
			s = (char *)NodeData(this_user->edit_ptr);
			if (s == NULL)
				write_user(this_user, "\n", MSG_FORCED);
			else
			{
				sprintf(mess, "%s\n", s);
				write_user(this_user, mess, MSG_FORCED);
			}
		}
	}
}


/*** Enter profile ***/
void c_edit_profile(void)
{
	sprintf(mess, "%s is entering a profile...\n", vis_user_name(this_user));
	write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);

	sprintf(mess, "\n** Entering a profile **\n");
	write_user(this_user, mess, MSG_FORCED);

	sprintf(this_user->users_file, "%s/%c/%s.P",
			PROFILESDIR, this_user->name[0], this_user->name);
	this_user->edit_max = profile_lines;
	this_user->pro_enter = 1;
	edit_file();
}


/*** show profile ***/
void c_examine(void)
{
	char user2_name[NAME_LEN];
	USER_DATA *user2_data;
	time_t current_time, time_val;
	char filename[80];
	long secs;

	if (!inpstr[0])
		user2_data = this_user;
	else
	{
		get_user_name(inpstr, user2_name, sizeof(user2_name));
		user2_data = get_userdata(this_user, user2_name, 0);
		if (user2_data == NULL)
		{
			write_user(this_user, "There is no such user\n", MSG_FORCED);
			return;
		}
	}

	time_val = user_frozen(user2_data);
	if (time_val != 0)
	{
		if (this_user->level >= MAGICAL)
		{
			if (time_val == -1)
				sprintf(mess, "Examining an account FROZEN forever\n");
			else	/* ctime() string ends in a '\n' */
				sprintf(mess, "Examining an account FROZEN until %s", ctime(&time_val));
			write_user(this_user, mess, MSG_FORCED);
		}
		else 
		{
			write_user(this_user, "Sorry - that account has been frozen\n", MSG_FORCED);
			return;
		}
	}

	if (show_examines)
	{
		/* Is user logged in and is examining someone else? */
		if (user2_data->sock != -1 && this_user != user2_data)
		{
			sprintf(mess, "%s examines you ...\n", this_user->name);
			write_user(user2_data, mess, MSG_SYSTEM);
		}
	}

	current_time = time(NULL);

	sprintf(mess, "\n*** %s %s ***\n", user2_data->name, user2_data->desc);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "Level: %s\n", user2_data->arrested ? "JAILED" : levstr[user2_data->level]);
	write_user(this_user, mess, MSG_FORCED);

	/* Check that user is not logged in */
	if (user2_data->sock == -1)
	{
		if (user2_data->last_off == 0)
			write_user(this_user, "This user has never logged in\n", MSG_FORCED);
		else
		{
			if (user2_data->last_on == 0)
			{
				sprintf(mess, "Last logged off: %.24s",
						ctime(&user2_data->last_off));
				write_user(this_user, mess, MSG_FORCED);
			}
			else
			{
				sprintf(mess, "Last on: %.24s ", ctime(&user2_data->last_on) );
				write_user(this_user, mess, MSG_FORCED);

				/* We know the user logged in so if they aren't currently	*/
				/* logged in we know there should be a valid log out time.	*/
				sprintf(mess, "for %s",
						secstostring(user2_data->last_off - user2_data->last_on) );
				write_user(this_user, mess, MSG_FORCED);

			}
			sprintf(mess, " (%s ago)",
					secstostring(current_time - user2_data->last_off) );
			write_user(this_user, mess, MSG_FORCED);

			if (this_user->level >= MAGICAL)
			{
				sprintf(mess, "\n         from %s",
						print_site(&user2_data->old_site));
				write_user(this_user, mess, MSG_FORCED);
			}

			write_user(this_user, "\n", MSG_FORCED);
		}
	}
	else	/* User is logged in */
	{
		if (this_user != user2_data)
		{
			sprintf(mess, "%s is currently logged in.\n", user2_data->name);
			write_user(this_user, mess, MSG_FORCED);
		}

		secs = current_time - user2_data->last_input;
		if (secs > 0)
		{
			sprintf(mess, "User has been idle for %s\n",
					secstostring(current_time - user2_data->last_input) );
			write_user(this_user, mess, MSG_FORCED);
		}
	}

	/* Show following details if user is examining themself */
	/* or the user doing the examine is a Wizard or SU.		*/
	if (this_user == user2_data || this_user->level >= MAGICAL)
	{
		if (user2_data->sock == -1)
			sprintf(mess, "Total login time: %s\n", secstostring(user2_data->totaltime));
		else
		{
			sprintf(mess, "Currently on from: %s\n", print_site(&user2_data->site));
			write_user(this_user, mess, MSG_FORCED);
			sprintf(mess, "Was last on from : %s\n", print_site(&user2_data->old_site));
			write_user(this_user, mess, MSG_FORCED);
			sprintf(mess, "Total login time: %s\n",
					secstostring(user2_data->totaltime + (current_time - user2_data->login)));
		}
		write_user(this_user, mess, MSG_FORCED);

		if (user2_data->gagged)
		{
			if (this_user == user2_data)
				sprintf(mess, "You have been gagged.\n");
			else
				sprintf(mess, "%s has been gagged.\n", user2_data->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		else if (user2_data->muzzled)
		{
			if (this_user == user2_data)
				sprintf(mess, "You are currently wearing a muzzle.\n");
			else
				sprintf(mess, "%s is currently wearing a muzzle.\n", user2_data->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		write_user(this_user, "Set info: ", MSG_FORCED);
		sprintf(mess, "Screen size is %d columns and %d rows.\n          ",
				user2_data->cols, user2_data->rows);
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "Echo: %s  Word wrap: %s  Paging: %s  Bold: %s  Prompt: %s\n",
				onoff[ user2_data->echo ], onoff[ user2_data->wrap ],
				onoff[ user2_data->paging ], onoff[ user2_data->use_bold ],
				onoff[ user2_data->prompt ]);
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "Listening to: Talk: %s, Shouts: %s, Tells: %s, Echos: %s, Logons: %s\n",
				yesno[ (user2_data->which_msgs & MSG_TALK) ? 1 : 0 ],
				yesno[ (user2_data->which_msgs & MSG_SHOUT) ? 1 : 0 ],
				yesno[ (user2_data->which_msgs & MSG_TELL) ? 1 : 0 ],
				yesno[ (user2_data->which_msgs & MSG_ECHO) ? 1 : 0 ],
				yesno[ (user2_data->which_msgs & MSG_LOGON) ? 1 : 0 ]);
		write_user(this_user, mess, MSG_FORCED);
		if (user2_data->level < MAGICAL)
		{
			sprintf(mess, "              Beeps: %s, Atmos: %s, System: %s\n",
					yesno[ (user2_data->which_msgs & MSG_BEEP) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_ATMOS) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_SYSTEM) ? 1 : 0 ]);
		}
		else
		{
			sprintf(mess, "              Beeps: %s, Atmos: %s, System: %s, Wiztells: %s, Bcasts: %s\n",
					yesno[ (user2_data->which_msgs & MSG_BEEP) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_ATMOS) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_SYSTEM) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_WTELL) ? 1 : 0 ],
					yesno[ (user2_data->which_msgs & MSG_BCAST) ? 1 : 0 ]);
		}
		write_user(this_user, mess, MSG_FORCED);
	}

	sprintf(filename, "%s/%c/%s.P", PROFILESDIR, user2_data->name[0], user2_data->name);
	if (more(this_user, filename) == MORE_NO_FILE)
	{
		if (this_user != user2_data)
			sprintf(mess, "%s has no profile.\n", user2_data->name);
		else
			sprintf(mess, "You have no profile.\n");
		write_user(this_user, mess, MSG_FORCED);
	}
	write_user(this_user, "\n", MSG_FORCED);
}


/*** Show a different view of who is currently logged in ***/
void c_people(void)
{
#if	PORT_WHO
	who_cmd(this_user, 1, 0);
#else
	who_cmd(this_user, 1);
#endif
}


/*** Delete mail ***/
void c_dmail(void)
{
	char filename[80];
	int lines;

	if (*inpstr == '\0')
	{
		write_user(this_user, "Usage: .dmail n/n,n/n1-n2/all\n", MSG_FORCED);
		return;
	}

	if (this_user->mailmsgs == 0)
	{
		write_user(this_user, "You don't have any mail to delete\n", MSG_FORCED);
		return;
	}

	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, this_user->name[0], this_user->name);
	lines = delete_messages(this_user, filename, this_user->mailmsgs, inpstr);
	if (lines > 0)
	{
		this_user->mailmsgs -= lines;

		sprintf(mess, "You deleted %d pieces of mail\n", lines);
		write_user(this_user, mess, MSG_FORCED);
	}
}


/*** Read mail ***/
void c_rmail(void)
{
	FILE *fp;
	char filename[80];

	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, this_user->name[0], this_user->name);
	if ((fp = fopen(filename, "r")) == NULL)
	{
		write_user(this_user, "You don't have any mail\n", MSG_FORCED);
		return;
	}
	fclose(fp);

	write_user(this_user, "\n*** Your mail ***\n", MSG_FORCED);
	this_user->show_nums = 1;
	(void)more(this_user, filename);
	this_user->lastmail = this_user->mailmsgs;
}


/*** Send mail ***/
void c_smail(void)
{
	char filename[80], name[NAME_LEN];
	USER_DATA *user2;
	FILE *fp;

	get_user_name(inpstr, name, sizeof(name));
	inpstr = skip_word(inpstr);
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .smail <user> <message>\n", MSG_FORCED);
		return;
	}
#if	NO_SMAIL_SELF
	if (!strcmp(name, this_user->name))
	{
		write_user(this_user, "You can't mail yourself - its a waste of filespace\n", MSG_FORCED);
		return;
	}
#endif

/* see if user exists at all */
	if (!user_exists(name))
	{
		write_user(this_user, "There is no such user\n", MSG_FORCED);
		return;
	}
	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, name[0], name);
	if ((fp = fopen(filename, "a")) == NULL)
	{
		sprintf(mess, "%s : Couldn't open mailbox file\n", syserror);
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "ERROR: Couldn't open %s's mailbox file to append in smail()\n", name);
		write_syslog(mess, LOG_ERROR, 1);
		return;
	}

/* send the mail & record mailing */
	sprintf(mess, "(%s) From %s: %s\n",
			timeline(0), vis_user_name(this_user), inpstr);
	fputs(mess, fp);
	fclose(fp);
	sprintf(mess, "You send %s some mail\n", name);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "%s mailed %s\n", this_user->name, name);
	write_syslog(mess, LOG_SMAIL, 1);

/* if recipient is logged on at the moment notify them */
	if ((user2 = find_userdata(this_user, name, 1, 0)) != NULL)
	{
		++user2->mailmsgs;
		write_user(user2, "\n^** YOU HAVE NEW MAIL **^\n\n", MSG_SYSTEM);
	}
}


/*** Send message to a user with a beep to get their attention ***/
void c_beep(void)
{
	USER_DATA *user2;
	char name[NAME_LEN];

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .beep <user>\n", MSG_FORCED);
		return;
	}
	get_user_name(inpstr, name, sizeof(name));
	if ((user2 = find_userdata(this_user, name, 0, 1)) == NULL)
		return;
	if (this_user == user2)
	{
		write_user(this_user, "What's the matter? Do you have a short attention span?\n", MSG_FORCED);
		return;
	}
	if (user2->bafk)
	{
		sprintf(mess, "You can't beep %s while they are in .bafk mode\n", user2->name);
		write_user(user2, mess, MSG_FORCED);
	}
	if (this_user->level < MAGICAL)
	{
		sprintf(mess, "\07*** %s sneaks up behind you and says: BOO!!! ***\07\n", this_user->name);
		write_user(user2, mess, MSG_BEEP);
	}
	else
	{
		sprintf(mess, "\07\07*** %s is trying to get your attention! ***\07\07\n", this_user->name);
		write_user(user2, mess, MSG_FORCED);
	}
	sprintf(mess, "You try to get the attention of %s\n", user2->name);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Advance user a level ***/
void c_promote(void)
{
	USER_DATA *user2;
	char name[NAME_LEN];

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .promote <user>\n", MSG_FORCED);
		return;
	}
	get_user_name(inpstr, name, sizeof(name));
	if ((user2 = find_userdata(this_user, name, 0, 1)) == NULL)
		return;

#if	LIMIT_PROMOTE || SEVERELY_LIMIT_PROMOTE
	/* If user is not maximum user level, limit their ability to promote */
	if (this_user->level != MAX_LEVEL)
	{
#if	SEVERELY_LIMIT_PROMOTE
		/* Don't allow promotion beyond level of person doing the promotion */
		if (user2->level + 1 >= this_user->level)
#else
		/* Allow promotion up to level of person doing the promotion */
		if (user2->level >= this_user->level)
#endif
		{
			sprintf(mess, "You cannot promote %s\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
	}
#endif

	if (user2->level == MAX_LEVEL)
	{
		sprintf(mess, "%s cannot be promoted any further\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}
	++user2->level;
	if (user2->level >= MAGICAL)
		user2->which_msgs |= MSG_WTELL;
	sprintf(mess, "%s has promoted you to the level of %s!\n",
			vis_user_name(this_user), levstr[user2->level]);
	write_user(user2, mess, MSG_FORCED);
	sprintf(mess, "%s PROMOTED %s to %s\n",
			this_user->name, user2->name, levstr[user2->level]);
	write_syslog(mess, LOG_LEVEL, 1);
	(void)save_userdata(user2);
	sprintf(mess, "You have promoted %s to the level of %s!\n",
			user2->name, levstr[user2->level]);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Demote a user ***/
void c_demote(void)
{
	USER_DATA *user2;
	char name[NAME_LEN];

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .demote <user>\n", MSG_FORCED);
		return;
	}
	get_user_name(inpstr, name, sizeof(name));
	if ((user2 = find_userdata(this_user, name, 0, 1)) == NULL)
		return;
	if (this_user != user2 && user2->level == DUNCE)
	{
		write_user(this_user, "You cannot demote that user any farther\n", MSG_FORCED);
		return;
	}
	if (this_user == user2 || this_user->level <= user2->level)
	{
		write_user(this_user, "You can only demote users (other than yourself) who are lower in level\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "%s has demoted you!\n", vis_user_name(this_user));
	write_user(user2, mess, MSG_FORCED);
	sprintf(mess, "%s DEMOTED %s to %s\n",
			this_user->name, user2->name, levstr[user2->level]);
	write_syslog(mess, LOG_LEVEL, 1);
	--user2->level;
	if (user2->level < MAGICAL)
	{
		if (!user2->vis)
			visible(user2, 1);
		user2->which_msgs &= ~MSG_WTELL;
	}
	(void)save_userdata(user2);
	sprintf(mess, "You have demoted %s to the level of %s!\n",
			user2->name, levstr[user2->level]);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Display map of the various areas ***/
void c_map(void)
{
	if (more(this_user, MAPFILE) == MORE_NO_FILE)
		write_user(this_user, "There is no map\n", MSG_FORCED);
}


/*** Change users password ***/
void c_change_pass(void)
{
	char old_passwd[NAME_LEN], new_passwd[NAME_LEN];

	get_word(inpstr, old_passwd, sizeof(old_passwd));
	get_word(skip_word(inpstr), new_passwd, sizeof(new_passwd));
	if (old_passwd[0] == '\0' || new_passwd[0] == '\0')
	{
		write_user(this_user, "Usage: .passwd <old pass> <new pass>\n", MSG_FORCED);
		return;
	}
	if (strlen(new_passwd) > NAME_LEN - 1)
	{
		write_user(this_user, "New password is too long\n", MSG_FORCED);
		return;
	}
	if (strlen(new_passwd) < 4)
	{
		write_user(this_user, "New password is too short\n", MSG_FORCED);
		return;
	}
	if (strcmp(old_passwd, new_passwd) == 0)
	{
		write_user(this_user, "Old and new passwords are the same\n", MSG_FORCED);
		return;
	}
	if (strcmp(this_user->passwd, crypt(old_passwd, SALT)) != 0)
	{
		write_user(this_user, "Incorrect old password\n", MSG_FORCED);
		return;
	}

	strcpy(this_user->passwd, crypt(new_passwd, SALT));
	(void)save_userdata(this_user);

/*
	Output fact of changed password. We save to syslog in case change its not done
	by accounts owner and the owner complains and so we know the time it occured.
*/
	sprintf(mess, "Your password has been changed to \"%s\"\n", new_passwd);
	write_user(this_user, mess, MSG_FORCED);
	sprintf(mess, "User %s changed password\n", this_user->name);
	write_syslog(mess, LOG_PSWD, 1);
}


/*** Do a private emote ***/
void c_premote(void)
{
	char other_user[NAME_LEN];
	USER_DATA *user2;
	char *name;

	get_user_name(inpstr, other_user, sizeof(other_user));
	inpstr = skip_word(inpstr);
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .premote <user> <message>\n", MSG_FORCED);
		return;
	}
	if (this_user->gagged)
	{
		write_user(this_user, "You can't do that while you are gagged.\n", MSG_FORCED);
		return;
	}

	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why would you want to emote to yourself?\n", MSG_FORCED);
		return;
	}
	if ( (user2->which_msgs & MSG_TELL) == 0 )
	{
		sprintf(mess, "%s is ignoring tells^\n", other_user);
		write_user(this_user, mess, MSG_FORCED);
	}
	if (user2->afk)
	{
		sprintf(mess, "^%s is AFK^\n", other_user);
		write_user(this_user, mess, MSG_FORCED);
	}
	name = vis_user_name(this_user);
	sprintf(mess, "^You emote to %s:^ %s %s\n", user2->name, name, inpstr);
	write_user(this_user, mess, MSG_FORCED);
	record_tell(this_user, mess);

	/* If user2 is ignoring this user, don't send the emote */
	if (get_ignore(user2, this_user))
	{
		if (show_user_ign)
		{
			sprintf(mess, "%s is ignoring you!^\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		return;
	}

	sprintf(mess, "^-> %s %s^\n", name, inpstr);
	write_user(user2, mess, MSG_TELL);
	record_tell(user2, mess);
}


/*** Do a shout emote ***/
void c_semote(void)
{
	Node *node;
	AREA_DATA *area;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .semote <text>\n", MSG_FORCED);
		return;
	}
	if (this_user->muzzled || this_user->gagged)
	{
		write_user(this_user, "You can't do that at the moment.\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "! %s %s\n", vis_user_name(this_user), inpstr);
	write_alluser(this_user, mess, NULL, 1, MSG_SHOUT);

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		record_say(area, mess);
	}
}


/*** Ban a site. Don't do any site validation because it's a waste of time. ***/
void c_bansite(void)
{
	char *s, type[4];
	struct site site;
	struct site host_site;
	char filename[80];
	int flag;
	FILE *fp;

	get_word(inpstr, type, sizeof(type));
	flag = choose(type, ban_type);

	s = skip_word(inpstr);
	if (*s == '\0' || flag == -1)
	{
		write_user(this_user, "Usage: .bansite [all | new] <site>\n", MSG_FORCED);
		return;
	}

	strcpy(host_site.addr, "127.0.0.1");
	gethostname(host_site.name, sizeof(host_site.name));
	extract_site(s, &site);		/* Get info on site(s) to ban */

	if ((wild_strcmp(site.addr, host_site.addr) == 0) ||
		(wild_strcmp(site.name, host_site.name) == 0))
	{
		write_user(this_user, "You cannot ban the machine this server is running on\n", MSG_FORCED);
		return;
	}

/* see if site is already banned */
	if (flag)
		strcpy(filename, BANFILE_ALL);
	else
		strcpy(filename, BANFILE_NEW);
	if (banned(&site, filename))
	{
		write_user(this_user, "That site is already banned\n", MSG_FORCED);
		return;
	}

/* Add new ban */
	if ((fp = fopen(filename, "a")) == NULL)
	{
		sprintf(mess, "Sorry...Can't ban that site right now\n%s : couldn't open file %s\n", syserror, filename);
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "ERROR: Couldn't open file %s for append in bansite()\n", filename);
		write_syslog(mess, LOG_ERROR, 1);
		return;
	}
	if (site.addr[0])
		fprintf(fp, "%s ", site.addr);
	fprintf(fp, "%s\n", site.name);
	fclose(fp);

	sprintf(mess, "%s BANNED site %s for %s users\n",
			this_user->name, s, flag ? "all" : "new");
	write_syslog(mess, LOG_BANNED, 1);
	sprintf(mess, "You have banned %s for %s users\n",
			s, flag ? "all" : "new");
	write_user(this_user, mess, MSG_FORCED);
}


/*** Unban a site ***/
void c_unbansite(void)
{
	char *s, line[SITE_LEN];
	char temp_file[80];
	char filename[80];
	int flag;
	FILE *fpi, *fpo;
	int found;

	get_word(inpstr, line, sizeof(line));
	flag = choose(line, ban_type);

	s = skip_word(inpstr);
	if (*s == '\0' || flag == -1)
	{
		write_user(this_user, "Usage: .unbansite [all | new] <site>\n", MSG_FORCED);
		return;
	}

/* Open the files */
	if (flag)
		strcpy(filename, BANFILE_ALL);
	else
		strcpy(filename, BANFILE_NEW);
	if ((fpi = fopen(filename, "r")) == NULL)
	{
		write_user(this_user, "Site not found in file\n", MSG_FORCED);
		return;
	}

	if (tmpnam(temp_file) == NULL)
	{
		write_user(this_user, "Sorry - Couldn't create name for temporary file", MSG_FORCED);
		write_syslog("ERROR: Couldn't create name for temporary file in c_unbansite()\n", LOG_ERROR, 1);
		return;
	}

	if ((fpo = fopen(temp_file, "w")) == NULL)
	{
		sprintf(mess, "Sorry...Can't unban that site right now\n%s : couldn't open a temporary file\n", syserror);
		write_user(this_user, mess, MSG_FORCED);
		write_syslog("ERROR: Couldn't open tempfile for write in unbansite()\n", LOG_ERROR, 1);
		fclose(fpi);
		return;
	}

/* Go through ban file */
	strtolower(s);
	strcat(s, "\n");	/* Strings in file end with '\n' */
	found = 0;

	fgets(line, sizeof(line), fpi);
	while (!feof(fpi))
	{	/* Only remove lines that exactly match specified site info */
		strtolower(line);
		if (strcmp(s, line) == 0)
			found = 1;
		else
			fputs(line, fpo);
		fgets(line, sizeof(line), fpi);
	}
	fclose(fpo);
	fclose(fpi);

	s[strlen(s) - 1] = '\0';	/* Remove the newline */

	if (!found)
	{
		write_user(this_user, "Site info not found in file\n", MSG_FORCED);
		unlink("tempfile");
		return;
	}

/* Make the temp file the ban file. */
	if (file_copy(temp_file, filename) == -1)
	{
		sprintf(mess, "Error copying temporary file\n");
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "ERROR: Couldn't copy temp file to %s in unbansite()\n", filename);
		write_syslog(mess, LOG_ERROR, 1);
	}
	else
	{
		sprintf(mess, "%s UNBANNED site %s for %s users\n",
				this_user->name, s, flag ? "all" : "new");
		write_syslog(mess, LOG_BANNED, 1);
		sprintf(mess, "You have removed the ban of site %s for %s users\n",
				s, flag ? "all" : "new");
		write_user(this_user, mess, MSG_FORCED);
	}

	unlink(temp_file);
}


/*** List banned sites ***/
void c_listbans(void)
{
	char type[4];
	int flag;

	get_word(inpstr, type, sizeof(type));
	flag = choose(type, ban_type);
	if (flag == -1)
	{
		write_user(this_user, "Usage: .listbans [all | new]\n", MSG_FORCED);
		return;
	}

	if (flag)
	{
		write_user(this_user, "\n*** Banned sites (all users) ***\n", MSG_FORCED);
		if (more(this_user, BANFILE_ALL) == MORE_NO_FILE)
			write_user(this_user, "There are no banned sites for all users\n", MSG_FORCED);
	}
	else
	{
		write_user(this_user, "\n*** Banned sites (new users) ***\n", MSG_FORCED);
		if (more(this_user, BANFILE_NEW) == MORE_NO_FILE)
			write_user(this_user, "There are no banned sites for new users\n", MSG_FORCED);
	}
}


/*** Turn on time-of-day prompt ***/
void c_prompt(void)
{
	this_user->prompt ^= 1;
	sprintf(mess, "Prompt %s\n", onoff[this_user->prompt]);
	write_user(this_user, mess, MSG_FORCED);
}


/*** Clear the conversation buffer of an area ***/
void c_cbuff(void)
{
	if (this_user->area->status == AREA_STATUS_FIXED && this_user->level < MAGICAL)
	{
		write_user(this_user, "Sorry - you cannot clear the conversation buffer here\n", MSG_FORCED);
		return;
	}

	cbuff(this_user->area);
	write_user(this_user, ">> Conversation buffer cleared\n", MSG_FORCED);
}


/*** User is leaving their keyboard for a while ***/
void c_afk(void)
{
	int i;

	/* Was command .bafk and not just .afk? ***/
	if (cmd_info[com_index].string[0] == 'b')
	{
		/* Clear screen and stop output till they return */
		for (i = 0; i < 5; ++i)
			write_user(this_user, "\n\n\n\n\n\n\n\n\n\n", MSG_FORCED);
		this_user->bafk = 1;
	}

	this_user->afk = 1;
	sprintf(mess, "%s %s (Gone AFK)\n", vis_user_name(this_user), inpstr);
	write_alluser(this_user, mess, this_user->area, 1, MSG_SYSTEM);
}


/*** Display the rules ***/
void c_rules(void)
{
	char buff[80];

	write_user(this_user, "\n*** Rules ***\n", MSG_FORCED);
	sprintf(buff, "%s/%s", HELPDIR, RULESFILE);
	(void)more(this_user, buff);
}


/*** Muzzle or unmuzzle a user ***/
/* Prevents/allows .shout and .semote */
void muzzle_cmd(user, flag)
USER_DATA *user;
int flag;
{
	char other_user[NAME_LEN];
	char *name;
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (!inpstr[0])
	{
		write_user(this_user, "You must specify a users name!\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why would you want to muzzle yourself?\n", MSG_FORCED);
		return;
	}

	name = vis_user_name(this_user);
	if (flag)
	{
		/* see if user to be muzzled is of a higher level */
		if (this_user->level <= user2->level)
		{
			write_user(this_user, "Hmm...I don't think you really want to do that\n", MSG_FORCED);
			sprintf(mess, "%s thought about muzzling you\n", user->name);
			write_user(user2, mess, MSG_SYSTEM);
			return;
		}

		if (user2->muzzled)
		{
			sprintf(mess, "%s has already been muzzled\n", user2->name);
			write_user(user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has muzzled you\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You put a muzzle on %s\n", user2->name);

		sprintf(mess, "%s MUZZLED %s\n", this_user->name, user2->name);
		write_syslog(mess, LOG_MUZZLE, 1);
	}
	else
	{
		if (!user2->muzzled)
		{
			sprintf(mess, "%s is not wearing a muzzle\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has removed your muzzle\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You remove the muzzle from %s\n", user2->name);

		sprintf(mess, "%s UNMUZZLED %s\n", this_user->name, user2->name);
		write_syslog(mess, LOG_MUZZLE, 1);
	}
	write_user(this_user, mess, MSG_FORCED);
	user2->muzzled = flag;
}


/*** Muzzle (prevent .shout/.semote) for a user ***/
void c_muzzle(void)
{
	muzzle_cmd(this_user, 1);
}


/*** Unmuzzle (allow .shout/.semote) for a user ***/
void c_unmuzzle(void)
{
	muzzle_cmd(this_user, 0);
}


void show_set_cmds_usage(USER_DATA *user)
{
static char *usage1 = "Usage: .set (";
static char *usage2 = "echo | wrap | paging | prompt) (on | off | yes | no)\n";
static char *usage3 = "     | .set (cols | rows) <number>\n";
#if	ALLOW_MTELLS
static char *usage4 = "     | .set mtell (add | remove) <username>\n";
#endif

	write_user(user, usage1, MSG_FORCED);
	if (!allow_bold)
		write_user(user, "bold |", MSG_FORCED);
	write_user(user, usage2, MSG_FORCED);
	write_user(user, usage3, MSG_FORCED);
#if	ALLOW_MTELLS
	write_user(user, usage4, MSG_FORCED);
#endif
}


/*** Set commands ***/
void c_set_cmds(void)
{
static char *want_boolean = "You must specify either on, off, yes, or no\n";
static char *set_options[] = {	"bold", "cols", "rows",
								"echo", "wrap", "paging", "prompt", NULL };
char option[8], option2[4];
int i;
int number;

	get_word(inpstr, option, sizeof(option));
	get_word(skip_word(inpstr), option2, sizeof(option2));

	i = choose(option, set_options);
	if (i == -1 || option2[0] == '\0')
	{
		show_set_cmds_usage(this_user);
		return;
	}

	switch (i)
	{
	case 0:
		if (!allow_bold)
		{
			show_set_cmds_usage(this_user);
			return;
		}
		if (strcmp(option2, "on") == 0 || toupper(option2[0]) == 'Y')
			this_user->use_bold = 1;
		else
		{
			if (strcmp(option2, "off") == 0 || toupper(option2[0]) == 'N')
				this_user->use_bold = 0;
			else
			{
				write_user(this_user, want_boolean, MSG_FORCED);
				return;
			}
		}
		sprintf(mess, "Highlighting is now %s\n", onoff[this_user->use_bold]);
		break;

	case 1:
		/* The only other options take a number as the second argument */
		number = atoi(option2);
		if (number < MIN_COLS || number > MAX_COLS)
			sprintf(mess, "The number of columns must be in the range of %d to %d\n", MIN_COLS, MAX_COLS);
		else
		{
			this_user->cols = number;
			sprintf(mess, "You set the number of columns on your screen to %d\n", this_user->cols);
		}
		break;

	case 2:
		/* The only other options take a number as the second argument */
		number = atoi(option2);
		if (number < MIN_ROWS || number > MAX_ROWS)
			sprintf(mess, "The number of rows must be in the range of %d to %d\n", MIN_ROWS, MAX_ROWS);
		else
		{
			this_user->rows = number;
			sprintf(mess, "You set the number of rows on your screen to %d\n", this_user->rows);
		}
		break;

	case 3:
		if (strcmp(option2, "on") == 0 || toupper(option2[0]) == 'Y')
			this_user->echo = 1;
		else
		{
			if (strcmp(option2, "off") == 0 || toupper(option2[0]) == 'N')
				this_user->echo = 0;
			else
			{
				write_user(this_user, want_boolean, MSG_FORCED);
				return;
			}
		}

#if	HONOUR_TELNET
		tnsetstat(this_user->tn, ECHOCHARS, this_user->echo);
#endif
		sprintf(mess, "Character echo is now %s\n", onoff[this_user->echo]);
		break;

	case 4:
		if (strcmp(option2, "on") == 0 || toupper(option2[0]) == 'Y')
			this_user->wrap = 1;
		else
		{
			if (strcmp(option2, "off") == 0 || toupper(option2[0]) == 'N')
				this_user->wrap = 0;
			else
			{
				write_user(this_user, want_boolean, MSG_FORCED);
				return;
			}
		}
		sprintf(mess, "Word wrap is now %s\n", onoff[this_user->wrap]);
		break;

	case 5:
		if (strcmp(option2, "on") == 0 || toupper(option2[0]) == 'Y')
			this_user->paging = 1;
		else
		{
			if (strcmp(option2, "off") == 0 || toupper(option2[0]) == 'N')
				this_user->paging = 0;
			else
			{
				write_user(this_user, want_boolean, MSG_FORCED);
				return;
			}
		}
		sprintf(mess, "Paging of output is now %s\n", onoff[this_user->paging]);
		break;

	case 6:
		if (strcmp(option2, "on") == 0 || toupper(option2[0]) == 'Y')
			this_user->prompt = 1;
		else
		{
			if (strcmp(option2, "off") == 0 || toupper(option2[0]) == 'N')
				this_user->prompt = 0;
			else
			{
				write_user(this_user, want_boolean, MSG_FORCED);
				return;
			}
		}
		sprintf(mess, "Prompt is now %s\n", onoff[this_user->prompt]);
		break;
	}

	write_user(this_user, mess, MSG_FORCED);
}


/*** send a tell to all Wiz and SU ***/
void c_wtell(void)
{
	int i;

	if (inpstr[0] == '\0')
	{
		write_user(this_user, "Usage: .wtell <message>\n", MSG_FORCED);
		return;
	}

	switch (inpstr[strlen(inpstr) - 1])
	{
	case '?':
		i = 0;
		break;
	case '!':
		i = 1;
		break;
	default:
		i = 2;
		break;
	}
	sprintf(mess, "^You %s all wiz:^ %s\n", tell_type1[i], inpstr);
	write_user(this_user, mess, MSG_FORCED);

	sprintf(mess, "^-> %s %s all wiz:^ %s\n", vis_user_name(this_user), tell_type2[i], inpstr);
	write_alluser(this_user, mess, NULL, 0, MSG_WTELL);
	record_wtell(mess);
}


/*** emote to all Wiz and SU ***/
void c_wemote(void)
{
	char *name;

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .wemote <text>\n", MSG_FORCED);
		return;
	}

	name = vis_user_name(this_user);

	/* write & record output */
	sprintf(mess, "^You emote to all wiz:^ %s %s\n", name, inpstr);
	write_user(this_user, mess, MSG_FORCED);

	sprintf(mess, "^-> To all wiz: %s %s^\n", name, inpstr);
	write_alluser(this_user, mess, NULL, 0, MSG_WTELL);
	record_wtell(mess);
}


/*** arrest a user and move them to the jail ***/
void c_arrest(void)
{
	char other_user[NAME_LEN];
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (other_user[0] == '\0')
	{
		write_user(this_user, "Usage: .arrest <user>\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why do you want to arrest yourself? Have you been bad?\n", MSG_FORCED);
		return;
	}
	if (user2->arrested)
	{
		sprintf(mess, "%s is already under arrest\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	if (this_user->level <= user2->level)
	{
		write_user(this_user, "That would not be wise!\n", MSG_FORCED);
		sprintf(mess, "%s tried to arrest you.\n", this_user->name);
		write_user(user2, mess, MSG_FORCED);
		return;
	}

	user2->arrested = 1;
	(void)save_userdata(user2);	/* Save user information in case they force a quit */

	sprintf(mess, "%s ARRESTED %s\n", this_user->name, user2->name);
	write_syslog(mess, LOG_ARREST, 1);

	sprintf(mess, "You have arrested %s\n", user2->name);
	write_user(this_user, mess, MSG_FORCED);

	if (user2->area != jail)	/* Just in case they are already in the */
	{							/* area that is being used as the jail. */
		sprintf(mess, "Two strange creatures magically appear and cart %s off to jail\n", vis_user_name(user2));
		write_alluser(user2, mess, user2->area, 0, MSG_SYSTEM);

		go_cmd(user2, jail, 1);
	}

	if (jail == NULL)
	{
		sprintf(mess, "Two creatures magically appear, shackle %s to the wall, and then disappear\n",
				vis_user_name(user2));
		write_alluser(user2, mess, user2->area, 0, MSG_SYSTEM);
	}
}


/*** unarrest a user and put them back in the first area ***/
void c_unarrest(void)
{
	char other_user[NAME_LEN];
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (other_user[0] == '\0')
	{
		write_user(this_user, "Usage: .unarrest <user>\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Huh?\n", MSG_FORCED);
		return;
	}
	if (!user2->arrested)
	{
		sprintf(mess, "%s is not under arrest\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	if (this_user->level <= user2->level)
	{
		write_user(this_user, "You can't unarrest a user of an equal or higher level than yourself\n", MSG_FORCED);
		return;
	}

	user2->arrested = 0;

	sprintf(mess, "%s UNARRESTED %s\n", this_user->name, user2->name);
	write_syslog(mess, LOG_ARREST, 1);

	sprintf(mess, "You unarrest %s\n", user2->name);
	write_user(this_user, mess, MSG_FORCED);

	if (user2->area != 0)	/* Just in case they are already in the */
	{						/* initial (ie. entrance or first) area */
		sprintf(mess, "Two strange creatures magically appear and dump %s on the ground\n", vis_user_name(user2));
		write_alluser(user2, mess, user2->area, 0, MSG_SYSTEM);

		go_cmd(user2, (AREA_DATA *)NodeData( NodeHead(astr) ), 1);
	}
}


/*** Remove all files belonging to a given user ***/
void c_nuke(void)
{
	char victim_name[NAME_LEN];
	char *user_name;
	USER_DATA *victim;
	char filename[80];

	/* Is user committing suicide? */
	if (inpstr == NULL)
		strcpy(victim_name, this_user->name);
	else
	{
		if (!inpstr[0])
		{
			write_user(this_user, "Usage: .nuke <user>\n", MSG_FORCED);
			return;
		}

		get_user_name(inpstr, victim_name, sizeof(victim_name));
	}

	victim = get_userdata(this_user, victim_name, 0);
	if (victim == NULL)
	{
		write_user(this_user, "There is no such user!\n", MSG_FORCED);
		return;
	}

	if (inpstr != NULL)	/* Just a regular nuke? */
	{
		strcpy(victim_name, victim->name);	/* Keep a copy of victims name */
		if (this_user == victim)
		{
			write_user(this_user, "That would be massive over kill if you are trying to commit suicide\n", MSG_FORCED);
			return;
		}

		if (this_user->level <= victim->level)
		{
			write_user(this_user, "Do you like living dangerously?\n", MSG_FORCED);
			sprintf(mess, "%s thought about nuking you\n", user_name);
			write_user(victim, mess, MSG_SYSTEM);
			return;
		}

		sprintf(mess, "%s drops a small atomic bomb and nukes %s\n",
				vis_user_name(this_user), victim_name);
		write_alluser(this_user, mess, victim->area, 0, MSG_SYSTEM);
	}

	/* We can't call user_quit() in case the user was committing suicide. */
	/* The call to logoff_user() sets the socket to -1 which prevents the */
	/* save_userdata() routine from save data for user after files wiped. */
	write_user(victim, "\n\nYour account has been removed\n", MSG_FORCED);
	logoff_user(victim);		/* We can't call user_quit() in case */
	victim->disconnect = 1;		/* the user was committing suicide.  */

	if (inpstr == NULL)
		sprintf(mess, "%s SUICIDED\n", victim_name);
	else
		sprintf(mess, "%s NUKED %s\n", this_user->name, victim_name);
	write_syslog(mess, LOG_NUKED, 1);

	sprintf(filename, "%s/%c/%s.D", USERDATADIR, victim_name[0], victim_name);
	unlink(filename);
	sprintf(filename, "%s/%c/%s.M", USERMAILDIR, victim_name[0], victim_name);
	unlink(filename);
	sprintf(filename, "%s/%c/%s.P", PROFILESDIR, victim_name[0], victim_name);
	unlink(filename);

	if (inpstr != NULL)
	{
		sprintf(mess, "You have removed the account of %s\n", victim_name);
		write_user(this_user, mess, MSG_FORCED);
	}
}


/* User wants to leave and does not plan to return */
void c_suicide(void)
{
	if (this_user->callback == NULL)
	{
		write_user(this_user, "This command will remove you from the talker and delete all of your files\n", MSG_FORCED);
		write_user(this_user, "Please enter your password to confirm: ", MSG_FORCED);
#if HONOUR_TELNET
		tnsetopt(this_user->tn, TNEcho, WEARE);
		tnsetstat(this_user->tn, ECHOCHARS, 0);	/* Do not echo passwords */
#else
		echo_off(this_user);
#endif
		this_user->callback = c_suicide;
	}
	else
	{
		this_user->callback = NULL;
#if HONOUR_TELNET
		/* Reset echo per user request */
		tnsetopt(this_user->tn, TNEcho, WEARENT);
		tnsetstat(this_user->tn, ECHOCHARS, this_user->echo);
#else
		echo_on(this_user);
#endif

		if (strcmp(this_user->passwd, crypt(inpstr, SALT)) != 0)
		{
			write_user(this_user, "Incorrect password!\n", MSG_FORCED);
			this_user->callback = NULL;
			return;
		}

		sprintf(mess, "%s is leaving and will not be coming back.\n",
				this_user->name);
		write_alluser(this_user, mess, this_user->area, 0, MSG_SYSTEM);
		inpstr = NULL;	/* Tell c_nuke() user is committing suicide */

		c_nuke();
	}
}


/*** Say something which is directed at a particular user ***/
/* This is useful if the area you are in has lots of users. */
void c_sayto(void)
{
	char other_user[NAME_LEN], type[15];
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	inpstr = skip_word(inpstr);
	if (other_user[0] == '\0' || inpstr[0] == '\0')
	{
		write_user(this_user, "Usage: .sayto <user> <message>\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Talking to yourself is the first sign of madness\n", MSG_FORCED);
		return;
	}
	if (user2->area != this_user->area)
	{
		sprintf(mess, "^%s isn't here^\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}
	if ((user2->which_msgs & MSG_TALK) == 0)
	{
		sprintf(mess, "^%s isn't listening to the general gossip^\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}
	if (get_ignore(user2, this_user))
	{
		if (show_user_ign)
		{
			sprintf(mess, "%s is ignoring you!^\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		return;
	}
	if (user2->afk)
	{
		sprintf(mess, "^%s is AFK^\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
	}

	switch (inpstr[strlen(inpstr) - 1])
	{
	case '?':
		strcpy(type, "asks");
		break;
	case '!':
		strcpy(type, "exclaims to");
		break;
	default:
		strcpy(type, "says to");
		break;
	}
	sprintf(mess, "%s %s %s: %s\n", vis_user_name(this_user), type, user2->name, inpstr);
	write_user(this_user, mess, MSG_TALK);
	write_alluser(this_user, mess, this_user->area, 0, MSG_TALK);
	record_say(this_user->area, mess);
}


/*** indicate something that the user is thinking ***/
void c_think(void)
{
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .think <text>\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "%s thinks . o O ( %s )\n", vis_user_name(this_user), inpstr);

/* write & record output */
	write_alluser(this_user, mess, this_user->area, 1, MSG_TALK);
	record_say(this_user->area, mess);
}


/*** privately indicate something that the user is thinking ***/
void c_pthink(void)
{
	char other_user[NAME_LEN];
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	inpstr = skip_word(inpstr);
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .pthink <user> <thought>\n", MSG_FORCED);
		return;
	}
	if (this_user->gagged)
	{
		write_user(this_user, "You can't do that at the moment.\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why would you want to think at yourself?\n", MSG_FORCED);
		return;
	}
	if ( (user2->which_msgs & MSG_TELL) == 0 )
	{
		sprintf(mess, "%s is ignoring tells^\n", other_user);
		write_user(this_user, mess, MSG_FORCED);
	}
	if (user2->afk)
	{
		sprintf(mess, "^%s is AFK^\n", other_user);
		write_user(this_user, mess, MSG_FORCED);
	}
	sprintf(mess, "^You think to %s . o O ( %s )^\n", user2->name, inpstr);
	write_user(this_user, mess, MSG_FORCED);
	record_tell(this_user, mess);

	/* If user2 is ignoring this user, don't send the emote */
	if (get_ignore(user2, this_user))
	{
		if (show_user_ign)
		{
			sprintf(mess, "%s is ignoring you!^\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
		}
		return;
	}

	sprintf(mess, "^-> %s thinks . o O ( %s )^\n", vis_user_name(this_user), inpstr);
	write_user(user2, mess, MSG_TELL);
	record_tell(user2, mess);
}


/*** Go to the same area as another user ***/
void c_join(void)
{
	USER_DATA *user2;
	char other_user[NAME_LEN];

	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .join <user>\n", MSG_FORCED);
		return;
	}

	get_user_name(inpstr, other_user, sizeof(other_user));
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;

	if (user2 == this_user)
	{
		write_user(this_user, "You are already with yourself\n", MSG_FORCED);
		return;
	}

	if (this_user->area == user2->area)
	{
		sprintf(mess, "You are already with %s\n", user2->name);
		write_user(this_user, mess, MSG_FORCED);
		return;
	}

	/* Pretend areas are adjacent */
	go_cmd(this_user, user2->area, 0);
}


/*** Gag or ungag a user ***/
/* Prevents/allows .shout, .semote, and speech */
void gag_cmd(user, flag)
USER_DATA *user;
int flag;
{
	char other_user[NAME_LEN];
	char *name;
	USER_DATA *user2;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (!inpstr[0])
	{
		write_user(this_user, "You must specify a users name!\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why would you want to gag yourself?\n", MSG_FORCED);
		return;
	}

	name = vis_user_name(this_user);
	if (flag)
	{
		/* see if user to be gag is of a higher level */
		if (this_user->level <= user2->level)
		{
			write_user(this_user, "Hmm...I don't think you really want to do that\n", MSG_FORCED);
			sprintf(mess, "%s thought about gagging you\n", this_user->name);
			write_user(user2, mess, MSG_SYSTEM);
			return;
		}

		if (user2->gagged)
		{
			sprintf(mess, "%s has already been gagged\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has gagged you\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You put a gag on %s\n", user2->name);

		sprintf(mess, "%s GAGGED %s\n", this_user->name, user2->name);
		write_syslog(mess, LOG_GAG, 1);
	}
	else
	{
		if (!user2->gagged)
		{
			sprintf(mess, "%s is not wearing a gag\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has removed your gag\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You remove the gag from %s\n", user2->name);

		sprintf(mess, "%s UNGAGGED %s\n", this_user->name, user2->name);
		write_syslog(mess, LOG_GAG, 1);
	}
	write_user(this_user, mess, MSG_FORCED);
	user2->gagged = flag;
}


/*** Gag (prevent .shout/.semote/speech) for a user ***/
void c_gag(void)
{
	gag_cmd(this_user, 1);
}


/*** Ungag (allow .shout/.semote/speech) for a user ***/
void c_ungag(void)
{
	gag_cmd(this_user, 0);
}


/*** View the system log file ***/
void c_viewlog(void)
{
#if	LOG_MULTI_FILES
	static char *log_files[] = { "errors", "misc", "boot", "newusers",
									"auth", "admin", NULL };
	int log;
#if	LOG_DAILY_FILES
	static char *days_of_week[] = { "monday", "tuesday", "wednesday",
									"thursday", "friday", "saturday",
									"sunday", NULL };
	int day;
#endif
#endif
	char *s, word[20], filename[40];
	int lines, cnt;
	FILE *fp;

	s = inpstr;
#if	!LOG_MULTI_FILES
	strcpy(filename, SYSTEM_LOG);
#else
	get_word(s, word, sizeof(word));
	log = choose(word, log_files);
	if (*s == '\0' || log == -1)
	{
		write_user(this_user, "Which log file do you want to examine?\n", MSG_FORCED);
		write_user(this_user, "Available files are:", MSG_FORCED);
		for (log = 0; log_files[log] != NULL; ++log)
		{
			sprintf(mess, " %s", log_files[log]);
			write_user(this_user, mess, MSG_FORCED);
		}
		write_user(this_user, "\n\n", MSG_FORCED);
		return;
	}
	s = skip_word(s);
#if	!LOG_DAILY_FILES
	sprintf(filename, "%s/%s", LOGDIR, log_files[log]);
#else
	get_word(s, word, sizeof(word));
	day = choose(word, days_of_week);
	if (*s == '\0' || day == -1)
	{
		write_user(this_user, "Which days log do you want to examine?\n\n", MSG_FORCED);
		return;
	}
	s = skip_word(s);
	sprintf(filename, "%s/%c%.2s/%s", LOGDIR,
			toupper(days_of_week[day][0]), &days_of_week[day][1], log_files[log]);
#endif
#endif

	lines = atoi(s);
	if (lines <= 0)
	{
		if (*s)
		{
#if	!LOG_MULTI_FILES
			write_user(this_user, "Usage: viewlog [<lines from the end>]\n", MSG_FORCED);
#else
#if	!LOG_DAILY_FILES
			write_user(this_user, "Usage: viewlog <log file> [<lines from the end>]\n", MSG_FORCED);
#else
			write_user(this_user, "Usage: viewlog <log file> <day of week> [<lines from the end>]\n", MSG_FORCED);
#endif
#endif
			return;
		}

		this_user->file_posn = 0L;
	}
	else
	{	/* Count total lines in log file */
		cnt = messcount(filename);
		if (cnt < lines)
		{
			sprintf(mess, "There are only %d lines in the log.\n", cnt);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		/* Find the start of the first line to show */
		cnt -= lines;	/* Number of lines to skip */
		fp = fopen(filename, "r");
		while (!feof(fp) && cnt > 0)
		{
			fgets(mess, sizeof(mess), fp);
			--cnt;
		}
		this_user->file_posn = ftell(fp);
		fclose(fp);
	}

#if	!LOG_MULTI_FILES
	if (lines <= 0 || cnt == lines)
		write_user(this_user, "\n*** System log ***\n", MSG_FORCED);
	else
		sprintf(mess, "\n*** System log (last %d lines) ***\n", lines);
#else
	if (lines <= 0 || cnt == lines)
		sprintf(mess, "\n*** System log %s ***\n", filename);
	else
		sprintf(mess, "\n*** System log %s (last %d lines) ***\n", filename, lines);
	write_user(this_user, mess, MSG_FORCED);
#endif
	if ( more(this_user, filename) == MORE_NO_FILE )
		write_user(this_user, "That system log file is empty.\n\n", MSG_FORCED);
}


/*** Stun or unstun a user ***/
/* Prevents/allows use of any commands by a user */
void stun_cmd(user, flag)
USER_DATA *user;
int flag;
{
	char other_user[NAME_LEN];
	USER_DATA *user2;
	char *name;

	get_user_name(inpstr, other_user, sizeof(other_user));
	if (!inpstr[0])
	{
		write_user(this_user, "You must specify a users name!\n", MSG_FORCED);
		return;
	}
	if ((user2 = find_userdata(this_user, other_user, 0, 1)) == NULL)
		return;
	if (user2 == this_user)
	{
		write_user(this_user, "Why would you want to stun yourself?\n", MSG_FORCED);
		return;
	}

	name = vis_user_name(this_user);
	if (flag)
	{
		/* see if user to be stunned is of a higher level */
		if (this_user->level <= user2->level)
		{
			write_user(this_user, "Hmm...I don't think you really want to do that\n", MSG_FORCED);
			sprintf(mess, "%s thought about stunning you\n", this_user->name);
			write_user(user2, mess, MSG_SYSTEM);
			return;
		}

		if (this_user->stun)
		{
			sprintf(mess, "%s has already been stunned\n", user2->name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has stunned you\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You stun %s\n", user2->name);

		sprintf(mess, "%s STUNNED %s\n", user->name, user2->name);
		write_syslog(mess, LOG_STUN, 1);
	}
	else
	{
		if (!user2->stun)
		{
			sprintf(mess, "%s is not currently stunned\n", user2->name);
			write_user(user, mess, MSG_FORCED);
			return;
		}
		sprintf(mess, "%s has unstunned you\n", name);
		write_user(user2, mess, MSG_FORCED);
		sprintf(mess, "You unstunned %s\n", user2->name);

		sprintf(mess, "%s UNSTUNNED %s\n", this_user->name, user2->name);
		write_syslog(mess, LOG_STUN, 1);
	}
	write_user(this_user, mess, MSG_FORCED);
	user2->stun = flag;
}


/*** Stun (prevent use of any commands) for a user ***/
void c_stun(void)
{
	stun_cmd(this_user, 1);
}


/*** Unstun (allow use of any commands) for a user ***/
void c_unstun(void)
{
	stun_cmd(this_user, 0);
}


void c_freeze(void)
{
	static char *options[] = { "forever", "unfreeze", "status", NULL };
	char victim_name[NAME_LEN], str2[10];
	char *user_name;
	USER_DATA *victim;
	time_t time_val;
	int option;

	get_user_name(inpstr, victim_name, sizeof(victim_name));
	get_word(skip_word(inpstr), str2, sizeof(str2));
	option = choose(str2, options);

	if (victim_name[0] == '\0' || (option == -1 && !isdigit(str2[0])) )
	{
		write_user(this_user, "Usage: .freeze <user> <number of days>\n", MSG_FORCED);
		write_user(this_user, "     | .freeze <user> forever\n", MSG_FORCED);
		write_user(this_user, "     | .freeze <user> unfreeze\n", MSG_FORCED);
		write_user(this_user, "     | .freeze <user> status\n", MSG_FORCED);
		return;
	}

	victim = get_userdata(this_user, victim_name, 0);
	if (victim_name == NULL)
	{
		write_user(this_user, "There is no such user!\n", MSG_FORCED);
		return;
	}

	strcpy(victim_name, victim->name);	/* Keep a copy of victims name */

	user_name = vis_user_name(this_user);

	switch (option)
	{
	case -1:
	case 0:
		if (this_user == victim)
		{
			write_user(this_user, "Why would you want to freeze your own account?\n", MSG_FORCED);
			return;
		}

		/* see if account to be frozen is of a higher level */
		if (this_user->level <= victim->level)
		{
			write_user(this_user, "Hmm...I don't think you really want to do that\n", MSG_FORCED);
			if (victim->sock != -1)
			{
				sprintf(mess, "%s thought about freezing you\n", this_user->name);
				write_user(victim, mess, MSG_SYSTEM);
			}
			return;
		}

		if (victim->freeze_time != 0)
		{
			sprintf(mess, "The account of %s has already been frozen\n", victim_name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		if (option == 0)
		{
			victim->freeze_time = -1;
			sprintf(mess, "You have frozen the account of %s forever\n", victim_name);
			write_user(this_user, mess, MSG_SYSTEM);
			sprintf(mess, "%s FREEZES account of %s forever\n",
					this_user->name, victim_name);
		}
		else
		{
			victim->freeze_time = atoi(str2);
			sprintf(mess, "You have frozen the account of %s for %d days\n",
					victim_name, victim->freeze_time);
			write_user(this_user, mess, MSG_SYSTEM);
			sprintf(mess, "%s FREEZES account of %s for %d days\n",
					this_user->name, victim_name, victim->freeze_time);
		}
		write_syslog(mess, LOG_FREEZE, 1);

		if (victim->sock == -1)
			(void)save_userdata(victim);
		else
		{
			sprintf(mess, "%s has frozen you\n", user_name);
			write_user(victim, mess, MSG_FORCED);
			user_quit(victim);	/* This saves the userdata info */
		}
		break;

	case 1:
		if (this_user == victim)
		{
			write_user(this_user, "Your account isn't frozen or else you would not be here right now\n", MSG_FORCED);
			return;
		}

		if (victim->freeze_time == 0)
		{
			sprintf(mess, "The account of %s has is not frozen\n", victim_name);
			write_user(this_user, mess, MSG_FORCED);
			return;
		}

		victim->freeze_time = 0;
		(void)save_userdata(victim);

		sprintf(mess, "You unfreeze the account of %s\n", victim_name);
		write_user(this_user, mess, MSG_FORCED);
		sprintf(mess, "%s UNFREEZES account of %s\n", this_user->name, victim_name);
		write_syslog(mess, LOG_FREEZE, 1);
		break;

	case 2:
		switch (victim->freeze_time)
		{
		case -1:
			sprintf(mess, "The account of %s is frozen forever\n", victim_name);
			break;

		case 0:
			sprintf(mess, "The account of %s is not frozen\n", victim_name);
			break;

		default:
			time_val = user_frozen(victim);
			sprintf(mess, "The account of %s is frozen until %s",
					victim_name, ctime(&time_val));
			break;
		}
		write_user(this_user, mess, MSG_SYSTEM);
		break;
	}
}

#if	PORT_WHO
/*** Search port who files to find a user ***/
void c_find(void)
{
	static char *options[] = { "user", "level", NULL };
	char *s, word[20], temp_name[80], filename[80], match[40];
	FILE *pagefile = NULL, *whofile = NULL;
	DIR *whodir = NULL;
	struct dirent *nextfile;
	unsigned int port = 0;
	int i, ports = 0, matches = 0, option;
	int level_to_find, level;

	get_word(inpstr, word, sizeof(word));
	option = choose(word, options);
	get_user_name(skip_word(inpstr), word, sizeof(word));
	if (option == -1 || word[0] == '\0')
	{
		write_user(this_user, "Usage: .find user <username>\n", MSG_FORCED);
		write_user(this_user, "     | .find level <level>\n", MSG_FORCED);
		return;
	}

	if (option == 1)	/* Looking for a user level? */
	{
		strupcase(word);
		level_to_find = choose(word, levstr);
		if (level_to_find == -1)
		{
			write_user(this_user, "You specified an invalid user level\n", MSG_FORCED);
			return;
		}
	}
	
	if (tmpnam(temp_name) == NULL)
	{
		write_user(this_user, "Sorry - Couldn't create name for temporary file", MSG_FORCED);
		write_syslog("ERROR: Couldn't create name for temporary file in c_find()\n", LOG_ERROR, 1);
		return;
	}

	if ((pagefile = fopen(temp_name, "w")) == NULL)
	{
		write_user(this_user, "Sorry, unable to open a temporary page file\n", MSG_FORCED);
		return;
	}

	if ((whodir = opendir(TMPDIR)) == NULL)
	{
		write_user(this_user, "Sorry, unable to locate any other talker ports\n", MSG_FORCED);
		fclose(pagefile);
		unlink(temp_name);
	}

	fprintf(pagefile, "\n*** Searching for %s %s ***\n\n",
			options[option], option ? levstr[level_to_find] : word);

	while ((nextfile = readdir(whodir)) != NULL)
	{
		if (strncmp(nextfile->d_name, "who.", 4) != 0)
			continue;

		port = atol(&nextfile->d_name[4]);
		if (port < MIN_PORT || port > MAX_PORT)
			continue;

		sprintf(filename, "%s/who.%u", TMPDIR, port);
		if ((whofile = fopen(filename, "r")) == NULL)
			continue;

		fgets(mess, sizeof(mess) - 1, whofile);
		while (!feof(whofile))
		{
			s = skip_blanks(mess);
			if (*s == '\0')
				break;

#if	BIRDDOG_FIND
			s = skip_word(s);	/* skip area name */
			if (s[0] == '[')	/* level name? */
			{
				if (option)
				{	/* find by level */
					get_word(&s[1], match, sizeof(match));
					match[ strlen(match) - 1 ] = '\0';
					level = choose(match, levstr);
					if (level == level_to_find)
						i = 0;
					else
						i = -1;
				}
				else	/* Looking for user by name */
				{
					s = skip_word(s);
					get_user_name(s, match, sizeof(match));
					if (strcmp(word, match) == 0)
						i = 0;
					else
						i = -1;
				}
			}
			else if (option == 1)
			{
				fgets(mess, sizeof(mess) - 1, whofile);
				continue;		/* level and no info available */
			}
#else
			if (option)
			{
				s = strchr(mess, ':') + 2;
				get_word(s, match, sizeof(match));
				level = choose(match, levstr);
				if (level == level_to_find)
					i = 0;
				else
					i = -1;
			}
			else
			{
				get_user_name(s, match, sizeof(match));
				if (strcmp(word, match) == 0)
					i = 0;
				else
					i = -1;
			}
#endif
			if (i != -1)
			{
				fprintf(pagefile, "%d: %s", port, mess);
				++matches;
			}

			fgets(mess, sizeof(mess) - 1, whofile);
		}
		fclose(whofile);
		++ports;
	}

	closedir(whodir);

	fprintf(pagefile, "\nTotal of %d %s found; %d %s searched\n",
			matches, (matches == 1) ? "match" : "matches",
			ports, (ports == 1) ? "port" : "ports");
	fclose(pagefile);

	this_user->tmpfile = 1;
	(void)more(this_user, temp_name);
}
#endif


void snapshot_init_section(FILE *fp)
{
int i;
int *var;

	fprintf(fp, "%s\n", INIT_HEADER);

	/* Output strings which specify user levels */
	for (i = 0; i < MAX_LEVEL; ++i)
		fprintf(fp, "level%d %s\n", i, levstr[i]);

	/* Output global initialization data */
	for (i = 0; global_data[i].word != NULL; ++i)
	{
		var = global_data[i].var;
		if (global_data[i].var == NULL)	/* Don't output level strings */
			continue;

		fprintf(fp, "%s ", global_data[i].word);

		switch (global_data[i].var_type)
		{
		case Bool:
			fprintf(fp, "%s\n", yesno[*var]);
			break;

		case Int:
			fprintf(fp, "%d\n", (int)*var);
			break;

		case Uint:
			fprintf(fp, "%u\n", (unsigned int)*var);
			break;

		case Level:
			fprintf(fp, "%s\n", levstr[*var]);
			break;

		case Levstr:	/* Level strings have already been output */
			break;
		}
	}

	fprintf(fp, "\n");
}


void snapshot_areas_section(FILE *fp)
{
Node *area_node;
Node *move_node;
AREA_DATA *area;
AREA_DATA *link;
int status;

	fprintf(fp, "%s\n", AREAS_HEADER);

	area_node = NodeHead(astr);
	while (!isEndOfList(astr, area_node))
	{
		area = (AREA_DATA *)NodeData(area_node);
		area_node = NodeNext(area_node);

		fprintf(fp, "%s %s ", area->label, area->name);

		if (area == jail)
			status = AREA_STATUS_JAIL;
		else
		{
			status = area->status;
			if (area->wiz_only)
				status += AREA_STATUS_WIZ_FIXED;
		}
		fprintf(fp, "%s %c",
				areas_status[status],
				tolower(yesno[area->searchable][0]));

		move_node = NodeHead(area->move);
		while (!isEndOfList(area->move, move_node))
		{
			link = (AREA_DATA *)NodeData(move_node);
			move_node = NodeNext(move_node);

			fprintf(fp, " %s", link->label);
		}

		fprintf(fp, "\n");
	}

	fprintf(fp, "\n");
}


void snapshot_topics_section(FILE *fp)
{
Node *area_node;
AREA_DATA *area;

	fprintf(fp, "%s\n", TOPICS_HEADER);

	area_node = NodeHead(astr);
	while (!isEndOfList(astr, area_node))
	{
		area = (AREA_DATA *)NodeData(area_node);
		area_node = NodeNext(area_node);

		/* Only output a topic line if area has a topic */
		if (area->topic[0] != '\0')
			fprintf(fp, "%s %s\n", area->label, area->topic);
	}

	fprintf(fp, "\n");
}


/*** Create a snapshot of the current state of the talker. ***/
/*** This includes all values shown in system status, area ***/
/*** information and topics. This information is written to***/
/*** a file which could be used as a new init_data file.   ***/
/*** This routine can be called from the alarm timer code. ***/
void do_snapshot(void)
{
FILE *fp;

	fp = fopen(SNAPSHOT_FILE, "w");
	if (fp == NULL)
	{	
		write_user(this_user, "Unable to create snapshot file\n", MSG_FORCED);
		return;
	}

	snapshot_init_section(fp);
	snapshot_areas_section(fp);
	snapshot_topics_section(fp);
	fclose(fp);
}


/*** Create a snapshot of the current state of the talker. ***/
void c_snapshot(void)
{
	write_user(this_user, "Creating snapshot file...\n", MSG_FORCED);

	do_snapshot();

	write_user(this_user, "Finished creating snapshot file.\n", MSG_FORCED);
}


/*** Indicate that the user is singing ***/
void c_sing(void)
{
	if (!inpstr[0])
	{
		write_user(this_user, "Usage: .sing <text>\n", MSG_FORCED);
		return;
	}
	sprintf(mess, "%s sings o/~ %s o/~\n", vis_user_name(this_user), inpstr);

/* write & record output */
	write_alluser(this_user, mess, this_user->area, 1, MSG_TALK);
	record_say(this_user->area, mess);
}


/***************************** EVENT FUNCTIONS *****************************/

/*** check to see if messages are out of date ***/
/* This routine doesn't take leap years in to   */
/* account. Messages written on Feb 29th of a   */
/* leap year will stay on the board a day longer*/
/* than the time specified by 'message_life'.   */
int day_of_year(int month, int day_of_month)
{
	static int days_in_month[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
	int i, age;

	age = day_of_month;
	for (i = 0; i < month; ++i)
		age += days_in_month[i];

	return age;
}


/*** check to see if messages are out of date ***/
void expire_messages(void)
{
	char line[ARR_SIZE + 1], boardfile[40], tempfile[20];
	struct tm *time_now;
	int day_number;
	int day, month;
	int message_day;
	int message_age;
	int message_cnt;
	time_t now;
	FILE *bfp, *tfp;
	Node *node;
	AREA_DATA *area;

	time(&now);
	time_now = localtime(&now);
	day_number = day_of_year(time_now->tm_mon, time_now->tm_mday);

/* cycle through files */
	if (tmpnam(tempfile) == NULL)
	{
		write_syslog("ERROR: Couldn't create name for temporary file in expire_messages()\n", LOG_ERROR, 1);
		return;
	}

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		sprintf(boardfile, "%s/%s", MESSDIR, area->name);
		if ((bfp = fopen(boardfile, "r")) == NULL)
			continue;

		if ((tfp = fopen(tempfile, "w")) == NULL)
		{
			write_syslog("ERROR: Couldn't open temp file to write in expire_messages()\n", LOG_ERROR, 1);
			fclose(bfp);
			return;
		}

		message_cnt = 0;

		/* Go through message board and copy messages to temp file */
		fgets(line, sizeof(line), bfp);
		while (!feof(bfp))
		{
			if (line[0] != '[')		/* Don't expire permanent messages */
			{
				line[4] = '\0';
				month = choose(&line[1], months);
				day = atoi(&line[5]);
				message_day = day_of_year(month, day);
				message_age = day_number - message_day;
				if (message_age < 0)
					message_age += 365;
			}

			/* Keep message if its permanent or is not too old */
			if (line[0] != '[' && message_age > message_life)
				--area->mess_num;
			else
			{
				line[4] = ' ';
				line[7] = ' ';
				fputs(line, tfp);
			}
			fgets(line, sizeof(line), bfp);
			++message_cnt;
		}
		fclose(bfp);
		fclose(tfp);

		/* rename temp file to boardfile */
		if (file_copy(tempfile, boardfile) == 0)
		{
			/* Update number of messages on message board for this area */
			area->mess_num = message_cnt;
		}
		else
		{
			sprintf(line, "ERROR: Couldn't copy temp file to %s in expire_messages()\n", boardfile);
			write_syslog(line, LOG_ERROR, 1);
		}
		unlink(tempfile);
	}
}


/*** Deal with users who are idling.  ***/
/*** This routine is typically called ***/
/*** once every 30 seconds.			  ***/
void check_timeout(void)
{
	static int timer_toggle = 1;
	char buff[80];
	time_t now;
	Node *node;
	USER_DATA *user;
	int secs, minutes_left;

	time(&now);

	node = NodeHead(ulist);
	while (!isEndOfList(ulist, node))
	{
		user = (USER_DATA *)NodeData(node);
		node = NodeNext(node);

		/* In case node doesn't have valid user info because  */
		/* user is still being set up or we are in user_quit()*/
		if (user->sock == -1)
			continue;

		/* Calculate number of seconds since last input */
		secs = (int)(now - user->last_input);

		if (user->logging_in != LOGIN_DONE)	/* Is user logging in? */
		{	/* Deal with a time out while the user is logging in */
#if	!DEBUG_TALKER
			if (secs >= login_timeout)
			{
				write_user(user, "\n\nLogin timed out\n\n", MSG_FORCED);

				/* If we are processing any user, it is not advisable */
				/* to call user_quit() on the off chance that the node*/
				/* removed is for the current user or being used in a */
				/* command issued by the current user.				  */
				if (this_user != NULL)
					user->disconnect = 1;
				else
					user_quit(user);
			}
#endif
			continue;
		}

		/* timer_toggle halves the speed of everything below */
		timer_toggle ^= 1;
		if (!timer_toggle)
			continue;

		secs /= 60;		/* Convert idle time to minutes */

		/* Don't do checks for idle user if enough time hasn't	*/
		/* passed yet. If no idle mention is to be given (ie.	*/
		/* idle_mention is 0) following checks WILL be done.	*/
		if (secs < idle_mention)
			continue;

		if (user->idle_mention == 0)
		{
			/* Save when to start auto-logout warnings for this user */
			user->idle_mention = idle_warning;

			if (idle_mention > 0)
			{
				write_user(user, "Your eyes glaze over...\n", MSG_SYSTEM);
				if (user->vis)
					sprintf(buff, "%s's eyes glaze over...\n", user->name);
				else
					strcpy(buff, "Someones eyes glaze over...\n");
				write_alluser(user, buff, user->area, 0, MSG_SYSTEM);
			}
		}	/* Fall through to auto-logout warning checks */

		if (idle_logout > 0)
		{
			/* Don't auto-log out a user if their level is high enough */
			if (user->level >= no_logout_lvl)
				continue;

			if (secs >= idle_logout)
			{
				write_user(user, "\n\nYou have been idling too long. Goodbye!\n\n", MSG_FORCED);
				user->disconnect = 1;
				continue;
			}

			/* Only give auto-logout warning if enabled and idling mention was given */
			if (idle_warning > 0 && user->idle_mention > 0)
			{
				if (secs >= user->idle_mention)
				{
					minutes_left = idle_logout - secs;
					if (minutes_left == 1)
						write_user(user, "\n\07^*** 1 minute to auto-logout ***^\07\n\n", MSG_SYSTEM);
					else
					{
						if (minutes_left <= 5)
							++user->idle_mention;			/* Next warning in 1 minute */
						else
						{	/* At least 5 minutes left before final 5 minutes? */
							if (minutes_left >= 10)
								user->idle_mention += 5;	/* Next warning in 5 minutes */
							else
								user->idle_mention = idle_logout - 5;	/* Countdown last 5 minutes */
						}
						sprintf(buff, "\n\07^*** %d minutes to auto-logout ***^\07\n\n", minutes_left);
						write_user(user, buff, MSG_SYSTEM);
					}
				}
			}
		}	/* end of auto-logout checks */
	}
}


/*** Display random messages (atmosphere) to users in areas ***/
void atmospherics(void)
{
	static int atmos_toggle = 1;
	FILE *fp;
	char filename[80], probch[10], line[81];
	int probint;
	Node *node;
	AREA_DATA *area;

	/* atmos_timer_toggle halves the speed of everything below */
	atmos_toggle ^= 1;
	if (!atmos_toggle)
		return;

	node = NodeHead(astr);
	while (!isEndOfList(astr, node))
	{
		area = (AREA_DATA *)NodeData(node);
		node = NodeNext(node);

		if (find_num_in_area(area) == 0)
			continue;

		sprintf(filename, "%s/%s", ATMOSDIR, area->name);
		if ((fp = fopen(filename, "r")) == NULL)
			continue;

		/* probint is num. between 0 - 100 (hopefully) */
		fgets(probch, sizeof(probch), fp);
		while (!feof(fp))
		{
			probint = atoi(probch);
			fgets(line, sizeof(line), fp);
			if (rand() % 100L < (long)probint)
			{
				write_alluser(NULL, line, area, 1, MSG_ATMOS);
				break;
			}
			fgets(probch, sizeof(probch), fp);
		}
		fclose(fp);
	}
}


/***************************** SIGNAL HANDLERS *****************************/

/*** handler for various signals ***/
void signal_handler(int which_signal)
{
#if	NEW_SOCKET_IO
	char buff[80];
#endif

	signal(which_signal, SIG_IGN);

	switch (which_signal)
	{
	case SIGHUP:		/* Restart the talker */
		break;

	case SIGTERM:
		shutd = NULL;
		do_shutdown();	/* This function does not return */
		break;

#if	NEW_SOCKET_IO
	case SIGPIPE:
		which_user->sock_err = 1;

		write_syslog("ERROR: Got a SIGPIPE signal - ", LOG_ERROR_FILE, 1);

		if (which_user->logging_in == LOGIN_GET_NAME)
			strcpy(buff, "user was logging in\n");
		else
			sprintf(buff, "which_user->name = '%s', logging_in = %d\n",
					which_user->name, which_user->logging_in);
		write_syslog(buff, LOG_ERROR_FILE, 0);
		break;
#endif
	}

	signal(which_signal, signal_handler);
}


/*** handler for alarm timer ***/
void alarm_handler(int which_signal)
{
	static int maintenance = 0;	/* Are we doing system maintenance? */
	time_t now;
	struct tm *time_now;

	signal(which_signal, SIG_IGN);

	time(&now);
	time_now = localtime(&now);

	/* This check gives us a one hour period to re-enable checking in the */
	/* extremely unlikely event it takes 1 hour 59 minutes to do checks.  */
	if (time_now->tm_hour == 1)
		maintenance = 0;
	else
	{
		/* If we haven't already just run the system checks and its	*/
		/* now midnight it is time to do the daily system checks.	*/
		if (!maintenance && time_now->tm_hour == 0 && time_now->tm_min == 0)
		{
			maintenance = 1;	/* Routine checks have been done for today */

			if (num_of_users > 0)
			{
				write_alluser(NULL,
						"\n^*** Performing routine system maintenance ***\n",
						NULL, 1, MSG_SYSTEM);
			}

			do_snapshot();		/* Snapshot the talkers layout and status */
			expire_messages();	/* Expire messages from message boards */

			if (num_of_users > 0)
			{
				write_alluser(NULL,
						"^*** Completed routine system maintenance ***\n\n",
						NULL, 1, MSG_SYSTEM);
			}
		}
	}

	check_timeout();
	if (atmos_on && num_of_users > 0)
		atmospherics();

	signal(which_signal, alarm_handler);
	reset_heartbeat();
}
