/* This header file is used by the file which contains */
/* the routines which implement a doubly linked list.  */

#define	NodeHead(list)				(list->head)
#define	NodeTail(list)				(list->tail)

#define	NodeData(node)				(node->data)
#define	NodeNext(node)				(node->next)
#define	NodePrev(node)				(node->prev)

#define	NodeAddHead(list, new_node)	NodeAdd( (Node *)list, new_node )
#define	NodeAddHeadNew(list, data)	NodeAddNew( (Node *)list, data )
#define	NodeAddTail(list, new_node)	NodeAdd( NodeTail(list), new_node )
#define	NodeAddTailNew(list, data)	NodeAddNew( NodeTail(list), data )

#define	NodeRemHead(list)			NodeRemove( NodeHead(list) )
#define	NodeRemTail(list)			NodeRemove( NodeTail(list) )

#define	isEndOfList(list, node)		(node == (Node*)list)

typedef void Data;

typedef struct node {
	struct node *next;
	struct node *prev;
	Data *data;
} Node;

typedef struct list {
	Node *head;
	Node *tail;
} List;

void NodeAdd(Node *, Node *);
Node *NodeAddNew(Node *, Data *);
Node *NodeRemove(Node *);
void NodeDestroy(Node *);
Node *NodeFind(List *, Data *);

List *ListCreate(void);
void ListRemAll(List *);
void ListDestroy(List *);
