#ifndef BD_TELNET_H
#define BD_TELNET_H 1

/*** Telnet Command codes ***/
#define TCSE	240	/* end subnegotiation	*/
#define TCNOP	241	/* no operation		*/
#define TCDM	242	/* data mark		*/
#define TCBRK	243	/* NVT BRK character	*/
#define TCIP	244	/* interrupt process	*/
#define TCAO	245	/* abort output		*/
#define TCAYT	246	/* are you there?	*/
#define TCEC	247	/* erase character	*/
#define TCEL	248	/* erase line		*/
#define TCGA	249	/* go ahead		*/
#define TCSB	250	/* start subnegotiation	*/
#define TCWILL	251	/* WILL	*/
#define TCWONT	252	/* WONT	*/
#define TCDO	253	/* DO	*/
#define TCDONT	254	/* DONT	*/
#define TCIAC	255	/* interpret as command	*/

/*** network Virtual Printer control codes ***/
#define VPLF	'\n'	/* line feed		*/
#define VPCR	'\r'	/* carriage return	*/
#define VPBEL	'\a'	/* attention		*/
#define VPBS	'\b'	/* backspace		*/
#define VPHT	'\t'	/* horizontal tab	*/
#define VPVT	'\v'	/* vertical tab		*/
#define VPFF	'\f'	/* form feed		*/

/* Telnet LINEMODE codes */
#define LM_MODE		1
#define		LM_EDIT		1
#define		LM_TRAPSIG	2
#define		LM_MODE_ACK	4
#define		LM_SOFT_TAB	8
#define		LM_LIT_ECHO	16
#define LM_FORWARDMASK	2
#define LM_SLC		3
#define		LM_SLC_SYNCH	1
#define		LM_SLC_BRK	2
#define		LM_SLC_IP	3
#define		LM_SLC_AO	4
#define		LM_SLC_AYT	5
#define		LM_SLC_EOR	6
#define		LM_SLC_ABORT	7
#define		LM_SLC_EOF	8
#define		LM_SLC_SUSP	9
#define		LM_SLC_EC	10
#define		LM_SLC_EL	11
#define		LM_SLC_EW	12
#define		LM_SLC_RP	13
#define		LM_SLC_LNEXT	14
#define		LM_SLC_XON	15
#define		LM_SLC_XOFF	16
#define		LM_SLC_FORW1	17
#define		LM_SLC_FORW2	18
#define		LM_SLC_MCL	19
#define		LM_SLC_MCR	20
#define		LM_SLC_MCWL	21
#define		LM_SLC_MCWR	22
#define		LM_SLC_MCBOL	23
#define		LM_SLC_MCEOL	24
#define		LM_SLC_INSRT	25
#define		LM_SLC_OVER	26
#define		LM_SLC_ECR	27
#define		LM_SLC_EWR	28
#define		LM_SLC_EBOL	29
#define		LM_SLC_EEOL	30

#define		LM_SLC_DEFAULT		3
#define		LM_SLC_VALUE		2
#define		LM_SLC_CANTCHANGE	1
#define		LM_SLC_NOSUPPORT	0
#define		LM_SLC_LEVELBITS	3

#define		LM_SLC_ACK		128
#define		LM_SLC_FLUSHIN		64
#define		LM_SLC_FLUSHOUT		32

#define	LM_EOF		236
#define	LM_SUSP		237
#define	LM_ABORT	238

#endif
