#include "fix.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <assert.h>

#include "../telnet.h"
#include "telnet.h"
#include "telnet-fsm.h"


/* dumps in initial values into a tnstat struct */
void init_tnstat(struct tnstat *p)
{
	int i;
	struct tnopt *q;

	assert(p != NULL);

	p->sock = -1;
	p->state = 0;
	p->buff[0] = '\0';
	p->buffpos = 0;
	p->sbstate = -1;
	p->sbbuff[0] = '\0';
	p->sbbuffpos = 0;
	p->store = 0;
	p->lastchar = 0;
	p->waitcr = 0;
	p->synch = 0;
	p->filter = 0;
	p->eolbuff = 0;
	p->echochars = 0;
	p->parser = NULL;
	p->naws_cb = NULL;
	p->kill = NULL;
	p->changeopt = NULL;
	for (i = 0; i < NCHARS; i++)
	{
		q = &(p->opt[i]);
		q->us = NO;
		q->usq = EMPTY;
		q->them = NO;
		q->themq = EMPTY;
		q->weshould = 0;
		q->theyshould = 0;
	}
	for (i = 0; i < NCHARS; i++)
	{
		q = &(p->sub_opt[i]);
		q->us = NO;
		q->usq = EMPTY;
		q->them = NO;
		q->themq = EMPTY;
		q->weshould = 0;
		q->theyshould = 0;
	}
#ifdef DEBUG_TELNET
	p->debuglevel = NONE;
	p->debugstream = NULL;
#endif
	p->lm.mode = 0;
	p->lm.wantmode = 0;
}


/* create memory for tnstat struct */
struct tnstat *new_tnstat(void)
{
	struct tnstat *p;

	if ((p = (struct tnstat *) malloc(sizeof(struct tnstat))) != NULL)
		 init_tnstat(p);

	return p;
}


/* set the parser function */
void tnsetparser(struct tnstat *tn, void (*parser) (unsigned char *))
{
	tn->parser = parser;
}


/* set the kill function */
extern void tnsetkill(struct tnstat *tn, void (*tn_kill) (void))
{
	tn->kill = tn_kill;
}


/* set the changeopt function */
void tnsetchangeopt(struct tnstat *tn,
			void (*changeopt) (struct tnstat *, enum tnoset, unsigned char tnoption))
{
	tn->changeopt = changeopt;
}


/* set the NAWS callback function */
void tnsetnaws_cb(struct tnstat *tn, void (*naws_cb)(int, int))
{
	tn->naws_cb = naws_cb;
}


#ifdef DEBUG_TELNET
/* if we dont want debugging information to go to this->sock, let it go 
   to the stream set with this instead */
void tnsetdebugstream(struct tnstat *this, FILE *stream)
{
	this->debugstream = stream;
}
#endif


/* allow us to set some options up */
void tnsetstat(struct tnstat *tn, enum tnsstat opt, int value)
{
	assert(tn != NULL);

	switch (opt)
	{
	case SOCKET:
		tn->sock = value;
		break;
	case FILTERCHAR:
		tn->filter = value;
		break;
	case BUFFEREOL:
		tn->waitcr = 0;
		tn->eolbuff = value;
		break;
	case ECHOCHARS:
		tn->echochars = value;
		break;
#ifdef DEBUG_TELNET
	case DEBUG:
		tn->debuglevel = value;
		break;
#endif
	default:
		break;
	}
}


/* return the current setting */
int tngetstat(struct tnstat *tn, enum tnsstat opt)
{
	assert(tn != NULL);

	switch (opt)
	{
	case SOCKET:
		return tn->sock;
	case FILTERCHAR:
		return tn->filter;
	case BUFFEREOL:
		return tn->eolbuff;
	case ECHOCHARS:
		return tn->echochars;
#ifdef DEBUG_TELNET
	case DEBUG:
		return tn->debuglevel;
#endif
	default:
		break;
	}
	return -1;
}


void tn_lm_mode_set(struct tnstat *ptr)
{
	sb_lm_mode_set(ptr, LM_EDIT | LM_TRAPSIG);
}


#ifdef DEBUG_TELNET
extern void debug_write(struct tnstat *ptr, char *buff, int size);
#endif

/* Returns 1 if data read ok, else it returns 0 */
void tnreadsocket(struct tnstat *ptr)
{
	int len, i;
	unsigned char tn_inpstr[TNBUFFERSIZE];

	tn_inpstr[0] = '\0';
	if ((len = read(ptr->sock, tn_inpstr, sizeof(tn_inpstr))) <= 0)
	{
		if (ptr->kill != NULL)
			(void) (ptr->kill) ();
		return;
	}

#if	0
#ifdef DEBUG_TELNET
	if (ptr->debuglevel == PROGRAMMER)
	{
		char tndmess[80];

		sprintf(tndmess, "[%s: Got %d bytes]", PROGNAME, len);
		debug_write(ptr, tndmess, strlen(tndmess));
	}
#endif
#endif

	for (i = 0; i < len; ++i)
		tndata(ptr, tn_inpstr[i]);

	if (!ptr->eolbuff && ptr->buffpos != 0)
	{
		if (ptr->parser != NULL)
			(ptr->parser) (ptr->buff);
		ptr->buffpos = 0;
		ptr->buff[0] = '\0';
	}
}
