#ifndef TELNET_FSM_H
#define TELNET_FSM_H 1

#include <limits.h>

#define TNBUFFERSIZE	1024
#define TNSB_BUFFERSIZE	256

#define NCHARS		(UCHAR_MAX + 1)	/* no. of valid chars	*/

#define TINVALID	UCHAR_MAX		/* invalid transition	*/
#define FSINVALID	UCHAR_MAX		/* invalid state		*/
#define ANYCHAR		(NCHARS + 1)	/* match any character	*/

typedef unsigned char ttable[NCHARS];
typedef ttable (*ttable_ptr);

#define NO			0
#define WANTNO		1
#define YES			2
#define WANTYES 	3

#define EMPTY		0
#define OPPOSITE	1

struct tnopt {
	unsigned int us			: 2;	/* holds NO/WANTNO/YES/WANTYES	*/
	unsigned int usq		: 1;	/* holds EMPTY/OPPOSITE		*/
	unsigned int them		: 2;	/* holds NO/WANTNO/YES/WANTYES	*/
	unsigned int themq		: 2;	/* holds EMPTY/OPPOSITE		*/
	unsigned int weshould	: 1;	/* if asked shall we enable?	*/
	unsigned int theyshould	: 1;	/* if offered should they enable? */
};

struct tn_linemode {
    unsigned char mode;         /* current mode */
    unsigned char wantmode;     /* wanted mode */
};

struct	tnstat {
	/* All these can be set using the interface */
	int sock;						/* socket associated with options	*/
	unsigned int filter		: 1;	/* only allow ASCII characters through?	*/
	unsigned int eolbuff	: 1;	/* output lines as they come or buffer until eol */
	unsigned int echochars  : 1;    /* send every character back up the socket */

	/* These are private */
	unsigned int waitcr	: 1;
	unsigned int synch	: 1;
	short int state;		/* current fsm state		*/
	short int sbstate;		/* current subneg fsm state	*/
    unsigned char store;	/* temp storage				*/
	unsigned char lastchar;	/* last real character input*/

    void (*kill)(void);
	void (*parser)(unsigned char *);
    void (*changeopt)(struct tnstat *, enum tnoset, unsigned char tnoption);
    void (*naws_cb)(int width, int height);

#ifdef DEBUG_TELNET
	enum tndebug debuglevel;	/* amount of debugging information */
	FILE* debugstream;			/* if NULL use this->sock	*/
#endif

    unsigned char buff[TNBUFFERSIZE];	/* input buffer			*/
    int buffpos;						/* position within buffer	*/

    unsigned char sbbuff[TNSB_BUFFERSIZE];	/* sub-negotiation buffer	*/
    int sbbuffpos;							/* position within buffer	*/

	struct tnopt opt[NCHARS];		/* ALL options			*/
	struct tnopt sub_opt[NCHARS];	/* ALL sub-negotiation options	*/
	struct tn_linemode lm;      	/* storage for linemode negotiation */
};

extern void tndata(struct tnstat *ptr, unsigned char c);
extern void sb_lm_mode_set(struct tnstat *ptr, unsigned char mode);

#endif
