#ifndef BD_TELNETLIB
#define BD_TELNETLIB 1

#include <stdio.h>

/***********************************************************************/
/* Please skip this to get to the API as ISO C does not permit forward */
/* references to enums                                                 */
/* RFC's to note:                                                      */
/* RFC 1700 - Options came from here                                   */
/* RFC 1143 - The Q Method of Implementing TELNET Option Negotiation   */
/* RFC 854  - Telnet Protocl Specification                             */
/***********************************************************************/
enum tnoption
{
  TNBinaryTransmission                = 0,   /* RFC 856, JBP           */
  TNEcho                              = 1,   /* RFC 857, JBP           */
  TNReconnection                      = 2,   /* NIC 50005, JBP         */
  TNSuppressGoAhead                   = 3,   /* RFC 858, JBP           */
  TNApproxMessageSizeNegotiation      = 4,   /* ETHERNET, JBP          */
  TNStatus                            = 5,   /* RFC 859, JBP           */
  TNTimingMark                        = 6,   /* RFC 860, JBP           */
  TNRemoteControlledTransAndEcho      = 7,   /* RFC 726, JBP           */
  TNOutputLineWidth                   = 8,   /* NIC 50005, JBP         */
  TNOutputPageSize                    = 9,   /* NIC 50005, JBP         */
  TNOutputCarraigeReturnDispostion    = 10,  /* RFC 652, JBP           */
  TNOutputHorizontalTabStops          = 11,  /* RFC 653, JBP           */
  TNOutputHorizontalTabDisposition    = 12,  /* RFC 654, JBP           */
  TNOutputFormfeedDisposition         = 13,  /* RFC 655, JBP           */
  TNOutputVerticalTabStops            = 14,  /* RFC 656, JBP           */
  TNOutputVerticalTabDisposition      = 15,  /* RFC 657, JBP           */
  TNOutputLinefeedDisposition         = 16,  /* RFC 657, JBP           */
  TNExtendedASCII                     = 17,  /* RFC 698, JBP           */
  TNLogout                            = 18,  /* RFC 727, MRC           */
  TNByteMacro                         = 19,  /* RFC 735, JBP           */
  TNDataEntryTerminal                 = 20,  /* RFC 1043, RFC 732, JBP */
  TNSUPDUP                            = 21,  /* RFC 736, RFC 734, MRC  */
  TNSUPDUPOutput                      = 22,  /* RFC 749, MRC           */
  TNSendLocation                      = 23,  /* RFC 779, EAK1          */
  TNTerminalType                      = 24,  /* RFC 1091, MS56         */
  TNEndOfRecord                       = 25,  /* RFC 885, JBP           */
  TNTACACSUserIdentification          = 26,  /* RFC 927, BA4           */
  TNOutputMarking                     = 27,  /* RFC 933, SXS           */
  TNTerminalLocationNumber            = 28,  /* RFC 946, RN6           */
  TNTelnet3270Regime                  = 29,  /* RFC 1041, JXR          */
  TNX3PAD                             = 30,  /* RFC 1053, SL70         */
  TNNegotiateAboutWindowSize          = 31,  /* RFC 1073, DW183        */
  TNTerminalSpeed                     = 32,  /* RFC 1079, CLH3         */
  TNRemoteFlowControl                 = 33,  /* RFC 1372, CLH3         */
  TNLineMode                          = 34,  /* RFC 1184, DB14         */
  TNXDisplayLocation                  = 35,  /* RFC 1096, GM23         */
  TNEnvironmentOption                 = 36,  /* RFC 1408, DB14         */
  TNAuthenticationOption              = 37,  /* RFC 1409, DB14         */
  TNEncryptionOption                  = 38,  /* DB14                   */
  TNNewEnvironmentOption              = 39,  /* RFC 1572, DB14         */
  TNTN3270E                           = 40,  /* RFC 1647,              */
  TNExtendedOptionsList               = 255  /* RFC 861, JBP           */
};


         /***************************************************/
         /*                   IMPORTANT                     */  
         /* You have to declare the following item yourself */
         /***************************************************/


/************************************************************************/
/* Declare and set the next variable yourself                           */
/* Note, it should not be NULL and must be less than 30 characters long */
/************************************************************************/
extern char* PROGNAME;


       /*******************************************************/
       /* The rest of the functions are provided for your use */
       /*******************************************************/


/******************************************************/
/* Please allow your users access to this information */
/* Max length is 40 chars                             */
/******************************************************/
extern char* TELNETVERSION;


/****************************************/
/* Constructor and destructor functions */
/****************************************/
extern int init_telnet(void);
extern void cleanup_telnet(void);


/***********************************************************************/
/* Constructor and initialiser for tnstat structure. Its destructor is */
/* simply free() and you call that yourself. Each telneted socket will */
/* need its own tnstat structure and you can use the provided utility  */
/* functions to manipulate its options                                 */
/***********************************************************************/
extern struct tnstat* new_tnstat(void);
extern void init_tnstat(struct tnstat*);


/****************************************************************************/
/* If DEBUG_TELNET is #defined (this can be done from the MakeVars file)    */
/* then you can use tnsetdebugstream() to redirect the debugging            */
/* information. This is usually sent down the same socket as is read from.  */
/* While this is acceptable for servers, clients may wish to redirect to    */
/* stderr or stdout. Thus if you can use this to set a STREAM to output to. */
/* Default setting is NULL, which automatically sends the information down  */
/* the socket.                                                              */
/****************************************************************************/
#ifdef DEBUG_TELNET
extern void tnsetdebugstream(struct tnstat*, FILE*);
#endif


/***************************************************************************/
/* Set telnet option independant options for the telnet fsm. You can also  */
/* retreive the current settings. The options are as follows:              */
/* SOCKET - the socket fd that the routines use for input and maybe output */
/* FILTERCHAR - if set then ignore non-printable ASCII characters as       */
/*              defined by the C function isprint()                        */
/* BUFFEREOL  - if set then buffer input until CR-LF is seen, if not set   */
/*              then parse input in the chunks that it is received         */
/* DEBUG      - ONLY accessable if DEBUG_TELNET is #defined. This lets     */
/*              you set the debuging level to a enum tndebug               */
/* Default values are: INDEX == -1, SOCKET == -1, FILTERCHAR == 0,         */
/* BUFFEREOL == 0, DEBUG == NONE                                           */
/***************************************************************************/
#ifdef DEBUG_TELNET
enum tnsstat { SOCKET, FILTERCHAR, BUFFEREOL, ECHOCHARS, DEBUG };
enum tndebug { NONE, ERRORS, WARNINGS, VERBOSE, PROGRAMMER };
#else
enum tnsstat { SOCKET, FILTERCHAR, BUFFEREOL, ECHOCHARS };
#endif
extern void tnsetstat(struct tnstat*, enum tnsstat, int);
extern int  tngetstat(struct tnstat*, enum tnsstat);

/**************************************************************************/
/* Set and Get settings for the various Telnet Options.                   */
/* WEARE       - we want to be able to enable the option                  */
/* WEARENT     - we are going to disable the option                       */
/* WEWOULD     - if asked to enable we would                              */
/* WEWOULDNT   - if asked to enable we wouldn't                           */
/* THEYARE     - we want them to enable the option                        */
/* THEYARENT   - they will disable the option                             */
/* THEYWOULD   - if they offer they may enable the option                 */
/* THEYWOULDNT - if they offer they may not enable the option             */
/* Default settings: WEARENT WEWOULDNT THEYARENT THEYSHOULDNT             */
/* Note: If you try to set an option that is refused or you are already   */
/* doing then your program is not told about it. You are only informed of */
/* a change in option by the function tnchangedopt() as declared by you   */
/* (see the top of this file for its prototype).                          */
/**************************************************************************/
enum tnoset  { WEARE,   WEARENT,   WEWOULD,    WEWOULDNT,
               THEYARE, THEYARENT, THEYSHOULD, THEYSHOULDNT };
extern void tnsetopt(struct tnstat*, enum tnoption, enum tnoset);
extern int  tngetopt(struct tnstat*, enum tnoption, enum tnoset);


/***************************************************************************/
/* Call tnreadsocket() after a select() to read and parse data from a      */
/* socket.                                                                 */
/* Call tnsynch() if your select() call signifies urgent data, note that   */
/* the socket be set to OOBINLINE                                          */
/***************************************************************************/
extern void tnreadsocket(struct tnstat*);
extern void tnsynch(struct tnstat*);


/***************************************************************************/
/* Each tnstruct has one pointer to a higher level data structure and three*/
/* pointers to functions. You can set these pointers using the following   */
/* functions.                                                              */
/* tnsetkill:      The function used to destroy a netdead connection.      */
/* tnsetparser:    This is called when the buffer needs parsing, which     */ 
/*                 itself is dependent upon some tnsetopt() options.       */
/* tnsetchangeopt: This function is called whenever a telnet option has    */
/*                 changed.                                                */
/* tnsetnaws_cb:   This function is called upon receipt of a notification  */
/*                 about a change in the size of the clients screen.       */
/* The function changeopt() is called whenever a telnet option changes to  */
/* one of the following states: WEARE, WEARENT, THEYARE, THEYARENT, its    */
/* arguments are a pointer to the telnet status structure, the new state   */
/* and the option that has changed.                                        */
/***************************************************************************/
extern void tnsetkill(struct tnstat*, void (*kill)(void));
extern void tnsetparser(struct tnstat*, void (*parser)(unsigned char *));
extern void tnsetchangeopt(struct tnstat*,
            void (*changeopt)(struct tnstat*, enum tnoset, unsigned char tnoption));
extern void tnsetnaws_cb(struct tnstat*, void (*naws_cb)(int, int));

/*********************************************************/
/* send out IAC SB LINEMODE MODE (EDIT | TRAPSIG) IAC SE */
/* NOTE: Linemode negotiation is not supported, so this  */
/* is only a quick botch, hence the name. Call this      */
/* function from your changeopt() funtion sent to        */
/* tnreadsocket()                                        */
/*********************************************************/
extern void tn_lm_mode_set(struct tnstat*);

#endif
